<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Stream Targets</h4>
<p>Use this feature to send incoming live source streams to one or more destinations that re-distribute the source streams to users. You can send source streams to destinations such as Wowza Streaming Cloud&#8482;, content delivery networks (CDNs), and even to other Wowza Streaming Engine instances. Stream target destinations allow you to scale and add redundancy to your live streaming workflow. For more information, see <a href="https://www.wowza.com/docs/how-to-push-streams-to-cdns-and-other-services-push-publishing" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Use CDNs and services to distribute live streams from Wowza Streaming Engine</a>.</p>

<p>To direct your live source stream to a stream target destination, click <strong>Add Stream Target</strong>, and then follow the instructions. After you finish adding a stream target, it's displayed alphabetically by destination, protocol, and then stream target name.</p>

<p>For each stream target in the list, you can perform the following actions to manage it:</p>
	<ul>
		<li>To edit the stream target settings, click the <strong>Edit</strong> icon.</li>
		<li>To make a copy of the stream target, click the <strong>Copy</strong> icon. In the <strong>Copy Stream Target</strong> dialog box, specify a unique name for the copied stream target as two stream targets can't have the same name.</li>
		<li>To turn on a stream target so it can send the source stream to its configured destination, click the <strong>Enable</strong> icon. To turn off delivery of the source stream from the stream target to its destination, click the <strong>Disable</strong> icon.</li>
		<li>To restart a stream target, click the <strong>Restart</strong> icon. Often, this will solve connection failures between the stream target and its destination.</li>
		<li>To delete the stream target, click the <strong>Delete</strong> icon.</li>
	</ul>

<p>After you've created one or more stream targets, click <strong>Enable Stream Targets</strong> so that the Wowza Streaming Engine server can send your source stream from all enabled stream targets to their destinations. To stop sending your source stream from all of your enabled stream targets, click <strong>Disable Stream Targets</strong> and restart the application.</p>

<h5>About Stream Target Status</h5>
<p>For each stream target in the list, a status is displayed:
	<ul>
		<li><strong>Disabled.</strong> The target is disabled.</li>
		<li><strong>Waiting.</strong> An enabled target has this status if the Stream Targets feature is disabled. If the target and Stream Targets feature are both enabled, either the target's source stream isn't connected to the Wowza Streaming Engine input or the Wowza Streaming Engine instance hasn't finished initializing the connection to the target destination.</li>
		<li><strong>Active.</strong> The target is enabled and pushing the stream to the target destination.</li>
		<li><strong>Error.</strong> The target is enabled and an error occurred. Make sure the target's configured source stream is connected to the Wowza Streaming Engine input. Errors might be due to an invalid target configuration or issue with the destination server.</li>
	</ul>

<p>Each stream target's status is updated automatically. You can also click <strong>Refresh</strong> to update the status.</p>