<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<wmsform:setpagetitle page="mediaCache"/>

<c:set var="mediaCacheEnabled" >
	<wmsform:objvalue page="mediaCache" obj="mediaCacheEnabled"/>
</c:set>
<div>
	<div class="row">
		<div id="generic.warnings" class="alert alert-warning" style="display:none"></div>
		<c:forEach var="msg" items="${formData.genericMessages}">
					<div class="alert alert-success">
						<strong>${msg}</strong>
					</div> 
		</c:forEach>
	</div>
	<div class="row">
		<div class="col-md-12">
			<happ><wmsform:getlocalestring page="servermediacache" obj="header" /></happ>
			<br>
		</div>
	</div>
	<div>
	<hr>
	</div>
	<div class="row">
		<div class="col-md-12">
			<wmsform:getlocalestring page="mediaCache" obj="header" defaultStr=" "/>
			<c:choose>
				<c:when test="${mediaCacheEnabled}">
					<h5><wmsform:getlocalestring page="mediaCache" obj="enabledMessage"/></h5>
				</c:when>
				<c:otherwise>
					<h5><wmsform:getlocalestring page="mediaCache" obj="disabledMessage"/></h5>
				</c:otherwise>
			</c:choose>
			<sec:authorize access="hasAnyRole('admin')">
					<p><c:choose>
						<c:when test="${mediaCacheEnabled}">
							<wmsform:button page="mediaCache" obj="disableMediaCacheBtn" onClick="javascript:disableMediaCache()" cssClass="btn btn-default"/>
						</c:when>
						<c:otherwise>
							<wmsform:button page="mediaCache" obj="enableMediaCacheBtn" onClick="javascript:enableMediaCache()" cssClass="btn btn-default"/>
						</c:otherwise>
					</c:choose></p>
			</sec:authorize>
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">
			<ul class="nav nav-tabs" >
				<li id="MediaCacheStores" class="active">
					<a href="javascript:showStoresTab()">Stores</a>
				</li>
				<li id="MediaCacheSources" >
					<a href="javascript:showSourcesTab()">Sources</a>
				</li>
				<sec:authorize access="hasAnyRole('advUser')">
					<li id="MediaCacheAdvanced" >
						<a href="javascript:showAdvTab()">Properties</a>
					</li>
				</sec:authorize>
			</ul>
		</div>
	</div>    
	<div class="row" id="tabContent">
		<div class="col-md-12">
			<div class="row">
				<div id="ViewMode">
					<div  id="TabStores">
						<jsp:include page="ViewStores.jsp" flush="true" />
					</div>
					<div id="TabSources" style="display:none">
						<jsp:include page="ViewSources.jsp" flush="true" />
				 	</div>
					<div id="TabAdv" style="display:none">
						<jsp:include page="ViewAdv.jsp" flush="true" />
				 	</div>
				 </div>
				 <div id="EditMode">
					<div id="TabEditStores" class="row">
                       	<div class="col-md-8 main-content">
                            <form:form method="post" commandName="formData" id="defaultFormStores"> 
								<wmsform:rightrailhideshow/>
                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                                <jsp:include page="EditStores.jsp" flush="true" />
                                <form:hidden path="ignoreWarnings" />	
                            </form:form>
                         </div>
                         <div id="HelpStores" class="col-md-4 well-help pull-right right-rail">
                             <jsp:include page="HelpStores_${formData.currentLocale}.jsp" flush="true" />
                         </div>
					</div>
					<div id="TabEditSources" style="display:none">
                       	<div class="col-md-8 main-content">
                            <form:form method="post" commandName="formData" id="defaultFormSources"> 
								<wmsform:rightrailhideshow/>
                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                                <jsp:include page="EditSources.jsp" flush="true" />
                                <form:hidden path="ignoreWarnings" />	
                            </form:form>
                         </div>
                         <div id="HelpSources" class="col-md-4 well-help pull-right right-rail">
                             <jsp:include page="HelpSources_${formData.currentLocale}.jsp" flush="true" />
                         </div>
					</div>
                    <div id="TabEditAdv" style="display:none">
                       	<div class="col-md-12">
                               <form:form method="post" commandName="formDataAdv" id="defaultFormAdv"> 
                                   <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		                            <jsp:include page="EditAdv.jsp" flush="true" />
                                   <form:hidden path="ignoreWarnings" />	
                               </form:form>
                           </div>
                    </div>
			 	</div>
			</div>
		</div>
	</div>
   	<wmsform:setwarnings/>	
	<wmsdialog:restartserver page="serversetup" returnPage="mediaCache"/>
</div>

<script>
$(document).ready(function() {
	
	if(typeof(lastTab) === 'undefined') {
		lastTab="Stores";
	}
	if("${lastTab}" != "")
	{
		lastTab="${lastTab}";	
	}
		
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();	
		$('#EditMode').show();
		$('#MediaCacheButtons').hide();				
	}
	else 
	{
		$('#ViewMode').show();		
		$('#EditMode').hide();		
		$('#MediaCacheButtons').show();				
	}
	if(lastTab=="Sources")
	{
		showSourcesTab();
	}
	else if(lastTab=="Advanced")
	{
		showAdvTab();
	}
	else 
	{
		showStoresTab();		
	}
	lastMediaCacheStore="";
	//createCookie("lastMediaCacheStore",lastMediaCacheStore);
	lastMediaCacheSource="";
	//createCookie("lastMediaCacheSource",lastMediaCacheSource);
});

function showStoresTab() {
	if("${mode}"=="edit" && lastTab!='Stores')
	{
		lastTab='Stores';
		//loadServerSetup();
		return;
	}
	lastTab='Stores';
	createCookie("lastTab",lastTab);
	$('#TabStores').show();
	$('#TabEditStores').show();
	$('#HelpStores').show();
	$('#TabAdv').hide();
	$('#TabEditAdv').hide();
	$('#TabSources').hide();
	$('#TabEditSources').hide();
	$('#MediaCacheStores').addClass('active');
	$('#MediaCacheSources').removeClass();
	$('#MediaCacheAdvanced').removeClass();
}

function showSourcesTab() {
	if("${mode}"=="edit" && lastTab!='Sources')
	{
		lastTab='Sources';
		//loadServerSetup();
		return;
	}
	lastTab='Sources';
	createCookie("lastTab",lastTab);
	$('#TabStores').hide();
	$('#TabEditStores').hide();
	$('#HelpStores').hide();
	$('#TabAdv').hide();
	$('#TabEditAdv').hide();
	$('#TabSources').show();
	$('#TabEditSources').show();
	$('#MediaCacheStores').removeClass();
	$('#MediaCacheAdvanced').removeClass();
	$('#MediaCacheSources').addClass('active');	
}

function showAdvTab() {
	if("${mode}"=="edit" && lastTab!='Advanced')
	{
		lastTab='Advanced';
		//loadServerSetup();
		return;
	}
	lastTab='Advanced';
	createCookie("lastTab",lastTab);
	$('#TabStores').hide();
	$('#TabEditStores').hide();
	$('#HelpStores').hide();
	$('#TabAdv').show();
	$('#TabEditAdv').show();
	$('#TabSources').hide();
	$('#TabEditSources').hide();
	$('#MediaCacheStores').removeClass();
	$('#MediaCacheAdvanced').addClass('active');	
	$('#MediaCacheSources').removeClass();
}


function disableMediaCache()
{
	loadAjaxMainContent("server/mediacache/disable.htm", ""); 	
}

function enableMediaCache()
{
	loadAjaxMainContent("server/mediacache/enable.htm", ""); 	
}
</script>






