<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<c:if test="${empty smilStreamName}">
	<c:set var="smilStreamName" value="[new]"/>
</c:if>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<c:choose>
			<c:when test="${empty appType}">
				<div class="col-md-12">
					<happ><wmsform:getlocalestring page="smilFiles" obj="head"/> > ${wmsutil:escapeHtml(smilName)}.smil > ${wmsutil:escapeHtml(smilStreamName)}</happ><br>
					<small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
				</div>
			</c:when>
			<c:otherwise>
				<div class="col-md-5">
					<happ>${wmsutil:escapeHtml(appName)} > ${wmsutil:escapeHtml(smilName)}.smil > ${wmsutil:escapeHtml(smilStreamName)}</happ><br>
					<small class="text-muted">${uiAppType}</small>
				</div>
				<wmsform:applicationbuttons page="${page}"/>
			</c:otherwise>
		</c:choose>
	</div>
	<p><a href="javascript:returnSMILFile()"><i class="fa fa-arrow-left"></i> Return to SMIL File</a></p>

	<sec:authorize access="hasAnyRole('advUser')">
		<div class="row">
			<div class="col-md-12">
				<ul class="nav nav-tabs" >
					<li id="SMILFileStreamBasic" class="active">
						<a href="javascript:showBasicTab('transition')">Basic</a>
					</li>
					<li id="SMILFileStreamAdvanced" >
						<a href="javascript:showAdvTab('transition')">Properties</a>
					</li>
				</ul>
			</div>
		</div>
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('advUser')">
		<hr>
	</sec:authorize>
	<div class="row" id="tabContent">
		<div class="col-md-12">
			<div class="row">
				<div id="ViewMode">
					<div id="TabBasic" style="display:none">
						<jsp:include page="ViewBasic.jsp" flush="true" />
					</div>
					<div id="TabAdv" style="display:none">
						<jsp:include page="ViewAdv.jsp" flush="true" />
					</div>
				</div>
				<div id="EditMode">
					<div  id="TabEditBasic" style="display:none">
						<div class="col-md-8 main-content">
							<form:form method="post" commandName="formData" id="defaultForm">
								<wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
								<wmsform:rightrailhideshow/>
								<form:hidden path="ignoreWarnings" />
								<jsp:include page="EditBasic.jsp" flush="true" />
							</form:form>
						</div>
						<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
							<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
						</div>
					</div>
					<div id="TabEditAdv" style="display:none">
						<div class="col-md-12">
							<form:form method="post" commandName="formDataAdv" id="defaultFormAdv">
								<wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
									<jsp:include page="EditAdv.jsp" flush="true" />
								<form:hidden path="ignoreWarnings" />
							</form:form>
						</div>
					</div>
			 	</div>
			</div>
		</div>
	</div>
	<wmsform:setwarnings/>
</div>

<script>
$(document).ready(function() {
	if(typeof(lastTab) === 'undefined') {
		lastTab="Basic";
	}

	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();
		$('#EditMode').show();
		$('#AppButtons').hide();
	}
	else
	{
		$('#ViewMode').show();
		$('#EditMode').hide();
		$('#AppButtons').show();
	}
	if("${idx}"=="-1")
	{
		lastTab='Basic';
		showBasicTab('new');
		$('#SMILFileStreamAdvanced').hide();
	}
	else if(lastTab=="Advanced")
	{
		showAdvTab('new');
	}
	else
	{
		showBasicTab('new');
	}
});

function showBasicTab(event) {
	if (event == "transition")
	{
		lastTab='Basic';
		showSMILStream();
	}
	else
	{
		if("${mode}"=="edit" && lastTab!='Basic')
		{
			lastTab='Basic';
			showSMILStream();
		}
		lastTab='Basic';
		createCookie("lastTab",lastTab);
		$('#TabBasic').show();
		$('#TabEditBasic').show();
		$('#TabAdv').hide();
		$('#TabEditAdv').hide();
		$('#SMILFileStreamBasic').addClass('active');
		$('#SMILFileStreamAdvanced').removeClass();
	}
}

function showAdvTab(event) {
	if (event == "transition")
	{
		lastTab='Advanced';
		showSMILStream();
	}
	else
	{
		if("${mode}"=="edit" && lastTab!='Advanced')
		{
			lastTab='Advanced';
			showSMILStream();
		}
		lastTab='Advanced';
		createCookie("lastTab",lastTab);
		$('#TabBasic').hide();
		$('#TabEditBasic').hide();
		$('#TabAdv').show();
		$('#TabEditAdv').show();
		$('#SMILFileStreamBasic').removeClass();
		$('#SMILFileStreamAdvanced').addClass('active');
	}
}

function returnSMILFile()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/smilfile/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&smilFile=${wmsutil:urlEncode(smilName)}");
	}
	else
	{
		loadAjaxMainContent("applications/${appType}/smilfile/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&smilFile=${wmsutil:urlEncode(smilName)}");
	}
}

</script>

