<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="showPath" required="false" rtexprvalue="true" %>

<c:if test="${ empty showPath}">
	<c:set var="showPath" value="true"/>
</c:if>

<div id="addAdvancedModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="addAdvancedModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="newAdvancedForm" class="form-modal"> 
				<fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:addAdvancedClose()">x</button>
					<h4 id="addAdvancedModalLabel" class="modal-title"><wmsform:getlocalestring page="newPropertyAdv" obj="header"/></h4>
				  </div>
				  <div class="modal-body">
					<c:if test="${showPath}">
						<wmsform:editpropertydropdown page="newPropertyAdv" obj="advPath" cssClassTitle="control-label"/>
					</c:if>
					<wmsform:editproperty page="newPropertyAdv" obj="advName" cssClassTitle="control-label" required="yes" bind="false" cssClass="form-control"/>
					<wmsform:editpropertydropdown page="newPropertyAdv" obj="advType" cssClassTitle="control-label" options="String,Integer,Boolean" bind="false"/>
					<wmsform:editproperty page="newPropertyAdv" obj="advValue" cssClassTitle="control-label" required="yes" bind="no" cssClass="form-control"/>
				  </div>
				  <div class="modal-footer">
					<div class="row">
						<div class="col-md-8">
							<div id="newAdvanced.error" class="alert alert-danger" style="display:none"></div>
						</div>
						<div class="col-md-4">
							<wmsform:buttoncancel  onClick="javascript:addAdvancedClose()"/>
							<wmsform:buttonadd  onClick="javascript:doAddAdvanced()"/>
						</div>
					</div>
				  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<c:set var="AdvNameError">
	<wmsform:getlocalestring page="newPropertyAdv" obj="advName.empty"/>
</c:set>
<c:set var="AdvNameDuplicate">
	<wmsform:getlocalestring page="newPropertyAdv" obj="advName.duplicate"/>
</c:set>
<c:set var="AdvValueError">
	<wmsform:getlocalestring page="newPropertyAdv" obj="advValue.empty"/>
</c:set>
<script>
function addAdvancedShow() {
	$("#newAdvanced.error").html(""); 
	$("#newAdvanced.error").hide();
	$("#advName").val("");
	$("#advValue").val("");
	<c:if test="${showPath}">
		$("#advPath").prop("selectedIndex",0);
	</c:if>
	$("#advType").prop("selectedIndex",0);
	$("#advNameCtrlGroup").attr('class', 'form-group');
	$("#advNameErrorMsg").html("");
	$("#advNameErrorMsg").hide();
	$("#advValueCtrlGroup").attr('class', 'form-group');
	$("#advValueErrorMsg").html("");
	$("#advValueErrorMsg").hide();

	$('#addAdvancedModal').on('shown.bs.modal', function() {
	});
	$('#addAdvancedModal').modal('show');	
}

function addAdvancedClose() {
	$('#addAdvancedModal').modal('hide');
}

function doAddAdvanced() {
	//need to check values
	var ok=true;
	$("#advNameCtrlGroup").attr('class', 'form-group');
	$("#advNameErrorMsg").html("");
	$("#advNameErrorMsg").hide();
	$("#advValueCtrlGroup").attr('class', 'form-group');
	$("#advValueErrorMsg").html("");
	$("#advValueErrorMsg").hide();

	var name = $("#advName").val().replace(/^\s+|\s+$/g,"");
	var path = "";
	<c:if test="${showPath}">
		path = $("#advPath").val().replace(/^\s+|\s+$/g,"");
	</c:if>
	var val = $("#advValue").val().replace(/^\s+|\s+$/g,"");
	if(name == "")
	{
		$("#advNameCtrlGroup").attr('class', 'form-group has-error');
		$("#advNameErrorMsg").html("${AdvNameError}");
		$("#advNameErrorMsg").show();
		ok=false;
	}
	else if(checkIfPropertyExists(name, path ))
	{
		$("#advNameCtrlGroup").attr('class', 'form-group has-error');
		$("#advNameErrorMsg").html("${AdvNameDuplicate}");
		$("#advNameErrorMsg").show();
		ok=false;
	}
	if( val == "")
	{
		$("#advValueCtrlGroup").attr('class', 'form-group has-error');
		$("#advValueErrorMsg").html("${AdvValueError}");
		$("#advValueErrorMsg").show();
		ok=false;
	}
	if(!ok)
	{
		return;	
	}
	var newItem = new Object();
	newItem.orgIdx = tblIdxProperties++;
	newItem.added=true;
	newItem.removed=false;
	newItem.enabled=true;
	newItem.name=name;
	newItem.type=$("#advType").val();
	
	newItem.value=val;
	if (newItem.type =="Boolean")
	{
		boolValue = false;
		str = newItem.value.toLowerCase();
		boolValue |= str.substring(0,1)=="y";
		boolValue |= str.substring(0,1)=="t";
		boolValue |= str.substring(0,1)=="1";
		if(boolValue)
		{
			newItem.value='true';
			newItem.uiBooleanValue=true;
		}
		else {
			newItem.value='false';
			newItem.uiBooleanValue=false;
		}
	}
	if (newItem.type =="Integer")
	{
		newItem.value = parseInt(newItem.value);
		if(isNaN(newItem.value))
		{
			newItem.value="0";	
		}
	}
	newItem.section=path;
	newItem.sectionName=newItem.section;	
	newItem.documented=false;
	tblDataProperties.push(newItem);
	addAdvancedClose();
	updateTableProperties();
}

</script>
