<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteStreamFileModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteStreamFileModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteStreamFileClose()">x</button>
						<h4 id="deleteStreamFileModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteStreamFileDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteStreamFileDialog.message"/> <b><span id="deleteStreamFileName"></span></b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteStreamFileDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteStreamFileClose()"/>
						<wmsform:buttonok  onClick="javascript:doDeleteStreamFile()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>

function deleteStreamFileShow() {
	$('#deleteStreamFileName').text(deleteStreamFileName);
	//document.getElementById("deleteStreamFileName").innerHTML=deleteSmileFileName;
	$('#deleteStreamFileModal').on("shown.bs.modal", function() {
	});
	$('#deleteStreamFileModal').modal('show');	
}

function deleteStreamFileClose() {
	$('#deleteStreamFileModal').modal('hide');
}

function doDeleteStreamFile() {
	$('#deleteStreamFileModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent('server/vhost/streamfile/delete.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&streamFileName='+encodeURIComponent(deleteStreamFileName));
	});
	deleteStreamFileClose();
	return;
}

</script>
