<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="disableStatsModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="disableStatsModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:disableStatsClose()">x</button>
					<h4 id="disableStatsModalLabel" class="modal-title"><wmsform:getlocalestring page="serversetup.statsDisable" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p><wmsform:getlocalestring page="serversetup.statsDisable" obj="message"/></p>
						<div class="alert alert-warning">
						<p><wmsform:getlocalestring page="serversetup.statsDisable" obj="warn"/></p>
						</div>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:disableStatsCancel()"/>
					<wmsform:buttonok  onClick="javascript:dodisableStats()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>

function disableStatsShow(appInstance, streamName) {
	if( $("input[name='statsEnabled']:checked").val()=='true')
    {
		disableStatsClose();
    }
    else 
    {
		$('#disableStatsModal').modal('show');
    }
}

function disableStatsClose() {
	$('#disableStatsModal').modal('hide');
}
function disableStatsCancel() {
	$("input[name='statsEnabled']").prop('checked','true');
	disableStatsClose();
}
function dodisableStats() {
	disableStatsClose();
}

</script>