<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="vhost" required="true" rtexprvalue="true" %>

<div id="startVHostModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="startVHostModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:startVHostClose()">x</button>
					<h4 id="startVHostModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="startVHostDialog.title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="startVHostDialog.message"/>${vhost}</p>
						<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="startVHostDialog.warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:startVHostClose()"/>
					<wmsform:buttonok  onClick="javascript:dostart()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>

function startVHostShow() {
	$('#startVHostModal').on("shown.bs.modal", function() {
	});
	$('#startVHostModal').modal('show');	
}

function startVHostClose() {
	$('#startVHostModal').modal('hide');
}

function dostart() {
	$('#startVHostModal').on('hidden.bs.modal', function() {
		postAJAXForm('vhost/start.htm','');
	});
	startVHostClose();
}

</script>