<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="stopRecordingModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="stopRecordingModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				<c:if test="${page=='appconfig.incomingstreams.details'}">
				    <form:hidden path="managedStream"/>
				    <form:hidden path="recordingSet"/>
			    </c:if>
				<div class="modal-header">
					<button type="button" class="close" onClick="javascript:stopRecordingClose()">x</button>
					<h4 id="stopRecordingModalLabel" class="modal-title"><wmsform:getlocalestring page="stopRecordingDialog" obj="title"/></h4>
				</div>
				<div class="modal-body">
					<p class="breakall"><wmsform:getlocalestring page="stopRecordingDialog" obj="message"/> <b><span id="stopRecorderName"></span></b>?</p>
				</div>
				<div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:stopRecordingClose()"/>
					<wmsform:buttonok  onClick="javascript:doStop()"/>
				</div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentInstance;
var currentRecorder;
var currentApp;

function stopRecordingShow(app, appInstance, recorderName) {
	$('#stopRecorderName').text(recorderName);
	currentApp=app;
	currentInstance=appInstance;
	currentRecorder=recorderName;
	$('#stopRecordingModal').on("shown.bs.modal", function() {});
	$('#stopRecordingModal').modal('show');	
}

function stopRecordingClose() {
	$('#stopRecordingModal').modal('hide');
}

function doStop() {
	$('#stopRecordingModal').on('hidden.bs.modal', function() {
		postAJAXForm('streamrecorder/${page}/stopRecording.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&instanceName='+encodeURIComponent(currentInstance)+'&recorder='+encodeURIComponent(currentRecorder)+'&returnPage=${page}'+'&parentPage='+incomingStreamDetailsParentPage);
	});
	stopRecordingClose();
}

</script>