<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="stopServerModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="stopServerModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:stopServerClose()">x</button>
					<h4 id="stopServerModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="stopServerDialog.title"/></h4>
				  </div>
				  <div class="modal-body">
						<p><wmsform:getlocalestring page="${page}" obj="stopServerDialog.message"/></p>
						<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="stopServerDialog.warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:stopServerClose()"/>
					<wmsform:buttonok  onClick="javascript:doStop()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>

function stopServerShow() {
	$('#stopServerModal').on("shown.bs.modal", function() {
	});
	$('#stopServerModal').modal('show');	
}

function stopServerClose() {
	$('#stopServerModal').modal('hide');
}

function doStop() {
	$('#stopServerModal').on('hidden.bs.modal', function() {
		$.ajax({
	        type: "POST",
	        url: "server/stop.htm",
	        data: "",
	        success: function(data) {
				if(data.substring(0, redirectLoginString.length)==redirectLoginString) {
					document.location = "login.htm" + location.hash;
				}
	        	location.href="ServerStopped.html";
				},
				error : function (jqXHR, textStatus, thrownError) {
					document.body.style.cursor = "default";
					displayErrorInMC(jqXHR, textStatus, thrownError,page);
				},
				complete: function(jqXHR, textStatus) {
					document.body.style.cursor = "default";
				}

		    });
	});
	stopServerClose();
}

</script>