<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="vhost" required="true" rtexprvalue="true" %>

<div id="stopVHostModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="stopVHostModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:stopVHostClose()">x</button>
					<h4 id="stopVHostModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="stopVHostDialog.title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="stopVHostDialog.message"/>${vhost}</p>
						<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="stopVHostDialog.warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:stopVHostClose()"/>
					<wmsform:buttonok  onClick="javascript:doStop()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>

function stopVHostShow() {
	$('#stopVHostModal').on("shown.bs.modal", function() {
	});
	$('#stopVHostModal').modal('show');	
}

function stopVHostClose() {
	$('#stopVHostModal').modal('hide');
}

function doStop() {
	$('#stopVHostModal').on('hidden.bs.modal', function() {
		postAJAXForm('vhost/stop.htm','');
	});
	stopVHostClose();
}

</script>