<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<%@ attribute name="name" required="true" rtexprvalue="true" %>
<%@ attribute name="onClick" required="true" rtexprvalue="true" %>
<%@ attribute name="btnClass" required="true" rtexprvalue="true" %>
<%@ attribute name="cssSize" required="false" rtexprvalue="true" %>
<%@ attribute name="cssRow" required="false" rtexprvalue="true" %>
<%@ attribute name="xtraStyles" required="false" rtexprvalue="true" %>

<re:mark>Display an image-button</re:mark>

<c:if test="${ empty cssSize }">
	<c:set var="cssSize" value="col-md-12"/>
</c:if>
<c:if test="${ empty cssRow }">
	<c:set var="cssRow" value="row"/>
</c:if>
<c:choose>
	<c:when test="${ !empty xtraStyles }">
		<c:set var="xtraStyles" value='style="${xtraStyles}"'/>
	</c:when>
	<c:when test="${ empty xtraStyles }">
		<c:set var="xtraStyles" value=""/>
	</c:when>
</c:choose>

<div class="${cssRow}">
	<div class="${cssSize}">
		<img class="${btnClass} ${xtraClasses}" ${xtraStyles} name="${name}Button" onClick="${onClick}"/>
	</div>
</div>

