<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="objName" required="true" rtexprvalue="true" %>
<%@ attribute name="objVar" required="true" rtexprvalue="true" %>
<%@ attribute name="title" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>

<re:mark>Display a listbox of current options allowing the user to add/remove items from a dropdown box</re:mark>
<!-- 
<re:mark>Get the tooltip based on objName and objVar</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip objName="${objName}" objVar="${objVar}" tooltip="${tooltip}"/>
</c:set>

<re:mark>Get the add button label, defaults to add</re:mark>
<c:set var="btn_add_label">
	<wmsform:getlocalebutton objName="${objName}" objVar="${objVar}"  button="add"/>
</c:set>

<re:mark>Get the remove button label, defaults to remove</re:mark>
<c:set var="btn_remove_label">
	<wmsform:getlocalebutton objName="${objName}" objVar="${objVar}"  button="remove"/>
</c:set>

<re:mark>Title</re:mark>
<label>
	<wmsform:getlocalestring objName="${objName}" objVar="${objVar}" title="${title}"/>
</label>

<re:mark>Dropdown list for new items</re:mark>
<c:set var="optionsList">
	<wmsform:objvaluearray objName="${objName}" objVar="${objVar}Options" />
</c:set>

<re:mark>We need the spring options from:select hidden.  When we submit the form, all options must be there</re:mark>
<form:select path="${objName}.${objVar}Options" size="5" style="display:none;">
	<c:forEach var="itemKey" items="${fn:split(optionsList,',')}">
		<option value="${fn:trim(itemKey)}" selected="selected">${fn:trim(itemKey)}</option>
	</c:forEach>
</form:select>

<c:set var="objValue">
	<wmsform:objvaluearray objName="${objName}" objVar="${objVar}" />
</c:set>

<div class="input-append">
	<select id="${objName}.${objVar}.newValue">
		<option value="" selected>--Select One--</option>
		<c:forEach var="itemKey" items="${fn:split(optionsList,',')}">
			<option value="${fn:trim(itemKey)}">${fn:trim(itemKey)}</option>
		</c:forEach>
	</select>
	<re:mark>Add button</re:mark>
	<input name="btnAdd${objName}${objVar}" type="button" class="btn btn-default" id="btnAdd${objName}${objVar}" onClick="javascript:addOption('${objName}.${objVar}');" value="${btn_add_label}" />
</div>

<re:mark>Get the current list</re:mark>
<c:set var="currentList">
	<wmsform:objvaluearray objName="${objName}" objVar="${objVar}" />
</c:set>

<re:mark>We need the spring from:select hidden.  When we submit the form, all options must be selected</re:mark>
<form:select path="${objName}.${objVar}" size="5" style="display:none;">
	<c:if test="${! empty currentList}">
		<c:forEach var="itemKey" items="${fn:split(currentList,',')}">
			<option value="${fn:trim(itemKey)}" selected="selected">${fn:trim(itemKey)}</option>
		</c:forEach>
	</c:if>
</form:select>


<div class="input-append">
	<re:mark>This is the <select> element the user sees</re:mark>
	<select id="${objName}.${objVar}.visible" size="5"  style="width:5">
		<c:if test="${! empty currentList}">
			<c:forEach var="itemKey" items="${fn:split(currentList,',')}">
				<option value="${fn:trim(itemKey)}" >${fn:trim(itemKey)}</option>
			</c:forEach>
		</c:if>
	</select>
	<re:mark>Remove Button</re:mark>
	<input name="btnRemove${objName}${objVar}" type="button" class="btn btn-default" id="btnRemove${objName}${objVar}" onClick="javascript:removeOption('${objName}.${objVar}');" value="${btn_remove_label}" />
</div>

<re:mark>Errors and warnings</re:mark>
<form:errors path="${objName}.${objVar}" cssClass="text-danger"/>
<wmsform:warnings path="${objName}.${objVar}" cssClass="text-warning"/>

 -->
