<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>

<div id="updateAvailable" class="alert alert-info well-small" style="display:none">
	<h4><span id="lastestVersion"></span> Update Available</h4>
	<p>
		You are using <strong>version <span id="currentServerVersion"></span></strong>. A new update for Wowza Streaming Engine is available.</p>
	<p>
		<a id="downloadsURL" class="btn btn-info " href="https://store.wowza.com/portal/account?tab=downloads" target="_blank">Download</a>
		<!-- releaseNotesURL set below in updatesAvail -->
		<a id="releaseNotesURL" class="btn btn-info" href="#" target="_blank">Release Notes</a>
	</p>
</div>

<script>

$(document).ready(function() {		
	$("#currentServerVersion").text("${requestScope.formData[obj]}");
	getRSSVersion();
});

function getCurrentVersion()
{
	//only show the first 3 numbers
	var curVer = "${requestScope.formData[obj]}";
	var splits = curVer.split(".");
	if(splits.length >2)
	{
		curVer = splits[0]+"."+splits[1]+"."+splits[2];	
	}
	return curVer;
}

function getRSSVersion()
{
	//RSS feed must have this in the header:
	//rssurl = "http://www.wowza.com/rss/wowzamediaserver4-production.xml";
	rssurl = "https://www.wowza.com/rss/wowzastreamingengine4-development.xml";
	//rssurl = "rss_test.xml";
	$.ajax({
		url : rssurl,
		data : null,
		cache : false,
		success : function(data) {
		    var $xml = $(data);
	        var $this = $xml.find("item"),
	            item = {
	                title: escape($this.find("title").text()),
	                link: $this.find("link").text(),
	                description: $this.find("description").text(),
	                pubDate: $this.find("pubDate").text(),
	                author: $this.find("author").text()
	        }
	        var splits = item.title.split("-");
	        if(splits.length>1)
	        {	
	        	updateAvail(splits[1]);
	        }
		},
		error : function (jqXHR, textStatus, thrownError) {
		}
	});
	return;
}

function updateAvail(latestRSSVersion)
{	
	currentVersion = getCurrentVersion();

	// Use global regex literal to replace all instances of '.' with '-'
	var latestWithDashes = latestRSSVersion.replace(/[.]/g, "-");
	// Set link for Release Notes button
	if(checkIfUpdater(latestRSSVersion))
	{
		// If updater
		$('#releaseNotesURL').attr("href", "https://www.wowza.com/docs/wowza-streaming-engine-software-updates#updaters");
	}
	else
	{
		// If installer
		$('#releaseNotesURL').attr("href", "https://www.wowza.com/docs/wowza-streaming-engine-" + latestWithDashes + "-release-notes");
	}
	
	
	//check numbers are greater
	var isUpdateAvail=false;
	var cvSplits = currentVersion.split(".");
	var lvSplits = latestRSSVersion.split(".");
	if(cvSplits.length>2 && lvSplits.length>2)
	{
		var cvVersion = parseInt(cvSplits[0])*1000000;
		cvVersion+= parseInt(cvSplits[1])*1000;
		cvVersion+= parseInt(cvSplits[2]);
		var lvVersion = parseInt(lvSplits[0])*1000000;
		lvVersion+= parseInt(lvSplits[1])*1000;
		lvVersion+= parseInt(lvSplits[2]);
		if(lvVersion > cvVersion)
		{
			isUpdateAvail=true;
		}
	}
	
	//if(latestRSSVersion!=currentVersion)
	if(isUpdateAvail)
	{
		$('#lastestVersion').text(latestRSSVersion);
		$('#updateAvailable').show();
	}
}

function checkIfUpdater(latestVersion)
{
	var isUpdater = false;
	
	splits = latestVersion.split(".");
	
	// Check if version is formed like x.x.x or x.x.x.yy
	if(splits.length > 3)
	{
		isUpdater = true;
	}
	
	return isUpdater;
}
</script>
