<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="false" rtexprvalue="true" %>
<%@ attribute name="appType" required="true" rtexprvalue="true" %>
<%@ attribute name="appSection" required="true" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="showEdit" required="false" rtexprvalue="true" %>

<re:mark>Display all advanced tables</re:mark>

<c:set var="obj" >
	advancedTables
</c:set>
<c:if test="${ empty obj}">
	<c:set var="obj" value="advancedTables"/>
</c:if>
<c:if test="${ empty showTitle}">
	<c:set var="showTitle" value="true"/>
</c:if>
<c:if test="${ empty showEdit}">
	<c:set var="showEdit" value="true"/>
</c:if>

<c:if test="${fn:length(requestScope.formDataAdv[obj])>0}">
	<c:if test="${showEdit}">

		<c:choose>
			<c:when test="${appType=='vhost' }">
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/vhostsetup/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/vhostsetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
			</c:when>
			<c:when test="${appType=='server' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/serversetup/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/serversetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
			</c:when>
			<c:when test="${appType=='mediacache' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacache/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacache/view.htm','')" />
			</c:when>
			<c:when test="${appType=='mediacachestore' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacachestore/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachestore/view.htm','storeName=${storeName}')" />
			</c:when>
			<c:when test="${appType=='mediacachesource' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacachesource/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachesource/view.htm','sourceName=${sourceName}')" />
			</c:when>
			<c:when test="${appSection=='smilfilestream' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/vhost/smilfile/stream/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:showSMILStream()" />
			</c:when>
			<c:when test="${appSection=='streamfile' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/vhost/streamfile/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:showStreamFile('${streamName}')" />
			</c:when>
			<c:otherwise>
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('applications/${appType}/${appSection}/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/view.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" />
			</c:otherwise>
		</c:choose>
	</c:if>
	<c:forEach items="${requestScope.formDataAdv[obj]}" var="entry">
		<c:if test="${! empty obj and fn:length(entry.value)>0}">	
			<c:if test="${showTitle}">				
					<h4 id="${entry.key}Anchor"><wmsform:getlocalestring page="${page}" obj="advancedTables.${entry.key}"/>
					<small><wmsform:getlocalestring page="${page}" obj="advancedTables.${entry.key}Help"/></small></h4>				
			</c:if>
			<table class="table table-striped">
				<tr>
					<th width="50"><wmsform:getlocalestring page="${page}" obj="${obj}.enabled"/></th>
					<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
					<th><wmsform:getlocalestring page="${page}" obj="${obj}.value"/></th>
					<th></th>
				</tr>
				<c:set var="itemLength">
					${fn:length(entry.value)}
				</c:set>
				<c:forEach var="i" begin="0" end="${fn:length(entry.value)-1}">
					<c:set var="section">
						${entry.key}
					</c:set>
					<c:set var="subObj" >
						${obj}[${section}][${i}]
					</c:set>
					<tr>
						<td>
							<c:choose>
								<c:when test="${requestScope.formDataAdv[obj][section][i]['canRemove']}">
									<wmsform:editpropertycheckbox page="${page}" obj="${subObj}.enabled" showTitle="no" onChange="enableField(${i},'${requestScope.formDataAdv[obj][section][i]['defaultValue']}')"/>
								</c:when>
								<c:otherwise>									
									<wmsform:editpropertycheckbox page="${page}" obj="${subObj}.enabled" showTitle="no" onChange="enableField(${i},${requestScope.formDataAdv[obj][section][i]['defaultValue']})" readonly="true"/>
								</c:otherwise>
							</c:choose>
						</td>
						<td class="breakall">
							<c:set var="objName" >
								${section}.${requestScope.formDataAdv[obj][section][i]['name']}
							</c:set>
							<c:set var="objDocumented" >
								${requestScope.formDataAdv[obj][section][i]['documented']}
							</c:set>
							<c:if test="${objDocumented=='false'}">
								${requestScope.formDataAdv[obj][section][i]['section']}/
							</c:if>
							<c:set var="itemName">
								<wmsform:getlocalestring page="${page}" obj="${obj}.${objName}"/>
							</c:set>
							${itemName}
						</td>
						<td>
							<c:set var="objType" >
								${requestScope.formDataAdv[obj][section][i]['type']}
							</c:set>
							<c:if test="${objType=='Boolean'}">
								<wmsform:editpropertytruefalse page="${page}" obj="${subObj}.uiBooleanValue" objValue="${requestScope.formDataAdv[obj][section][i]['uiBooleanValue']}" showTitle="no"/>
							</c:if>
							<c:if test="${objType=='String'}">
								<wmsform:editproperty page="${page}" obj="${subObj}.value" showTitle="no" cssClass="form-control"/>
							</c:if>
							<c:if test="${objType=='Integer'}">
								<wmsform:editproperty page="${page}" obj="${subObj}.value" cssClass="form-control" showTitle="no"/>
							</c:if>
							<c:if test="${requestScope.formDataAdv[obj][section][i]['defaultValue']!=null}">
								<div class="default-value-edit">
									default: 
									<c:choose>
										<c:when test="${empty requestScope.formDataAdv[obj][section][i]['defaultValue']}">
											-empty-
										</c:when>
										<c:otherwise>
											${requestScope.formDataAdv[obj][section][i]['defaultValue']}
										</c:otherwise>
									</c:choose>					
								</div>
							</c:if>
							<form:hidden path="${subObj}.sectionName"/>
							<form:hidden path="${subObj}.section"/>
							<form:hidden path="${subObj}.type"/>
							<form:hidden path="${subObj}.name"/>
							<form:hidden path="${subObj}.canRemove"/>
						</td>
						<td>
							<c:set var="advDesc">
								<wmsform:getlocalestring page="${page}" obj="advancedTables.${objName}.description" defaultStr="TBD"/>
							</c:set>
							<i id="${requestScope.formDataAdv[obj][section][i]['name']}Edit" class="fa fa-question-circle fa-2x" rel="popover" data-html="true" data-content="${advDesc}" data-trigger="click" data-animation="true" data-placement="left" data-delay="150" data-original-title="${itemName}"></i>
							<script>
								WOWZA.Util.Popover("#${requestScope.formDataAdv[obj][section][i]['name']}Edit");
							</script>
						</td>
					</tr>
				</c:forEach>
			</table>
		</c:if>
	</c:forEach>

	<c:if test="${showEdit}">	
		<c:choose>
			<c:when test="${appType=='vhost' }">
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/vhostsetup/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/vhostsetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
			</c:when>
			<c:when test="${appType=='server' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/serversetup/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/serversetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
			</c:when>
			<c:when test="${appType=='mediacache' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacache/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacache/view.htm','')" />
			</c:when>
			<c:when test="${appType=='mediacachestore' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacachestore/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachestore/view.htm','storeName=${storeName}')" />
			</c:when>
			<c:when test="${appType=='mediacachesource' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacachesource/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachesource/view.htm','sourceName=${sourceName}')" />
			</c:when>
			<c:when test="${appSection=='smilfilestream' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/vhost/smilfile/stream/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:showSMILStream()" />
			</c:when>
			<c:when test="${appSection=='streamfile' }">			
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/vhost/streamfile/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:showStreamFile('${streamName}')" />
			</c:when>
			<c:otherwise>
				<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('applications/${appType}/${appSection}/edit_adv.htm','','mainContent','defaultFormAdv')"/>
				<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/view.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" />
			</c:otherwise>
		</c:choose>
	</c:if>
</c:if>


<script>
function enableField(obj,defaultValue)
{
	enableField(obj,defaultValue,false);
}

function enableField(obj,defaultValue,init)
{
	var tObj = "${obj}${requestScope.formDataAdv['advSection']}"+obj;
	if(document.getElementById(tObj+".value")!=null)
	{
		document.getElementById(tObj+".value").disabled=!document.getElementById(tObj+".enabled1").checked;
	}
	enabledChk=false;
	if(document.getElementById(tObj+".enabled1"))
	{
		enabledChk=document.getElementById(tObj+".enabled1").checked;
	}
	if(!enabledChk)
	{
		if(document.getElementById(tObj+".value")!=null)
		{
			document.getElementById(tObj+".value").value="";
		}
	}
	else 
	{
		if(document.getElementById(tObj+".value")!=null && defaultValue!="")
		{
			document.getElementById(tObj+".value").value=defaultValue;
		}
	}
	if(document.getElementById(tObj+".uiBooleanValue1"))
	{
		//alert("1");
		if(!enabledChk)
		{
			document.getElementById(tObj+".uiBooleanValue1").checked=false;				
			document.getElementById(tObj+".uiBooleanValue1").parentNode.className+=" text-muted";
		}
		else 
		{
			newClassName=document.getElementById(tObj+".uiBooleanValue1").parentNode.className.replace("text-muted","");
			document.getElementById(tObj+".uiBooleanValue1").parentNode.className=newClassName;
			if(!init)
			{
				document.getElementById(tObj+".uiBooleanValue1").checked=defaultValue=="true";
			}

		}
		document.getElementById(tObj+".uiBooleanValue1").disabled=!enabledChk;	
	}
	if(document.getElementById(tObj+".uiBooleanValue2"))
	{
		//alert("2");
		if(!enabledChk)
		{
			document.getElementById(tObj+".uiBooleanValue2").checked=false;				
			document.getElementById(tObj+".uiBooleanValue2").parentNode.className+=" text-muted";
		}
		else 
		{
			newClassName=document.getElementById(tObj+".uiBooleanValue2").parentNode.className.replace("text-muted","");
			document.getElementById(tObj+".uiBooleanValue2").parentNode.className=newClassName;
			if(!init)
			{
				document.getElementById(tObj+".uiBooleanValue2").checked=defaultValue=="false";
			}
		}
		document.getElementById(tObj+".uiBooleanValue2").disabled=!enabledChk;	
	}
}

for(var i=0;i<"${itemLength}";i++)
{
	enableField(i,"",true);
}
</script>
