<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all media cache sources table</re:mark>

<c:set var="obj" >
	sources
</c:set>
<table class="table table-striped">
	<tr>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.basePath"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.prefix"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
	</tr>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		<tr>
			<td class="breakall"><a href='javascript:showMediaCacheSource("${item["sourceName"]}")'>${item['sourceName']}</a></td>
			<td>${item['basePath']}</td>
			<td>${item['prefix']}</td>
			<td>
				<sec:authorize access="hasAnyRole('admin')">
					<a href='javascript:showEditMediaCacheSource("${item["sourceName"]}")' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this media cache source'></i></a>
					<c:choose>
						<c:when test="${item['sourceName']=='dvrorigin'}">
						</c:when>
						<c:otherwise>
							<a href='javascript:removeSource("${item["sourceName"]}")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this media cache source'></i></a>
						</c:otherwise>
					</c:choose>
				</sec:authorize>
			</td>
		</tr>
	</c:forEach>
</table>
<wmsdialog:deletemediacachesource page="mediaCache"/>

<script>

function removeSource(name)
{
	deleteSourceName=name;
	deleteMediaCacheSourceShow();
}

function showMediaCacheSource(name)
{
	if(name!="[new]")
	{
		loadAjaxMainContent("server/mediacachesource/view.htm", "sourceName="+name);
	}
}

function showEditMediaCacheSource(name)
{
	lastTab='Basic';
	loadAjaxMainContent('server/mediacachesource/edit.htm','sourceName='+name+'&action=quickEdit');
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>