<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all smil file streams tables</re:mark>

<c:set var="obj" >
	streams
</c:set>
<h5><wmsform:getlocalestring page="${page}" obj="tableTitle"/></h5> 
<sec:authorize access="hasAnyRole('admin')">		
	<p><wmsform:button page="smilFiles.smilFile" obj="addStream" onClick="javascript:addStream()" icon="fa fa-plus" cssClass="btn btn-default"/></p>
</sec:authorize>		
<c:choose>
	<c:when test="${fn:length(requestScope.formData[obj]) == 0}">
		<div class="value text-info">
			<wmsform:getlocalestring page="${page}" obj="${obj}.noStreamsDefined"/>
		</div>
	</c:when>
	<c:otherwise>
		<table class="table table-striped">
			<tr>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.source"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.language"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.type"/></th>
				<th><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
			</tr>
			<c:forEach items="${requestScope.formData[obj]}" var="item" varStatus="varStatus">
				<tr>
					<td class="breakall">
						<a href="javascript:showSMILStream('${item['idx']}')">${wmsutil:escapeHtml(item['src'])}</a>
					</td>
					<td>
						${item['systemLanguage']}
					</td>
					<td>
						${item['type']}
						<c:if test="${item['audioOnly']}">
							<b>*</b>
						</c:if>
					</td>
					<td>
						<sec:authorize access="hasAnyRole('admin')">		
								<a href="javascript:showEditSMILStream('${item['idx']}')" ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this stream'></i></a>
								<a href="javascript:removeSMILStream('${item['idx']}')" ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this stream'></i></a></center>
						</sec:authorize>
					</td>
				</tr>
			</c:forEach>
		</table>
		<b>*</b> Audio Only 
	</c:otherwise>
</c:choose>

<wmsdialog:deletesmilfilestream page="${page}"/>
<wmsdialog:addsmilstream page="${page}"/>

<script>

function showSMILStream(idx)
{
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/smilfile/stream/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&smilFile=${wmsutil:urlEncode(smilName)}&idx="+idx+"&smilType="); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/smilfile/stream/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&smilFile=${wmsutil:urlEncode(smilName)}&idx="+idx+"&smilType="); 			
	}
}

function showEditSMILStream(idx)
{
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/smilfile/stream/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&smilFile=${wmsutil:urlEncode(smilName)}&idx="+idx+"&smilType=&action=quickEdit"); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/smilfile/stream/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&smilFile=${wmsutil:urlEncode(smilName)}&idx="+idx+"&smilType=&action=quickEdit"); 			
	}
}

function removeSMILStream(idx)
{
	deleteSMILFileStreamName=tblDataSMILStream[idx].src;
	deleteSMILFileStreamIdx=idx;
	deleteSMILFileStreamShow();
}

function addStream()
{
	addSMILStreamShow();
}

var tblDataSMILStream = new Array();
var tblIdxSMILStream=0;

initTableDataSMILStream();

function initTableDataSMILStream()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		//newItem.orgIdx = tblIdxSMILStream++;
		newItem.orgIdx = "${item['orgIdx']}";
		newItem.removed = "${item['removed']}"==="true";
		newItem.src = "${item['src']}";
		newItem.systemLanguage = "${item['systemLanguage']}";
		newItem.type = "${item['type']}";
		tblDataSMILStream.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
</script>