<?php
ini_set("memory_limit", "4096M");
ini_set("max_execution_time", 0);
set_time_limit(0);

$inicio_execucao = tempo_execucao();

/////////////////////////////////////////////
////////////// Funções Gerais ///////////////
/////////////////////////////////////////////

function formatar_nome_arquivo_cache($arquivo) {

$array_caracteres = array("/[ÂÀÁÄÃ]/"=>"a","/[âãàáä]/"=>"a","/[ÊÈÉË]/"=>"e","/[êèéë]/"=>"e","/[ÎÍÌÏ]/"=>"i","/[îíìï]/"=>"i","/[ÔÕÒÓÖ]/"=>"o", "/[ôõòóö]/"=>"o","/[ÛÙÚÜ]/"=>"u","/[ûúùü]/"=>"u","/ç/"=>"c","/Ç/"=> "c","/ /"=> "-","/_/"=> "-");

$formatado = preg_replace(array_keys($array_caracteres), array_values($array_caracteres), $arquivo);

return strtolower($formatado).".xml";
}

function timestampdiff($qw,$saw) {

    $datetime1 = new DateTime($qw);
    $datetime2 = new DateTime($saw);
    $interval = $datetime1->diff($datetime2);
    return $interval->format('%Hh %Im');
}

// Função para calcular tempo de exceussão
function tempo_execucao() {
    $sec = explode(" ",microtime());
    $tempo = $sec[1] + $sec[0];
    return $tempo;
}

/////////////////////////////////////////////
///////////// Variaveis Gerais //////////////
/////////////////////////////////////////////

$path_pasta_cache = "/home/streaming/cache";
$arquivo_locker = $path_pasta_cache."/gerar-cache-pastas.lock";

// Verifica se esta sendo executado com a porta especificada
if(isset($argv[1]) && is_numeric($argv[1])) {

$porta = $argv[1];

echo "--------------------------------------------------------------------\n";
echo "Processando manualmente porta ".$porta."...\n";
echo "--------------------------------------------------------------------\n";

// Busca as pastas do streming
$path_porta = "/home/streaming/".$porta."";

// Pasta raiz/root
$lista_pastas_porta[] = "/";

$pastas_porta = new DirectoryIterator($path_porta);

foreach($pastas_porta as $pasta_porta) {

        if(!$pasta_porta->isDot() && $pasta_porta->isDir()) {
                $lista_pastas_porta[] = $pasta_porta->getFilename();
        }

}

// Busca as músicas das pastas
foreach($lista_pastas_porta as $pasta_porta) {

        // Cria lock da pasta atual gerando cache.
        @file_put_contents($path_pasta_cache."/".$porta.".lock",$porta);

        $pasta = ($pasta_porta == "/") ? "" : $pasta_porta;

        $path_pasta = $path_porta."/".$pasta;
        $arquivo_xml_cache_pasta = ($pasta_porta == "/") ? $porta."-root.xml" : $porta."-".formatar_nome_arquivo_cache($pasta);

        $timestamp_pasta = @filemtime($path_pasta);

        if(file_exists($path_pasta_cache."/".$arquivo_xml_cache_pasta)) {
        $timestamp_cache = @filemtime($path_pasta_cache."/".$arquivo_xml_cache_pasta);
        } else {
        $timestamp_cache = $timestamp_pasta-1;        
        }

        if($timestamp_cache < $timestamp_pasta) {

                $dir = new DirectoryIterator($path_pasta);

                foreach($dir as $file) {

                        if($file->isFile()) {

                                if(pathinfo($file->getFilename(), PATHINFO_EXTENSION) == "mp3" || pathinfo($file->getFilename(), PATHINFO_EXTENSION) == "MP3") {

                                        $array_musicas_pasta[] = $file->getFilename();

                                }
                        }
                }
                asort($array_musicas_pasta);

                if(@count($array_musicas_pasta) > 0) {

                        $xml = new XMLWriter;
                        $xml->openMemory();
                        $xml->startDocument('1.0','iso-8859-1');

                        $xml->startElement("musicas");

                        foreach($array_musicas_pasta as $musica) {

                                $duracao_segundos = 0;

                                $duracao = shell_exec("/usr/local/bin/ffprobe -i '".$path_pasta.'/'.$musica."' -show_entries format=duration -v quiet -of csv=\"p=0\"");
                                $duracao_segundos = @round($duracao);

                                if(isset($duracao_segundos) && $duracao_segundos > 0) {

                                $xml->startElement("musica");

                                $xml->writeElement("nome", utf8_encode($musica));
                                $xml->writeElement("duracao", gmdate("H:i:s", $duracao_segundos));
                                $xml->writeElement("duracao_segundos", $duracao_segundos);

                                $xml->endElement();
                                        if ($_SERVER['argc'] > 1) {
                                                echo "Música ".$path_pasta."/".$musica." -> ".gmdate("H:i:s", $duracao_segundos)."\n";
                                        }

                                }

                        }

                        $xml->endElement();

                        $xml_cache = $xml->outputMemory();

                        file_put_contents($path_pasta_cache."/".$arquivo_xml_cache_pasta,$xml_cache);

                        echo "Cache da pasta ".$arquivo_xml_cache_pasta." criado/atualizado.\n";

                        unset($array_musicas_pasta);
                }
        }

}

unlink($path_pasta_cache."/".$porta.".lock");

$fim_execucao = tempo_execucao();

$tempo_execucao = gmdate("H:i:s", round($fim_execucao-$inicio_execucao));

echo "\n--------------------------------------------------------------------\n";
echo "Processo finalizado em ".$tempo_execucao."\n";
echo "--------------------------------------------------------------------\n\n";

exit();
}

// Verifica se gerador de cache já esta em execussã0
if(file_exists($arquivo_locker)) {
echo "--------------------------------------------------------------------\n";
echo "O gerador já esta em execussão, aguarde finalizar para iniciar outro.\n";
echo "--------------------------------------------------------------------\n";

if(filemtime($arquivo_locker) < ( time() - ( 1 * 60 * 60 ) ) ) {
unlink($arquivo_locker);
}

exit();
}

// Cria lockers para evitar processos duplicados
file_put_contents($arquivo_locker,time());

// Busca os streamings
$dir_portas = new DirectoryIterator("/home/streaming");

foreach($dir_portas as $dir_porta) {

        if(!$dir_porta->isDot() && $dir_porta->isDir()) {

        $porta = $dir_porta->getFilename();

        if(is_numeric($porta)) {

        echo "--------------------------------------------------------------------\n";
        echo "Processando porta ".$porta."...\n";
        echo "--------------------------------------------------------------------\n";

        // Busca as pastas do streming
        $path_porta = "/home/streaming/".$porta."";

        // Pasta raiz/root
        $lista_pastas_porta[] = "/";

        $pastas_porta = new DirectoryIterator($path_porta);

        foreach($pastas_porta as $pasta_porta) {

                if(!$pasta_porta->isDot() && $pasta_porta->isDir()) {
                        $lista_pastas_porta[] = $pasta_porta->getFilename();
                }

        }

        // Verifica se existe lock da pasta e pula para proxima pasta
        if(!file_exists($path_pasta_cache."/".$porta.".lock")) {

        // Busca as músicas das pastas
        foreach($lista_pastas_porta as $pasta_porta) {

                // Cria lock da pasta atual gerando cache.
                file_put_contents($path_pasta_cache."/".$porta.".lock",$porta);

                $pasta = ($pasta_porta == "/") ? "" : $pasta_porta;

                $path_pasta = $path_porta."/".$pasta;
                $arquivo_xml_cache_pasta = ($pasta_porta == "/") ? $porta."-root.xml" : $porta."-".formatar_nome_arquivo_cache($pasta);

                $timestamp_pasta = @filemtime($path_pasta);

                if(file_exists($path_pasta_cache."/".$arquivo_xml_cache_pasta)) {
                $timestamp_cache = @filemtime($path_pasta_cache."/".$arquivo_xml_cache_pasta);
                } else {
                $timestamp_cache = $timestamp_pasta-1;
                }

                if($timestamp_cache < $timestamp_pasta) {

                        $dir = new DirectoryIterator($path_pasta);

                        foreach($dir as $file) {

                                if($file->isFile()) {

                                        if(pathinfo($file->getFilename(), PATHINFO_EXTENSION) == "mp3" || pathinfo($file->getFilename(), PATHINFO_EXTENSION) == "MP3") {

                                                $array_musicas_pasta[] = $file->getFilename();

                                        }
                                }
                        }

                        asort($array_musicas_pasta);

                        if(@count($array_musicas_pasta) > 0) {

                                $xml = new XMLWriter;
                                $xml->openMemory();
                                $xml->startDocument('1.0','iso-8859-1');

                                $xml->startElement("musicas");

                                foreach($array_musicas_pasta as $musica) {

                                        $duracao_segundos = 0;

                                        $duracao = shell_exec("/usr/local/bin/ffprobe -i '".$path_pasta.'/'.$musica."' -show_entries format=duration -v quiet -of csv=\"p=0\"");
                                        $duracao_segundos = @round($duracao);

                                                if(isset($duracao_segundos) && $duracao_segundos > 0) {

                                                        $xml->startElement("musica");

                                                        $xml->writeElement("nome", utf8_encode($musica));
                                                        $xml->writeElement("duracao", gmdate("H:i:s", $duracao_segundos));
                                                        $xml->writeElement("duracao_segundos", $duracao_segundos);

                                                        $xml->endElement();

                                                        if($argv[1] == "log" || $argv[2] == "log") {
                                                                echo "Música ".$path_pasta."/".$musica." -> ".gmdate("H:i:s", $duracao_segundos)."\n";
                                                        }

                                                }

                                }

                                $xml->endElement();

                                $xml_cache = $xml->outputMemory();

                                file_put_contents($path_pasta_cache."/".$arquivo_xml_cache_pasta,$xml_cache);

                                echo "Cache da pasta ".$arquivo_xml_cache_pasta." criado/atualizado.\n";

                                unset($array_musicas_pasta);
                        }
                }

        }

        unlink($path_pasta_cache."/".$porta.".lock");

        }

        }

        }
}

$fim_execucao = tempo_execucao();

$tempo_execucao = gmdate("H:i:s", round($fim_execucao-$inicio_execucao));

unlink($arquivo_locker);

echo "\n--------------------------------------------------------------------\n";
echo "Processo finalizado em ".$tempo_execucao."\n";
echo "--------------------------------------------------------------------\n\n";
?>
