<?php
require_once("inc/protecao-admin.php");

$total_streamings = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings"));
$total_revendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE tipo = '1'"));
$total_subrevendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE tipo != '1'"));
$total_servidores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM servidores"));
$total_apps = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM apps"));


?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Administraci&oacute;n</title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/admin/inc/ajax.js"></script>
		<script type="text/javascript" src="/admin/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_config["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header-admin.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu-admin.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo lang_menu_estatisticas; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/admin/admin-configuracoes">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo lang_menu_estatisticas; ?></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
					<div class="row">
						<!-- cards -->
						<div class="col-md-6 col-xl-6 col-xs-6 col-sm-6">
							<div class="card">
								<div class="card-header d-flex custom-card-header border-bottom-0 ">
									<h5 class="card-title"><?php echo lang_pagina_estatisticas_titulo_acessos; ?></h5>
								</div>
								<div class="card-body">
									<table class="table table-hover mb-0">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_pagina_estatisticas_paginas; ?></th>
                                                        <th><?php echo lang_pagina_estatisticas_acessos; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql_stats_pagina = mysqli_query($conexao,"SELECT * FROM acessos_paginas ORDER by total DESC LIMIT 10");
while ($dados_stats_pagina = mysqli_fetch_array($sql_stats_pagina)) {

$array_paginas_exclude = array("funcoes-ajax","favicon.ico","index");

if(!array_search($dados_stats_pagina["pagina"],$array_paginas_exclude)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stats_pagina["pagina"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".number_format($dados_stats_pagina["total"] , 0, ',', '.')."</td>
</tr>";

}
}
?>
                                                </tbody>
                                            </table>
								</div>
							</div>
						</div>
						<div class="col-md-6 col-xl-6 col-xs-6 col-sm-6">
							<div class="card">
								<div class="card-header d-flex custom-card-header border-bottom-0 ">
									<h5 class="card-title"><?php echo lang_pagina_estatisticas_titulo_acessos_players; ?></h5>
								</div>
								<div class="card-body">
									<table class="table table-hover mb-0">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_pagina_estatisticas_paginas; ?></th>
                                                        <th><?php echo lang_pagina_estatisticas_acessos; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql_stats_players = mysqli_query($conexao,"SELECT * FROM acessos_players ORDER by total DESC LIMIT 10");
while ($dados_stats_player = mysqli_fetch_array($sql_stats_players)) {

$array_players_exclude = array("img","video","status.xsl?mount=","favicon.ico","funcoes-ajax-players","index");

if(!array_search($dados_stats_player["player"],$array_players_exclude)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stats_player["player"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".number_format($dados_stats_player["total"] , 0, ',', '.')."</td>
</tr>";

}
}
?>
                                                </tbody>
                                            </table>
								</div>
							</div>
						</div>
						<div class="col-md-6 col-xl-6 col-xs-6 col-sm-6">
							<div class="card">
								<div class="card-header d-flex custom-card-header border-bottom-0 ">
									<h5 class="card-title"><?php echo lang_pagina_estatisticas_titulo_acessos_players; ?></h5>
								</div>
								<div class="card-body">
									<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td width="130" height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_streamings; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_streamings; ?></td>
                                              </tr>
                                              <tr>
                                                <td width="129" height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_revendas; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_revendas; ?></td>
                                              </tr>
                                              <tr>
                                                <td width="129" height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_subrevendas; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_subrevendas; ?></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_servidores; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_servidores; ?></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_estatisticas_apps; ?></strong></td>
                                                <td align="left" class="texto_padrao"><?php echo $total_apps; ?></td>
                                              </tr>
                                            </table>
								</div>
							</div>
						</div>
						<!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo lang_pagina_configuracoes_idioma_painel; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/admin/admin-mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/admin/admin-mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<!--
								<li class="col-lg-6 mb-2">
									<a href="/admin/admin-mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>-->
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal-admin.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<script src="/inc/js/theme.js"></script>
	  	<script>
		  $('#busca_chave').keypress(function (e) {
		    if (e.which == 13) {
		       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
		    }
		  }); 
	  	</script>
	</body>
</html>