<?php
require_once("inc/protecao-revenda.php");


?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Reseller #<?php echo $dados_revenda["id"]; ?></title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/admin/inc/ajax-revenda.js"></script>
		<script type="text/javascript" src="/admin/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_revenda["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header-revenda.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<?php if($dados_revenda["url_logo"]) { ?>
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } else { ?>
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } ?>
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu-revenda.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo lang_info_pagina_dominio_proprio_tab_titulo; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/admin/revenda">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo lang_info_pagina_dominio_proprio_tab_titulo; ?></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
					<div class="row">
						<!-- cards -->
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<?php echo lang_info_pagina_dominio_proprio_info1; ?><br /><br />
                                      <strong><?php echo lang_info_pagina_dominio_proprio_info2; ?></strong><br /><br />
                                        <strong><?php echo lang_info_pagina_dominio_proprio_info3; ?></strong><br /><br />
                                        <strong>Status:</strong> <?php echo ($dados_revenda["dominio_padrao"]) ? '<code>'.lang_info_pagina_dominio_proprio_status1.' - '.$dados_revenda["dominio_padrao"].'</code>' : '<code>'.lang_info_pagina_dominio_proprio_status2.'</code> <a href="#" onclick="window.location = \'/admin/revenda-configuracoes\';">'.lang_info_pagina_dominio_proprio_status_botao.'</a>'; ?><br /><br />
                                      <strong><?php echo lang_info_pagina_dominio_proprio_info4; ?></strong><br /><br />
                                        <strong><?php echo lang_info_pagina_dominio_proprio_info5; ?></strong><br /><br />
                                        <div class="table-responsive">
                                            <table class="table table-hover mb-0">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_info_pagina_dominio_proprio_servidores_nome; ?></th>
                                                        <th><?php echo lang_info_pagina_dominio_proprio_servidores_ttl; ?></th>
                                                        <th><?php echo lang_info_pagina_dominio_proprio_servidores_tipo; ?></th>
                                                        <th><?php echo lang_info_pagina_dominio_proprio_servidores_servidor; ?></th>
                                                        <th><?php echo lang_info_pagina_dominio_proprio_servidores_status; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php

$servidor_api = "api.".$dados_config["dominio_padrao"];
$checagem_servidor_api = dns_get_record("api.".$dados_revenda["dominio_padrao"], DNS_CNAME);

if($checagem_servidor_api[0]["target"] == $servidor_api) {
$status_servidor_api = '<code>'.lang_info_pagina_dominio_proprio_status1.'</code>';
} else {
$status_servidor_api = '<code>'.lang_info_pagina_dominio_proprio_status3.'</code>';
}

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;api</td>
<td height='25' align='left' scope='col'>&nbsp;900</td>
<td height='25' align='left' scope='col'>&nbsp;CNAME</td>
<td height='25' align='left' scope='col'>&nbsp;api.".$dados_config["dominio_padrao"].".</td>
<td height='25' align='left' scope='col'>&nbsp;".$status_servidor_api."</td>
</tr>";

$servidor_player = "player.".$dados_config["dominio_padrao"];
$checagem_servidor_player = dns_get_record("player.".$dados_revenda["dominio_padrao"], DNS_CNAME);

if($checagem_servidor_player[0]["target"] == $servidor_player) {
$status_servidor_player = '<code>'.lang_info_pagina_dominio_proprio_status1.'</code>';
} else {
$status_servidor_player = '<code>'.lang_info_pagina_dominio_proprio_status3.'</code>';
}

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;player</td>
<td height='25' align='left' scope='col'>&nbsp;900</td>
<td height='25' align='left' scope='col'>&nbsp;CNAME</td>
<td height='25' align='left' scope='col'>&nbsp;player.".$dados_config["dominio_padrao"].".</td>
<td height='25' align='left' scope='col'>&nbsp;".$status_servidor_player."</td>
</tr>";

$sql = mysqli_query($conexao,"SELECT * FROM servidores WHERE status = 'on' ORDER by ordem ASC");
while ($dados_servidor = mysqli_fetch_array($sql)) {

$servidor = strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"];

$checagem = dns_get_record(strtolower($dados_servidor["nome"]).".".$dados_revenda["dominio_padrao"], DNS_CNAME);

if($checagem[0]["target"] == $servidor) {
$status = '<code>'.lang_info_pagina_dominio_proprio_status1.'</code>';
} else {
$status = '<code>'.lang_info_pagina_dominio_proprio_status3.'</code>';
}

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".strtolower($dados_servidor["nome"])."</td>
<td height='25' align='left' scope='col'>&nbsp;900</td>
<td height='25' align='left' scope='col'>&nbsp;CNAME</td>
<td height='25' align='left' scope='col'>&nbsp;".strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"].".</td>
<td height='25' align='left' scope='col'>&nbsp;".$status."</td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <br />
                                        <strong><?php echo lang_info_pagina_dominio_proprio_info6; ?></strong><br />
                                        <br />
                                        <strong><?php echo lang_info_pagina_dominio_proprio_info7; ?></strong><br />
                                        <br />
                                        <?php echo lang_info_pagina_dominio_proprio_info8; ?>
                                        <br />
                                        <br />
                                        <strong><?php echo lang_info_pagina_dominio_proprio_info9; ?></strong><br />
                                        <br />
                                        <?php echo lang_info_pagina_dominio_proprio_info10; ?>
                                        <br />
                                        <br />
                                        <strong><?php echo lang_info_pagina_dominio_proprio_info11; ?></strong><br />
                                        <br />
                                        <?php echo lang_info_pagina_dominio_proprio_info12; ?>
                                        <br />
                                        <br />
                                        <img src="data:image/jpeg;base64,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" alt="Adicionar Entrada de DNS" width="400" height="309" border="1" /><br />
								</div>
							</div>
						</div>
						<!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo lang_info_pagina_configurar_streaming_idioma; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/admin/revenda-mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/admin/revenda-mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<li class="col-lg-6 mb-2">
									<a href="/admin/revenda-mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal-revenda.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<script src="/inc/js/theme.js"></script>
		<script src="/inc/theme-<?php echo $dados_revenda["layout_painel"]; ?>.js"></script>
	  	<script>
		  $('#busca_chave').keypress(function (e) {
		    if (e.which == 13) {
		       window.location = "/admin/revenda-streamings/resultado/porta/"+document.getElementById("busca_chave").value;
		    }
		  }); 
	  	</script>
	</body>
</html>