<?php
require_once("inc/protecao-revenda.php");


?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Reseller #<?php echo $dados_revenda["id"]; ?></title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/admin/inc/ajax-revenda.js"></script>
		<script type="text/javascript" src="/admin/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_revenda["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header-revenda.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<?php if($dados_revenda["url_logo"]) { ?>
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } else { ?>
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } ?>
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu-revenda.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo lang_info_pagina_modulo_whmcs_tab_titulo_streaming; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/admin/revenda">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo lang_info_pagina_modulo_whmcs_tab_titulo_streaming; ?></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
					<div class="row">
						<!-- cards -->
                        <div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
                            <div class="card">
                                <div class="card-header d-flex custom-card-header border-bottom-0 ">
                                    <h5 class="card-title"><?php echo lang_info_pagina_modulo_whmcs_tab_titulo_streaming; ?></h5>
                                </div>
                                <div class="card-body">
                                    <?php echo sprintf(lang_info_pagina_modulo_whmcs_streaming_texto1,$versao_modulo_whmcs_streaming); ?><br />
      <br />
      <input type="text" value="<?php echo $dados_revenda["chave_api"]; ?>" style="width:99%; height:30px;"  onclick="this.select()" readonly="readonly" /><br />
<br /> 
<?php echo sprintf(lang_info_pagina_modulo_whmcs_streaming_texto2,$versao_modulo_whmcs_streaming); ?><br /><br />
<img src="data:image/jpeg;base64,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" alt="M&oacute;dulo WHMCS" width="369" height="327" /><br />
<br />
<?php echo sprintf(lang_info_pagina_modulo_whmcs_streaming_texto3,$dados_revenda["chave_api"]); ?>
<br /><br />
<img src="data:image/jpeg;base64,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" alt="M&oacute;dulo WHMCS" width="508" height="190" /><br /><br />
<?php echo lang_info_pagina_modulo_whmcs_streaming_texto4; ?>
                                </div>
                            </div>
                        </div>
                        <?php if($dados_revenda["subrevendas"] > 0) { ?>
                        <div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
                            <div class="card">
                                <div class="card-header d-flex custom-card-header border-bottom-0 ">
                                    <h5 class="card-title"><?php echo lang_info_pagina_modulo_whmcs_tab_titulo_subrevenda; ?></h5>
                                </div>
                                <div class="card-body">
                                    <?php echo sprintf(lang_info_pagina_modulo_whmcs_subrevenda_texto1,$versao_modulo_whmcs_subrevenda); ?><br />
      <br />
      <input type="text" value="<?php echo $dados_revenda["chave_api"]; ?>" style="width:99%; height:30px;"  onclick="this.select()" readonly="readonly" /><br />
<br /> 
<?php echo sprintf(lang_info_pagina_modulo_whmcs_subrevenda_texto2,$dados_revenda["chave_api"]); ?><br /><br />
<?php echo lang_info_pagina_modulo_whmcs_subrevenda_texto3; ?>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
						<!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo lang_info_pagina_configurar_streaming_idioma; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/admin/revenda-mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/admin/revenda-mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<li class="col-lg-6 mb-2">
									<a href="/admin/revenda-mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal-revenda.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<script src="/inc/js/theme.js"></script>
		<script src="/inc/theme-<?php echo $dados_revenda["layout_painel"]; ?>.js"></script>
	  	<script>
		  $('#busca_chave').keypress(function (e) {
		    if (e.which == 13) {
		       window.location = "/admin/revenda-streamings/resultado/porta/"+document.getElementById("busca_chave").value;
		    }
		  }); 
	  	</script>
	</body>
</html>