package com.shoutcast.stm.radio_nome.activities;

import static com.shoutcast.stm.radio_nome.Config.BASE_URL;
import static com.shoutcast.stm.radio_nome.Config.PORTA;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.ProgressBar;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.shoutcast.stm.radio_nome.Config;
import com.shoutcast.stm.radio_nome.R;
import com.shoutcast.stm.radio_nome.models.Radio;
import com.shoutcast.stm.radio_nome.utils.Constant;
import com.shoutcast.stm.radio_nome.utils.Theme;
import com.onesignal.OneSignal;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ActivitySplash extends AppCompatActivity {

    ProgressBar progressBar;
    Radio radio = new Radio();
    long id = System.currentTimeMillis();

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);
        progressBar = findViewById(R.id.progressBar);
        progressBar.setVisibility(View.VISIBLE);

        carregarTema();

        if (Config.HABILITAR_PAINEL) {
            addRadioConfig();
        } else {
            addRadios();
        }

        startMainActivity();
    }

    private void carregarTema() {
        RequestQueue queue = Volley.newRequestQueue(this);
        String url = BASE_URL + "api-source-3.0.php?porta="+PORTA+"&get_all=true";

        StringRequest stringRequest = new StringRequest(Request.Method.GET, url,
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String response) {
                        try {
                            JSONObject responseObj = new JSONObject(response);
                            JSONArray temasList = responseObj.getJSONArray("theme");
                            JSONArray layoutList = responseObj.getJSONArray("layout");
                            JSONArray onesignalConfigList =  responseObj.getJSONArray(("onesignal"));

                            JSONObject onesignalConfig =  onesignalConfigList.getJSONObject(0);
                            OneSignal.setAppId(onesignalConfig.getString("onesinal_app_id"));


                            for (int i = 0; i < temasList.length(); i++) {
                                JSONObject jsonObj = temasList.getJSONObject(i);
                                if (jsonObj.getString("status").equals("ativo")) {
                                    MyApplication.theme = new Theme(jsonObj.getString("temas"));
                                }
                            }

                            for (int i = 0; i < layoutList.length(); i++) {
                                JSONObject jsonObj = layoutList.getJSONObject(i);
                                if (jsonObj.getString("status").equals("ativo")) {
                                    MyApplication.layout =jsonObj.getString("layout");
                                }
                            }
                            Intent intent = new Intent(getBaseContext(), MainActivity.class);
                            startActivity(intent);
                            finish();
                        } catch (JSONException e) {
                            MyApplication.theme = new Theme("AppTheme");
                            e.printStackTrace();
                            Intent intent = new Intent(getBaseContext(), MainActivity.class);
                            startActivity(intent);
                            finish();
                        }

                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                MyApplication.theme = new Theme("AppTheme");
                Intent intent = new Intent(getBaseContext(), MainActivity.class);
                startActivity(intent);
                finish();
            }
        });

        // Add the request to the RequestQueue.
        queue.add(stringRequest);
    }

    private void addRadioConfig() {
        RequestQueue queue = Volley.newRequestQueue(this);
        StringRequest postRequest = new StringRequest(Request.Method.POST, BASE_URL + "api-source-3.0.php?porta="+PORTA+"",
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String result) {
                        if (result.length() > 0) {
                            JSONArray jsonArr = null;
                            try {
                                jsonArr = new JSONArray(result);
                                for (int i = 0; i < jsonArr.length(); i++) {
                                    JSONObject jsonObj = jsonArr.getJSONObject(i);
                                    radio.setRadio_url(jsonObj.optString("radio_url"));
                                    radio.setRadio_name(jsonObj.optString("radio_name"));
                                    radio.setRadio_genre(jsonObj.optString("radio_genero"));
                                    radio.setRadio_image_url(Config.URL_IMAGE_RADIO+ jsonObj.optString("radio_image"));
                                    Constant.item_radio.add(0, radio);
                                }
                                startMainActivity();

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }


                        }

                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<String, String>();
                params.put("get_radio", "get_radio");

                return params;
            }
        };


        RequestQueue mRequestQueue = Volley.newRequestQueue(getApplication());
        // Adding request to request queue
        mRequestQueue.add(postRequest);


    }

    private void addRadios(){
        new Handler().postDelayed(() -> {
            radio.setRadio_image_url(Config.RADIO_IMAGE_URL);
            radio.setRadio_genre(Config.RADIO_GENRE);
            radio.setRadio_id(id);
            radio.setRadio_url(Config.RADIO_STREAM_URL);
            radio.setRadio_name(Config.RADIO_NAME);
            Constant.item_radio.add(0, radio);

            startMainActivity();
        }, 100);

    }

    private void startMainActivity() {
        new Handler().postDelayed(() -> {
            Intent intent = new Intent(getApplicationContext(), MainActivity.class);
            startActivity(intent);
            finish();
        }, Config.SPLASH_DURATION);
    }

}
