<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Streaming <?php echo $dados_stm["porta"]; ?></title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/inc/ajax-streaming.js"></script>
		<script type="text/javascript" src="/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_stm["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<?php if($dados_revenda["url_logo"]) { ?>
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } else { ?>
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } ?>
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1">Downloads</span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/dashboard">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page">Downloads</li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
					<div class="row">
						<!-- cards -->
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                          <tr>
                                            <td width="25%" height="70" align="center" class="texto_padrao"><img src="data:image/png;base64,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" alt="Download" width="64" height="64" /></td>
                                            <td width="25%" height="70" align="center" class="texto_padrao"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAbvAAAG7wBureguwAAHC9JREFUeJzlm9mTXMeV3n+Zd7+1dFfvC9DYNwKCQEoUpRlLGo1G45hwjP3ksMPh/8rhCD/43TMRtscRMyOHLIU8EimSIociCQLEvnQDva+133tz80NWAyTAXZRenBEZBVRV33vzO9855zsns4RzzvH/8Qj/GDdxOHpb2xT9AUW3h9UK5yxCSP+5M0gZECYZ+fg4SZ6RjY/9MR7t6wfAGkPZH1D1e1TDIdo4+tvbdNfXGPb7lN0uOI0zBhAAOGuRQUCU5qTjLeIsZ2xhnlqrhQgkcZ4T5xlxnj0B7esa4ut2gf7+Ptt377N9+xb7jx9hXIBWGolFBoIkDQiiAGcdVlkQIITA8wSq0qAqg3OCpFYjzFImjx9j+uQxpk8uEaf1r/Nxvx4Ahp026x/eoLu9Q3ttHVUMcMMBYRQQ5zlpIyeuZ0RpTpLnBKEEB1Y/BcA5h3WOojeg7A8ouh2qokArjSo1MoxJGg2mT52iOTvH/AvnkfL3Z8NXdgFrDLos0VXByrvv8uDNt+jv7RNKQevoHFMXTjN3+gS1Zo201YQ0hiAHEYMzo6uIj19UCLAayiGm7NPb3WOw32b1+m12llfZePiQvYfLjC0sYlTFzOnThHFEGMf+b7/C+MoMKDod7rz6G7bvP2B/9TG1Zo2JxVnmTi9RmxgjbtTJsowwCiCpQZSDTAEJPHtLMXrPglUYpRCqhHKILjXDQZ+id0Bna5u1G/fYX99FaZh/4QLHvn2Fo5cvf6XFfyUAym6HnfsPWb12jc0bN8AZ6lNjHH3xInMnj1BfOgEkfkFW+TW5EESClQFWgnB+yc8aTTqLswZjIbAGKUaPFoeABtNn89qHbNx6wOMPbqI1JM1xjn7rWyxcOMf4kcUvHSS/NAArv3ubmz/7BfuP15g5vsjJl7/B3PkTRI0cgcWYBGUzojAkTGKMDLFSIp65ixQC+Rm0tc5hjMZpha0KhK0IQxDC4IxmsLXFw/ducOvVd1A24OwP/5SzP/g+jZmZPwwA1XDA3d+8yb3fvIrUBZNHF1n67otMz04StZpAgLMCbSKciAjDGBlFOCGeEF4AOB/thRDPRgCsY/SZfzXWgTPYqsJpRSAgCg0CC6ZDd32NtYdrrPzzbXqditbxE1z40feZPXP6CwPwhYLg4OCA5bfe5tavXsWpIS/8+Xc59a2LRNPz0O9iuhVapBBniCQjDBxShjj8Ij+20E9Y+OFw+Exw6CKBECBDZBJiQ42pNLrfQ6qCKDI0FmY5d/o00wuLXPund9m4eRMpLFYrJo8fJ86yz13bF2LAhz//OTd//n9JajVOvnKJ498+TxoLbGWwJsSGdcgbiDBGBpG3kBgt/SOXd3w+9d2zgB2+7xxKaVxZEFqFq9o4MyQKDEaG9HqGG794g9VbDxlfWuSFn/yY+XPnPheAz2RA2euz9uE17r/xNkEAJ1++wJlXLhBmEfSGqCGQZrgwQ8gQGQQgBc5KPK4fx9b5lXzmAwnAciiOPvK+EMgoAhyBAUsNU0l02SWsScYW6pz/wTdwtmTl+j1uxylZo0FzZhYZBp9+v09jgLOWx+9f5YN//CnOOS58/0WOnF8gziTsDFBhHdOYQaQpyAAcyChGBBE4+5mL/KrDCYk0CqmHPnE6gxoOoLNDbPowP05vq837P3uHndV9jlx+gROvvMLEkcVP1QmfmjM6G5usXrvOsNth7swC85eOEtsObn+PKkyh3iJqNAnjmDCUhGGAkHJk5hH9hfDBTvrX4ItMKQlG1zHKYLXBjl79E0s0Eu0kWkS4tImL6xgroL1LPXOc+7OXqE82uPfbd9i8feczRdInAtDf2+POb95k595dll44welvLpGlCro9TBnB2ByyMUkQRSPTuCcRXmAQziAwYP2Dm48sQAgPzBNwnpmH18NqnFE4o59OrbDGYJxAG40xBhGlyOYULp/CHRQw6DJ1ZoqTl48RBILld37H6tUPMEp/MQCsMRysrbN5+y5xFHDq8lnqqYNHj9EuRYwvEGVNAiGwZYlRGqWMfxirkc4DIJ0Go9FVRVWU6EqhjcHi05uxDuOemTiMsShtsFojxQhIDDiD0yVWVwgcWIMwFdIpgiQlqLcQ6QQUBtYeMTlV5/TLVxgeHHDv7Xcoi+KLAbD36BEP3/otathn7tg0E9MpgVMwMIh0ElGf8n4uJMJaAq1Aa5+zcQjhEFjPOmfRWqGVRhtNWZRoVRIID5JWGqM0RmuMNjjrMFpTFQPKqkJpS6U0xtpDEYEb6QiHQ1iLNBUyEFBrQGMaSGB7l2bNceKFebI8ZPP2PR6/9z7DdvszAHAOazSr1z5k88ZN5o/PcezSEq6/DYMC6jPI5gwiycBUYDUCS+AsoXBIAcI5X+Y6gXNiJGwcxmqUqigGA8rBEKMqnDE4a/0cWVxXClUOqYohZVlSVppKWQ+AtQhnEc4hDx/cOZxWOK2xAlxtDPIWKAFll2ZecvIbx6jVUpZ/+ybb9+49B8CTNGitper2aG9soSvN5OwUtYkGYuchhBk0xnBphpCA0k+TdRgQCoETFmEN1gYYEWOd8A/uxEjfa3ACrSVFZYjCwAc7BNYarNJoo9CqwBiHtRZnHTKKkTiEKXHWIGRIFMQ4LNpqNBE4AcoQEhDEOWQ5VHsgBIvHZznYrXh84x7tje1PZ0DR7bF89QM629tMH51laiYlDPqgBpA1oTWPiCJf4GDBWRwW46zX7EZhrcVYh7XmiaWQAlOW6G4PUxSURcGg26MsC7TRKFWglcJah8MzB20JHYTSq0alNFWlAUkQBGAtziiw2oPjHNJqhNOQZTB9BGSKa+9Tm8mZOzmFkIa9lRUGO9sYpZ4HYNjt8vjmLYLAsXR+iZgu7G1AnEF9GqI6whhfpiJAyCc+q6oKpQ3KSYwQCKcJ0UTSIaUArbGDIbYsMOUA3e9S9ruUwz7lsI/RCiElUZwQhwmRECRRSJrEBFi0MSgCZJQRhDFKa5QxSCkJhSMWhkg4pB2CdNCcxWXToBwMDshTy+SRWarhgPWbt6j6/ecB0FVJe32TWBgW5sdIqz4c9CEag3QcRAjW4bTGGYvTFqwjQCCExCKeFDMOUNZicIShRAiHUkN00UP3D6i6+xR7e5SdPkYbRBQShoJQGCKpiWPh6wmnCVFkcUie1wjDGKcqbNFDWIMMEk9/Y718rEpQBuIxRNrypXF3l8wWTM1OY7Rmc+URVVl9PAbosqS7vUUUBEy0IrK0gu0OhHVoLHoAjMIZCwZf0GO9PBUBAou2BhFYEIEPTs4hREAUhmRpgA4qdFlgdAVIKh3iKkU+PY3EYtUQoUvAEaYx4NtkoQyJwhApLa7qYoou0iiCOEdGCc6B015ziKKCIAAXQj4NtQk4uENiQxYXjrO1sc/B1g7lYPBxAHrbe3Q3d2hMjNFoOSg7YAtIZiAbh+DQ991IxMCh0nOANIrIGYiikQgc8UAEgCCLQoihXw4pVIEIE4wqcVWMMGO4sqCqCpzRBElKlMTIMAJrQEiMKbHDDq5qI3CEcR0RpyAFQgYjyxe+no4i33KLMkhbnqWmQz035Img6DlMWX4cgM7ONr3NdWp5SDNTUHU9krUWZE2cCECPaPMxWTmSvFYhTAkmhiD0D+6c97AgItAl8bCNLfax2qGDAGmHBKWBfgoRSN8lRSgLQ4cLw1FBJTC6QughAkcQJUgZggzxuVeD7oHqQRj63qMdQhrBxCxspIhinyCqqNckex3D/uNVWgsLpM2GB6Do91H9LmNZg9gUUGifSpqt0YIsaPMJsmkEgBTeB1UBBB4wpHcTW2Db23CwSWQGZDKhNAWRHBLpArlvEaEjHptERLFftB6Ack8yrXMghCRMxjwzjFeGGAtm4BcvNCQZRCGYEqIA8iYun0QMd6HskcSCMA45WF2jvbn1FACjDFoZZBQi0T711eseBBkhnAOnwD2DwGEdGcQeC63AFZA0EHHypMMrix0CtYtFEDrjo7UbtUtUD5lEyFoTWa9DNPo7pcB8RL8L6YOa800ShPT363a9u+Z1XJiCCbwxtAQjIWn6THaoQMMYVQx8FQmEVinKYYFzjjxPSAMHZQWNyPsRzjOAQ1p/wghGvl/2wFaQpJCMwaAD7UeInfsE/V0II8IwR44AdWaAU0NIUzCnEVGGyBve3cIRAEKO3M67CKb0DNB9/7lVXqiFNSACNSrFjQACSJsgYxh2SIOYPKvR7/QpR6kwrAZ9lKqQgSONBJEUXkra0CNp1YjOkk/u1Yw4au2o3WsRDP2/VYHrrEFnF0pFaJVvjQc56BJMG6zCYrBC4KxFaAVGjXpi4dP28WGDRRVQFR6kIIQ8hTAHFyDMYeHkQCYQSt+rMBb0kFgGpImkpzWqMiMAhgWmKJFGE0iNMJWPqiKEMH6G658ynPWWihveJ4suJAMYdmF/DXrbCGv8wpKGL1xcBAcDGGwjyiHSFohyH3R3BKb0CzFqxEBA9UEXQOjdLowhjCAUnhWHz+IsiNwH8jD111IVMSURBlWUVKVXg6HRGqsUVlc4U/oAZEf5NEo+3eofR8BbKRrt2xVtaG/B3oq3vlM+PSlPWRdYaC5BfQ72HkNjGikkVAMf3Nyo+rMO1IjyQvi4ICJIQk95GXtd4qqnTDxM09b671d9n9WqPlJESKvQRYGuRgAI4StubS3WWi8lQ+kRlqMtJ/sFW1zOgIxAZjBoQ3fNp8fId4yRkbfo4ACmTiJmL0DriA9qcd3T1VY+qGFBSm+E0HpDJE0QKQTiieBCw5NNB2ufGs5JKPq43jZisAtqiIvGPJdHJTxA6HNtAGLkQ6oNww4M96AqcLIGHLayP4cNzvmAlAhor8BgDZIArAQqaDRBVYj2OuxvwMw5WDjvY02/7a8vD93O+EXGoQfCAUECLhiV48Yzz37E8kHs/0Y7UB3o70NZQlHAYMdnCiG9gUO/Fum7rTFBEPvlDXvQ2YSDR9DfhqryDzZqSHzuFMLHy+LAu1N93Fuot+VvnI2i/MYtWPvQB7UoHvnu6MyATL0PywyCmpfkYc0zZVSJPslI4iMzDP0zFF1vRGcRQQ5EUPSwxQAnQoI8J0wTD0AQhQRhCEGEk5G3VllCuQfDLUTVQVjr6SkMCAVSf8JUICpvaVX6GNDtgKzhjMR19mGgQdZxaR1XdHB7q1AOveWi2Aerw4oK/L+19kZQlX/Vio9VXQifDYLQA9vfg+4GoCEfwyUpOA1Oe0+WEVGSEY76mTKt14nTBIeg0BJlpE8bZeVRLDo+OFntAUB7P35uWr+Qogfb92Fn2QehdByIce0DXOcAggzGFqHow+Mb0N701owzHyhD4QX64avQgPL3RYOwnklJCJEcCbDKX6+762OPtb6GyRpgu6D2IEioXEJhIIwT4ti7WhiOtrCdMZSVRRlHJATYGHTsF6aGPqhEgX9V9uNbOM5CEOKSOhT7iN0VT8O8Dlni5anVONUFaRHxuLdidxv6BzilfAyKAgjg45r7E7bSxUh+m9EO9LDvn1GVECe+LZa1oOog+htQtSHKqEgoKp9RgsDfIxRCkqR+J7eyMaWIyQMB/R4MC6/ydAFDBfWxUWX4DAB2tJkXpYh+G9buw1DD1KxvpLgAtIVhiQjrMHEU4vdh7zbsLkN7FdI6SN9j8JHtE4YQXv2ZwruEVv7V4NNjWvMza/hsUPRgaxO6fZibROk62sTEzYS0UfMAAGTNOmmrReFiimDcy8eDDZ+jT7zgfbMsRhE+eBp0DkcQQCAQtoL9R7B1HxqTMHkSZA6VQVQGisoHtIklmD4FG3dh/TZiYg7mznvL6+oTrH4IgPQWP7S2tf67Sd2nyCh5OlXfi7D1x9CvIJ+g7NdwJqQ5N0N9auopAP4wUo1SOZQYg2gcBnegu+4tkiQ+95oSzEiFPYnG+AAmAygL3ME6rr+GmJ5CtFreX1XlU6oeQCgQeQ03NglRgGhvwMEWzJz13xu2n/YTnnWBQ9ZJ6Su/IPVpLxjdH+ebMTKEaogYtH1ArAqIxqhMgFIFtYkW+fg4T5xtbHaWiWPH6Xf7tHUKrSWv5h5fhf3HXsg0pnwBMtjzefjQFwHi3P9/9zFs3QLbg8VTcPzbvp9otLeaLnyh1JiBc38CC2c909bveNbHOSS5j+hyFN3DxMvZMPXSN8q8aErHIBvNKBuJqEOD1Hze33wPBsu4OKGKZukMQ9RwQG18/MmuVgiQNhqMz8+h33iLnjO4bAIRJdBZh7UPcTNnoD6J6O/4ii+MIa75eIDDBREUfcTOA0RnAxFnUJscFT3WFz5iRFflRYyoT8HYgvfj9ra30uQU1Oo++1jl6xEZ4iPjJ7iFdfjs8JEYcbgtf7ACm9cg1KjmHHtVwlBp4ih6kgKfAODdOACt6RGwb2s0GpNEO3fh/ruIpZdh5hTUpqF46IVSPuFZIQRChlAOYOsu7G54d1m5CqSwd4A72IQkRAjrAQ0cmACx+QgGPegfQHsdxqe8RavSU1sE3u+fVaCHlaH7qJsIz5YgQNgC1u/C8h3IcormIo+3SyqRM7swS5KnzwMQJQlHLpxlc3mNe2sDzsxcZtwcwN23YPo0LJ6H+qS3zM5Dr+dl4IOPUdDdhNVrsLsGzVl4cB3WV3wE7qyPNEIXbr0G6zcgaMLOmmdHZxOW34WxGc8cJ/w8jDOfV40eZqF0zDdzVt6Da6/C5gZc+RPa9TOs3jygtjTL8RcvkTWeHrZ8knDzsQbHrlwiaTTYWT9A1Y7BxDHo78Kj97y4wcLkon9QZ7zWNqX37aLtVZjqewZETSDBqR7oEqEF9DvQ2YFBCUSQjlpYgz0fP/qdkcWdV2+2Gp00058zlf9unHgXe3gd1m7jpIB8jkEwgSk0eS1jbG6eIE6eByBMElpHl8jHmuzv9diU81QT531guv06vP13sL/iLd6Y8btFQviiZHcFHr0Pm3ehvePTXW0WalNemQ33vSUHfdjbhYO2P1nSGINiCI/vwcoN2F72wVIGvs53hlFX5tOnqSCKcHnLt8gfvg+v/x3sLyOOn2dTLLC2FxLEMZOzk4RZ5s8xPAvA4ZhcmGF8cY6trmZTT2NO/anX42//A7z3M8+EIIGxeRibgzDGrd/E3X/H6/ps3HtW5ZkhZIJAejcJEggzhNXe6lXft86CGrT3YeMOHKyNyuD0I74vPn3K0AfkMIXlD+Cdv4f7b+HGpqlOf5/lfk67UzB37jSTR+ef857nzgjNnTrOcG+X+9dv8zizzF74AcHqVbh1A9f837B4CfHCj3BxDuUA4RR0t2B/FepTXvzEdXj4LpR931lOx325Wxv3zDF9xIe/9oLr+EtQn/HW31/3DMonRpUdz8W/J28a7ZmS1iEfQ1R9uPkreP//QLEP06/QaV5k784jgsiy+M0rjM0/D8BzDKhNTnLi5ZcYm2yx3Q95IJYoLvwY5qcR7/0a/td/guv/5APP+Iy31uotH/AmTsDiJZ/SVq5CZxuOvACto9Dv++OyR8/D0XOwuQL33oeZI/Dij2BqETbuw+23vIRlVBmaZ6f1jAwirwDrU7D1EH7zt/DT/wobq3D5e+we+SG3VsFGdU5cOsP8+XNEWf75AADEeY2jF86Q1pss311ja/oi/MlfQZIjfvdLeP2/e7oCHGwgdjcQ/aHX48M+bD3y1Jw/DZNHPD3LwsvX+iTMn/Ny2Blcdw0nnXen7h6s3oDe/qj3z8jV3dNp/FkB3wmOoRrCh6/Cr/4Glu/BwhG48tdsxUfZuv+A1tw0S9+4MGqgPD8+8ZhclGXMnz9Hr93n7m/f5uH4As35f8H4S/vw2t/DL/8GkeYwWMdtLEN/D1H14Pabfnu66nqadg9g+boPkow2MXfWYHcLksjvO9x4CzbXoFS+jtiehs4advoINqkTWOUbteAr0bQJWQ3yHDZvw/XX4X/+Z7hzDU4vwA/+PQ/NPMtbJWmjxvzZUzTn5kbZ5fnxmQclu5ub3H7tdbb3hkzmcKzeZ+Lq/yB871fQqMP8WZwMYG8VsX3fi7LzV+D0d6Dfhfsf+KbooOOLqFprVF0qOHXZF0yr92FrxSvMzR04cw7+/D9gXvrX2OYsYdlFGOVFjgx5ctp8+y6881N49R/gzm04Mk35F/+OrWP/khtXl7Fhztkr51m8eJGk2fy0JX72Qcl8YoJzf/YDql/+mkfXPkCdPM6FC39Bqx7B716FN95ATOSjLekEJqbgO/8WXvoraK9B/7/A2gp0C5hNoNiFyvgIP3cKLv0INh7Ca/8Nrr4JbaDXh+1VZGcXmbd8cAsSn37T1LNp4y78+m/hrV/Agx24OA0/+Y9sJee5cW2VstvnxLfOsXDpElH+vN9/YQCCKKI+Ocmply5jtWJ3d8A1O8XZE3/JTNBCuF/AxjpsAXMSN9PAzp3ALV1EyheR63dh9S4c3IRe5VtirTocvwKXfgwv/ivobuOSzMeXq9dhdxtuvo04/m04ehFoQNHBrX+A2FuGd16FW7fg+hv+VP6Vy/Re+QnbtcvceaQolWHpyhVOvHSZtNH4zMV/LgCHY+bUKRoTk3zws5+z9mCNe8EU4hv/hsnJFvKNf0TYR179lQPsjdexCMTR875Km16Ax7egp6EHLEzBwgUf0dfuAhaWvgnfVVAM4L03YfUePL4NZ9a9ylu9DnfegjtvwPWrsONwjRj7ne9hX/lrHoXneHBjGV1qzrx4kRPf+y5p44v9tuhL/V5gb/kRD967xsbt24RxwNFJw5GgTXPjBtx4DTYf40QLu7CAnD7m2+w7D3yaGlZQAEcm4cxFnxrTcb+d3Zjw2ePO23D1Da8OX/4JXP4hHGzCe7+Fezeh04ZZ4OhpOPcjHjXO87jt2O0FpLUai+fPceTS+S/1m4Ev/YOJwd4Ot159g7WVbZCS6bkmc3KDsUf/TLryIcnDezDcgT6+VXW4uXTY44jxvf5Sjz4PYHzWb5k5A7uPoF3CWA6tSSj2/FEdajAxQ+/yRcrjF9ge+ybr+ykHG5u0xmucuHSepRev+DL+S4wvDYA1hmowYPveA+6+/iYH6xuEScjSUoupWsX8YAW5egMevg8P1rzVFaMOL09l/OFdBaMdYCA43NkdzRxoJHD6Ahy9QDF9lodilr0ebD3eIU5CZi9d5MQrr9BoNAiT9GM6/w8CwOEwZcn6rTu0t/do73coOvvYoksy2KRpurREmxlzQFJUiP6+Z4UewMEBdIdemATSixrrvPTNMmjNjFyjiUozhmmDrbhFx9XYFw3KfJ643qLRrDE5M8bkyeO05he/yhJ+PwA+OoZ7O9x+7Q22Hq7S7hXkUy3qYxmzmaVmhzQGG4SdVaTuITrb0OuC0X6byjlEGPpubpxh8xl00qJszdPJJhjYkK29ku5+D9XtMLM4w/zZs5z8zrcIk8//RcgfBQCrNb3dXYadDqXxewsbN2+xd+M6IZYIRZ5HJFlCFlhENcRqhdEaHMgsQyQ1HDAcVAwGil5hMHFGFCdMnj1L68QJsjQizxLS+hh5a5wvtnP9RwDg2eGA9bsP2Lh9D4dAjbpXzjI61VGhqhIz2qIOkowwzf2hZ+H8roB1JGFIGoXMnTvF5NKRr2G5z48/CADPjmrQ52B1jd7OLt3tHaxWqLLAmhEDwog4rxFlKY35WfKpSZpT08RR/PkX/z3H/wN5VwrTvApESAAAAABJRU5ErkJggg==" alt="Download" width="64" height="64" /></td>
                                            <td width="25%" height="70" align="center" class="texto_padrao"><img src="data:image/png;base64,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" alt="Download" width="64" height="64" /></td>
                                            <td width="25%" height="70" align="center" class="texto_padrao"><img src="data:image/png;base64,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" alt="Download" width="64" height="64" /></td>
                                          </tr>
                                          <tr>
                                            <td height="70" align="center" class="texto_padrao">SimpleCast 3.1<br />
                                              <span class="texto_padrao_pequeno">Windows XP/7</span><br />
                                              <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/SimpleCast-3.1.0.rar" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                            <td height="70" align="center" class="texto_padrao">SimpleCast 3.2<br />
                                              <span class="texto_padrao_pequeno">Windows 8</span><br />
                                              <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/SimpleCast-3.2.0.rar" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                            <td height="70" align="center" class="texto_padrao">Sam Broadcaster 4.9.1<br />
                                              <span class="texto_padrao_pequeno">Windows XP/7/8</span><br />
                                              <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/SamBroadcaster-4.9.1.rar" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                            <td height="70" align="center" class="texto_padrao">Opticodec PC SE<br />
                                              <span class="texto_padrao_pequeno">Windows XP</span><br />
                                              <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/Opticodec-PC-SE-winxp.rar" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                          </tr>
                                          <tr>
                                            <td height="20" colspan="4" align="center" class="texto_padrao">&nbsp;</td>
                                            </tr>
                                          <tr>
                                            <td height="70" align="center" class="texto_padrao"><img src="data:image/png;base64,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" alt="Download" width="64" height="64" /></td>
                                            <td height="70" align="center" class="texto_padrao"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAcIAAAHCABzQ+bngAAHIFJREFUeJy9m3mcZVV1779r733OnWqunoumG5puZoiAEIY4ETQiYIgSpwg+J9Coz+QF55AQxaeRZ/JiYkQTEo3mGU0cPk/jkIhDVJCAINoCTTMIND3R3dU13XvP2Xuv/LHPuVXNIKiY/fmcz61bde65e/3W/NurRFX5ZS8RaXXOPXw9QwvHxbx4crO1vHvGsR/43shQq9PzPbO3p/PT0/v39/Y8sHf69pu3PfCFq/b+0jdV7+2JBkBERtxzR9a6lW6TsfZw03BHSM5GGZYpmTCTccS32/eMxldv/PDc0IopN9Pryky3LPf3iv5st78w1/fT3W7vPt+dvcF352/o7vjJjT/628t3PaGbXLrfnxcAEWm454+sNkPmYNO0G6XJcWbSHWcyWa8xrgZpGCvIkGBWOmTSQEsIvqDxHy1+b8NHGFu7gen5BWb7nv3dkn29kpleyUIRKIs+sewR+71twftvxaL3+bn77/ryrR995/7/dgBkqDXROLt1GGP2MLfaHC4N2Qi6UTI5GFguOYIRUEULRUSQCYtd7ZBlDjLQQtFuwM8WtG7q8L+O/BvG125g3/wCM72S/d0k/P5eyUIZKEpPLEs0emLwaIwQ/NZQ9D6xsOu+j/zwr9+27b8FgPw3Ro7JT2v9ixmRQxDJxAJCEjYIoooGVUpAEFlhsYdmMA4hBMJ0IOz1yB5wpUMnI+07hnnLsVczOnVoBUDBdK9kf9cz1y+ZLwI9Hx4OACAKMZTbfb/7/h3X/dtf3fuVj3V/EQDc40Bog+mYTZIBXtECJQJBFZQQo3j1aBORlQYzDLoNGrfkjE2PMdGbZKWsZipfz+7p3Xy5/CyqEWeEzArOCM4KVkx6NekyRojGgBrEWEhfByJq8+ZqkzXet/Zpv3nBk9/2kbf+57tfdc0vDQAtFS0iiKQNxCi9oh9DGdA+0uo3ZZmdZHl7OasXVjFlp1g7dDBTEwezYsNqxseX0RkdozMywRe++Rm++JN/RoPirJBZgzOCkfo1AWEkYkWIxhJiBCIiBkURQRAw1kHWOLmZN79y6jv/6Z3XXfbCd6lqfMIBSEIrlOB3Ffu6Oxd2HTn+K6uPX3bE8KGr1sshyw5l7eRaVk2uYGx8ktZwh6zVRDJLAEJUihAQaeAaFrxCgMwacmtw1pBV1pAZwdZWIYI3MtC+AkQPkH4nFhGQrOHy0fzy097z2Scd+fI/esWtV1/+M6XQxwYAwAp+f7m3++GFy9733o+d+8zTT9qwcvkkneE2jWaOyyqcAB/B+0AZIhqVEGIyXyKgRK9IUJxJgufWYI0gkszeSnIJF4VMDWqUGAWMAckghgSCCIggFUj58NhvLjv65NXHvu5PL/jhX77pvscLgHnMOwTFqPbLcv4Df/u5cy+5+AXP2nD0Bje0YlRcOycapfQR75XgIzEEUMWQYqURsFL5u0iygAiZExrOkFmh4Sy5FXJjBvc5I1gD1hrEOURMuqwDsUl4axFjUtYRIWsPnTJ26DFfOP4N7z/4iQPAgI+elaNrpo48ZNWzvIduv0+/KCnLkhAjQZXKSDGAMYIxlfAmZchaIDyg4Crzz62prCFZQla7Re0aBqypQLAWMZXQJm1dRNJ3VlfW6hw3su6If9l04ZsnnxAAyvl+lCErzeVN431UHxQflahKUCXGiAJ1OhURBBAxlfAyAMEagQgSBWeS8JmVpH1nyFzS/lIw6stag3EOk2UY50AEY0wSXBa/x4qQt4dOWnncUz469dTzs18YgI2bnnHU0KYJmDQEH6UMkVABEBViTMIrVL5eb4gqqqcobw0IggQBpBLckFtLw1WvtcAuAVSnxNwaGtaQm5QtMmNwxlZAC0iyNgGsgDOQd4aes+7ZF77zFwLgRe/bsvYZpz/3f5pc0RjxUfGVyYeQLKCO9FFTebD0wabK50n7abMaBUjvnTOV/5sBGLlN7jBwBWOwApkRGk5oWIO1CUBbWZupYkB9GUnW0xweffPJl/3DM39uAE4+IbtiamJiTa/oEgP4qJQhXRGIUQlRUYVYWcFDXWHRCpILSBREk4YbVdDLnaGRmWQJrs4OSfNZ9bvc2UHKzKuCKatepdpvlRiojILMZbQmVvzZYc/73eGfGYAXX/VvZ4523Ev7ZQlB0aAUIZJcIFKEiA9K1FjFgiWuUD9cBKkymJUKFE0btkaqarDWfsoGrczQyOzA93NbAWBrwJIrZJV11QBI9fzBd1ZAuGbzqBUnnfnGnwkAOfFSe9Dq5X8IwkJRoqWCV/o+0q9AKIPiVQkRvCoRrVxh0QrqL6jdwIiAGpCUEdxAQEtmF4VuuOqqrCM31fvMVLFhMUskgGVgcZBijVKnYUPWGXnjCW/60LpHkvURC6FnvuzM38gz99SFwtMtI+oh+kjhA30fsRIRBCtU+d4Qai2giBWM6sAnkzVUWlEwCK3cMdLI0JilLAFAijFFiIRo0QjGRLwYfIxEVUSSJRLAGYMSB8DXK7liDYZiXTbRnFh5CfDWx2UBk8OdVxVemel7umUAn0DoloH5wtMtAv1QWUMdGGMKiKr68HhQXS4ziBFQIVSfi6pYA83cMtbMWTnUYFmnQSe3NDNLbi3NzNCs+oa8spA65aUgmbSfqnYdfK+qJiswgmu2X3LMJVcse0wAnvTWq4/EuLPmC78IQJGqvPkyMNvzzBeehSJZQxFCigdRCTEmd4gVANUzbVW0FD6mJgaYK0r6PpAZw1CeMdnOmWjnNDNLO7cs6zQYbbkUE6yhmVuazqYgWLmEtXWATa5ArXldYgm1oC5bOzS14byHyvswFxhdvvLcUmnPFx60pF+G1BGWynzfM9MvabuwaNoDDUv1TqugFFMBY4Se90x3hb3dMgEghqZzDDcyQqiCpDGsGhYOHm9z1955bt81y0gjx4phtl9SxgjYSqhIhiEoxBixRggIMaTvDpXmaytQTQ2Ua7SfB1z9qBYgImKs/Y1+iCyUnoUy0PMx8QBlZK7wzPRKZnqJuFgoPfNlsoQyRApfuYIqipBZS78Uds5AZi3DjTbGCiLpa4NGgsbU6qsiKMMNx0kHjfPUDcsZbWa0M8dIM1uSKRYrTFcFQQFspQISMVW1XouXCBiXnXbc669c/6gWcMwl710fxD6pDIohYiX5OiEFwfnCM9v3eB8HWq/9W0g7Ea9kLmfIOu7fuY+v3X0ju7rbycVw+32bMWrBSEqdyqCGsJXOUkeprBtv084s/37HTmwv3TfTL8lU8NYQYkhtsxGiGoSAUapCSwear11AVVWcG2uvmDoDuOcRAWivWH2Sqo6VoY7yAR8jEoEAXR+Z73uCi8nnRAZfkPgSS+Ya5KXjM7d+latnPsPW/hbm907T29VF9xT4+QIzXNX6Rgi6WMOLWSxkfIwsH2pwysGTfPvuBxGBfghE1aqxElRTJvAxYBASDIoIhKosXQIAIhZr81OAjz8iAOLcsWj6sDcOrxlBLQRJhZCPzBWBEMNi8VG9IsmPhxaUD9/xd/yN+yTznXlkwaM9j+l6ytmC0C1hOBEijcwSJA4ita2rRhIHU4TIweMtDt3f4c69cww1MvplHGg+xJRBjBFMrFOuDjLCoD9JlyiKOHeCiAwyxQEAWJMfJd5R9mbpyQKFy+l1p2EokTFFjPR8AA0pr5vU69fW0DaGf77tU/y1vZrQ9sh2JU4XxOmSOOuJC4HYD4igI+2GKEpAGGk6iJGoqBEkKoQqmavA+okOO2Z7yQ16Bb4QrEnUGSbVI2WljCqWYaQq00NARVLXBoixaw9/8aUTwN6HAdDfP7t2/4ob6B50C71yF35/H9/sEaZLzIzixyJ9H5CYXMBWHJ6IkLmcu+67i3/c8wm6nRnsbov2AmGmxO8rCPtL4lyJBKXlOvLZ7/74h0Vv87/3ewu66Zijn/LcJx9x0vJOLn0fq7iQagQUhpuO8XaGD0o7c/R9gYSq5U4lWMUogYnJDeql6WHJHkRQdLS1cmrFwwAYOfWoE5e9Zs3hcdODFPvnKbb3Kbs9/L4Sv7fEkXJ9ERSJKQ06CQMGt1XCrdt+wI599xEejERv0L4nzHnCTEmYLQkznsaqFtM7e7dd9u4XnK/avbPS2MSWT1zzrrecf8ZrhnNHEUPqM6qC1giMNjOmuyXtzLK/l0ppU/cXg4q0Mn7hgJW4UgUVUG27Zmf0gBgwfPaqI8Z+b9Wn/Lo9o8XOLn5Xid/lCTsj8UFFZzyxlVJW1EipigkBFwTnA0YM3czT7fUo9nSJ8xGJghaR2PWEeU+c88RhIW8P92av2fEntfCVlvaKyO8/57b7Tz5t45oTQ1D1USWoYkRREVqZJbNCK7dVCb5Y/Awkrkpx6hgwqIrSVfm9E+OG6k8aERlqPXPk3XEoHNrdOqPF/V3KnX387pIwHdC5AAVoSB1fiKn/D1EpQ6AMSuEDC2XBmuFDGC8m6M7NU+zsUuzuUe7tU/YKignlkA0b2dg/9asLm3d+mocsVe3dsbf39cKnajJoxNcdZ1SMSMUXpLY49Q91k7Wk9FvaFC0ihMYA0VfpMQ4s3+UnDZ8VjX9a754+YabUOBckzgTCfo/ORLSXQpUzHYzrEDRiqMgQhTKkqNwtS9YedBjnbb+Iz3X/jl1hOwSwww1GOyMcu+xYfdUJF8ryNSfsevpVH/UPBQDgsBXDbdVY9QkJZKmY9KjQyizdMtJwhhCUwqb7nFGMUYwKNgqBFJ9qF1q0Ek3usMRFnIzIxnJ3rxULj3ajxG5E5wM6n4QnRLQRWT5yOo2hZcQYFuvHKsOECIUP+KzFr516HkdOHcYDezcz25+jlXfYuHwDJ206gcM2HUJP9ayPfu/OZRedsuHBpcJ/9kfbJ09dN/6cqFTMU2qqJAqqqdJsukXeIMQEvo9CGQyZicS4eKpkNLXCagxoZFAcR4WoxQCAcG9xn9+YLagPTZ1V1TIKvVT7q5RJ+PbTmDr0HEzTJlOqmpu664uatDXXLxgdbXPck0/ntyeeSSg9Yg2NRo7LjIDSUtadc+xBn7pzz9xrNkwO3Q5w267Zw09bN/6hTm7XLRSRMkTxVdoKGhPZArRyh1koaWcOVfAhEkiABTVETe7pjKSGzEBUg1Y1gmJAtQi+mBsA4Lf2vipT9lP2IHdJjIXRMqAS0Tzi4jCTQ09h/REvobVyJcSAWjMoYWtAkzEo3SLQLQJ7FnroimHarVaiyzVxihUtpiN59vSms9+Z6ZXXxqiyarhxqhWZ6PmovRAkxEiIiTckKj0fKxLV4qzQyW3iIKuu09f9hyo+msFhlkokqsHbjKAgEURkPnQX9g0AUNU9IvLOeGxzd2vdmle7LF+J5rSygxgfP4nxdSfSmpxEYyAIWEnI1vRXjMn0ogp9H1goPSwoO2YW2LBsKPkxi+cEQVN0F5FJI5yDSRa04AP9MkiIShl1wPeXEXxQxloZXR9oOsNQMxuQHomJiqja5I7VH6KpgDCRqIIam2KCyPT8A3cPBi4cgKo+AFx2zO+8u9maWnWpzZq4zijZ6DBihRg9ru7iJKEbKnMLIhX6UAZlpleSWcPtu+dYO9amldmKyWFgolGVdL4QCZUp10GvjCmPO4EAdH2g03C0MkvPB9q5Q1XQqAPLC7FWRl31phpCvSFaJaoQraUKi3dv/Ze/nDkAgHqNHnXEN93QyKUma1Q5Vgcl5KLJV0RohKAyOCDxIeLEMl8E2lkgxD43PTDNGeuXVc2NDgAIA4pdBxG/ZpXqozQFemWgYQ3LOjk9HzEitJwdaD4JXXd+Qoz1721VDcT0Pp2s0leLBn/DUpkPAGD23ttvHNv0K7txbnmdK2ylubqw0ErogTCSBLCilDFiIuzrFoy3c27bOUPTGk5cO4EVqqPuxQPn+hmpQBFc1Q2GCD0fsCKsGWsNWrqGM4PPD1ZNfy0phpa8S3dXHyh9IJTFtUs/fgAhcsuH3roj+OJ7S79BRA7g3Ooee6D5WOftxfzd94H93ZIiKDdvm+abW3cx2y+XcPiLlLazZnAKJEARlPnS08oc6yeGyKugu/SoLHeGljO0M8tQI2O44RhpWIYblqHcMZRntDJLO7M0XM0tGqzojunt933nUS0AIBT9L8ZWOMcal9BRlpScDA5EVFIUrmOAj5LYWqlSj3qiRkZbDe7cM8febsHGZUMsH2qSWxkQIVGVIqaqr6gGJ1aPtBhv5YP0agw4Te2nWkXVgNOHsT7UpAwMmrWaqAOYmyu/vuWqt+z+qQD0dj/whbwzegVZNlHLbZb0z8Ki+cbKBcqgCLEmpVALqlIFyj5jrYys77lj9yy75wvGmklDzghaNTK5NYy1HMMNlzi+JTy3qbqdqIqzZiDyUleohU7OlFiV+nDEGoOPBb1e72El+MNY4Zv/7xvvD0Xv84OhpMqnjDnw1lhR2iHExOX7RJH3Q3WA4hN3sFB49i4U7F0omC8DRZkGoBKZIQznjvF2g7F2Tju3BE2ZoAbc1Fo0B84PuerAtOEMbWdp5cn8hxvpGm0m0nWo4RhqZljirbd/4+tfeai8j3gw0p/e9SHX7vyOmjyrUTUsNhdKlW+jpj+EmKpDr2Q2EGMab3HGECs1mL6vgEsnSQeAqRBiNRkiBmsT8gccrmgCTEMqkFQTDRXVEJ3SxKBqCXXMk0U3UC3p9XpX7/ziny88pgUA3PC/X3V96C18JtaUMosuUK+6Ahvk75DOCHrV8VltAenndHZQhEjXp8OV2cIzV6Zzh34IlFUQjeggtdWnzQPitSI9nAjWpiMyZ9PhSG4NTZvODtqZpZ07OrljqJERYrz35mt/9PePJOujzgh19+x4p2u2z9G80Vk8dEgaqfN1/XOstBO1IjnVYEWxUQbWYyXScBHNh9C8jeQ5tpmTNYU8g2YOuYVM0qbso2hnrkg8YKeRUQKlQhHS1S8h99AsoVEGukVJmOuGPdPZW3/8kdc9+AiP++mDkqe95zN/0hqd/MPMShUIUzmbTE8HWqmZ3KXTGs6mwYjMyUArnUbGjus/j5vfRrvVpJXVQxFLByLMYNjB1IefCPMLPU45/Rx+9dTTmZnv8s//7yoWZnej1hJjshpfZY1UZQbUdbh/v932sfe89xKYv1lV73/cFgCwZ/ON71154q+dY5qdJyEpH9ZpSavhCFQHR9/1AalB8REyp+ANFqF0ju27urTu/gBvOn9HKq7ioI5ZpK+XbqB6IxncdRd88xrPGaefwT337uGB77+Zl55douUSbdav1UFsv4TZBVZd+CH+/5330z33DPmnL3yHN6nqIBX+VABu/4cr5k96+9++yqxa93XN8uG6wPQh1fZoOoaKJBY2ETJpQsxZQYIiGimMkAel2ytYPdpg3VEMhqUetpTUBCz9Ww4tCzf9oDpjLDwrV3TYcPg09Jbcl3EAV5E0hMXCmY7Wb57Jy/78YxwuImer6jQ8ShBcum644hU39vbtvsR7jx8MQdQNSNWOajUwUdX4RUyNUVnX/NXPgcj8XJe57TCzE/bvSNf0dti3Pb3O7gEtKoDqq0zaLcs+kNwsRoFyyT0RpnfBHZvhztvgnjuBogJiHpiBFSvhoudw6nGHcXEt3+MalLzushf946lXfHpNY3TyfWrdgHgcFCsxojGmTFGNsJWkztGgOE1ZotMSfth9Ohf+1X3keT4YcrBGyJwhyjD7t13PB954H8smK8EEaMD1t8Ga9Sc88gYFyOBPPznFbvt8brvj5s3bb/3Wtb9+ip522cUctWZF9awFOHwDHL+Jc0Xkvar6OCdFgWvffsGVp17x6U5jdOKPjXWLZ/AhpJ+14ttCRIOAc3hsapJCwHqDc45DzroE4z1jzZzRdlXHt3KGOyv43lc/zvOO/xKTy5LWAWjDN74Bm4u38fJzL6h++Qi+U0DeWcuxT734mmt+8vcX33X/N++/836O2zDFv176aiapWUgLIx1aCTLKxx6UPBCEy3vTey4NRYHWpy5K4tyiT3RZxcHH4AkVa5xqhUAUQ2t0lBVTq1h+0EpWTq1i6uDVHLzpGO74wZd49sp3cNZTFpBa+CH49n/A17dfygsvejOjI41BQyaPsL9t2+665w3nHXnmnV9471ZV7QFxfJjmATcrzC4MHOfxW0C9rnvHb1/5q5f/445sePyDxuXDaFy0hpisQUya6tQ6LUUoveJtNVFSEyKqxHycb33x45xSvpanP6NYDGoduP5a+NJPXseLXvEWlk22CUGJ2UO7gGplMJbtssdvkHePj9N0lvE//wOeccGz6QxiQQfu2gLXb+bbWm365/6XmRPfdNXJzcmVHzB542RJwiuKaEwdYRprTVOdeeZoOkOnqtVHmhnj7YyJ8VVs+c6/8vTwSs57Vj8JX230BzfAx295NS945bs4eM3IYI5oqJ3zn9+/i5s/cxKvfeE+6FcbMtDrwc694CyMDUFnlDoTQBt6++HN72frX3yS56jqlupjP9+68U8vvn7ndV85s5zdd3ko+vOqCUytD+arRK+VG9SzRAMCMx/l5m99idOK13LeWUuEH4If3gQfvfllnP2Sy1i1cqgqbuKg/bWmLo6XrADNUVi3CaamoNMiZQFg5x7iV66h98rLuO4vPsmrauF/IQAAtn72r+euu+zFf7yw677T/MLsp6IvA6goEEOoXKLOEKlniqqQj7D5uu9yevf1XPDs2RTwItCB2zfDVde+kKde8EesWTNK30d8XOyN54rIj+/be2u3O7v/AAxyuPH7xC99GfoLpBCnQAO+eh288A/48Se+zMtU9RtLZfiFAKjXTf/n9bdcd9mLXtDbs+Npvjv3d9GXe1NgTBVNPWYbo6L5CFtuvIFfL36XC8/bl7QUgCHYehu8/9+ex8nn/zEHTY3iq9Ta9yoPzhf9zQ/s+9pXtux94cvPe+n5xLI/2EBlEO/7GHec/QYueeOV3NzvkyLcArz0uZgff44T/se5/NFD9/4zB8Gftr5/5Wu/DXz7V15/5cH56LJzTN44x8bwZJuzLEZHbAxx1y236G/L7/GK39ot+Er4Dtz/E8P7v/F8Tnz+u9h0+FRqdII+uKsXt+wv4hc3z7U/9/YnjfwY4MXcusaYh+zdw9gwM6p6lYhsPf4wPn/JRXSYA3qw+iC49EJedNxGuemWO/R9vxQA6nXzB/7gXuCDwAePe+171reWH/TkODx+9Nbbt5z10vblp77+JQ8wEL4BW7dKfOWfHVWMn3Je6bbeuec7N/7g9r0P7tv879/50Q297171Q+jvBvJ3wGpV3f5T9p3oG9WvHb5ePvbs03nNuvWkQDkPRx4LLz+PN4vIx6vn/HIAWLpu+eBb7iENJX36orPkmEv/hNQ1hcV7+l30+SffGkZavxPCNoaJPMk2OP4FZ3GRPouGgnM52ae+zK3AsXDAYPrSNYgKW37CX/3Dv3LBO17P4nBkAc97BpMf/xJvoJoa/aUDMNiZiHvdCzjYOg7cfh+OPkLt0ceFzqOKBTAEm+9grHr3mLlbVTevmJCrzn8abz/6aFKW6cPaDXDxb/E6EblKVe95QoLg41xpcr4BtIBmdbVI7EfdAf60SxaDdubIBs9ppctZDvgPkd37+PDffJ67MYv3YODFZzP03Kfy+/DfaAGAfv827n3Ph1llHf6xdXjgMjnuuz/g7oqXDF/7Hnf2PMvVE6rhSHfTFu5dOgGmqvcOteXK3PG2FZOE6h/OyBtIt88pzsmRT/h/jz/aEhEL/CqwFnjEAYnHWBZ4EPgGkAO/Boyx6FAO2AZ8V1UHEUZEVgBncGDKF5JT3PJfME35hYUZlFEAAAAASUVORK5CYII=" alt="Download" width="64" height="64" /></td>
                                            <td height="70" align="center" class="texto_padrao"><img src="data:image/png;base64,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" alt="Download" width="64" height="64" /></td>
                                            <td height="70" align="center" class="texto_padrao"><img src="data:image/png;base64,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" alt="Download" width="64" height="64" /></td>
                                          </tr>
                                          <tr>
                                            <td height="70" align="center" class="texto_padrao">Opticodec PC SE<br />
                                              <span class="texto_padrao_pequeno">Windows 7/8</span><br />
                                              <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/Opticodec-PC-SE-win7-8.rar" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                            <td height="70" align="center" class="texto_padrao">Zara Radio Portable<br />
                                              <span class="texto_padrao_pequeno">Windows XP/7/8</span><br />
                                              <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/ZaraRadio-1.6.2-portable.exe" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                            <td height="70" align="center" class="texto_padrao">FileZilla FTP<br />
                                              <span class="texto_padrao_pequeno">Windows XP/7/8</span><br />
                                              <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/FileZilla-3.10.3.exe" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                            <td height="70" align="center" class="texto_padrao">Winamp<br />
                                              <span class="texto_padrao_pequeno">Windows XP/7/8</span><br />
                                          <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/winamp.exe" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                          </tr>
                                          <tr>
                                            <td height="20" colspan="4" align="center" class="texto_padrao">&nbsp;</td>
                                            </tr>
                                          <tr>
                                            <td align="center" class="texto_padrao"><img src="data:image/png;base64,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" alt="Download" width="64" height="64" /></td>
                                            <td align="center" class="texto_padrao"><img src="data:image/png;base64,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" alt="Download" width="64" height="64" /></td>
                                            <td height="70" align="center" class="texto_padrao">&nbsp;</td>
                                            <td height="70" align="center" class="texto_padrao">&nbsp;</td>
                                          </tr>
                                          <tr>
                                            <td align="center" class="texto_padrao">ShoutCast DSP Plugin<br />
                                              <span class="texto_padrao_pequeno">Windows XP/7/8</span><br />
                                          <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/plugin-dsp.exe" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                            <td align="center" class="texto_padrao">Radio Caster<br />
                                              <span class="texto_padrao_pequeno">Windows XP/7/8/10</span><br />
                                          <a href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/dlp/RadioCaster.rar" target="_blank" class="texto_padrao_verde">[download]</a></td>
                                            <td height="70" align="center" class="texto_padrao">&nbsp;</td>
                                            <td height="70" align="center" class="texto_padrao">&nbsp;</td>
                                            <td height="70" align="center" class="texto_padrao">&nbsp;</td>
                                          </tr>
                                        </table>
								</div>
							</div>
						</div>
						<!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo $lang['lang_info_config_painel_idioma']; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<script src="/inc/js/theme.js"></script>
		<script src="/inc/theme-<?php echo $dados_stm["layout_painel"]; ?>.js"></script>
	  	<script>
	  	status_streaming('<?php echo $porta_code; ?>');
	  	setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
	  	</script>
	</body>
</html>