<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;


/////////////////////////////////////////////////
/////////////////// Idioma //////////////////////
/////////////////////////////////////////////////
if($dados_stm["idioma_painel"] == "pt-br") {
$lang[ 'lang_info_gerenciador_agendamentos_aba_antigo' ] = 'Listar Agendamentos' ;
$lang[ 'lang_info_gerenciador_agendamentos_aba_calendario' ] = 'Calendário' ;
$lang[ 'lang_info_gerenciador_agendamentos_aba_editar_agendamento' ] = 'Atualizar Agendamento' ;
$lang[ 'lang_info_gerenciador_agendamentos_misturar_musicas_sim' ] = 'Misturar Musicas: Sim' ;
$lang[ 'lang_info_gerenciador_agendamentos_misturar_musicas_nao' ] = 'Misturar Musicas: N&atilde;o' ;
$lang[ 'lang_info_gerenciador_agendamentos_finalizacao' ] = 'Finaliza&ccedil;ao' ;
$lang[ 'lang_info_gerenciador_agendamentos_selecione_playlist' ] = 'Selecione uma playlist' ;
$lang[ 'lang_acao_gerenciador_agendamentos_editar_resultado_ok' ] = 'Agendamento atualizado com sucesso.' ;
} else if($dados_stm["idioma_painel"] == "en") {
$lang[ 'lang_info_gerenciador_agendamentos_aba_antigo' ] = 'List Schedules' ;
$lang[ 'lang_info_gerenciador_agendamentos_aba_calendario' ] = 'Calendar' ;
$lang[ 'lang_info_gerenciador_agendamentos_aba_editar_agendamento' ] = 'Update Agendamento' ;
$lang[ 'lang_info_gerenciador_agendamentos_misturar_musicas_sim' ] = 'Shuffle Songs: Yes' ;
$lang[ 'lang_info_gerenciador_agendamentos_misturar_musicas_nao' ] = 'Shuffle Songs: No' ;
$lang[ 'lang_info_gerenciador_agendamentos_finalizacao' ] = 'Finishing' ;
$lang[ 'lang_info_gerenciador_agendamentos_selecione_playlist' ] = 'Select a playlist' ;
$lang[ 'lang_acao_gerenciador_agendamentos_editar_resultado_ok' ] = 'Schedules has been updated.' ;
} else {
$lang[ 'lang_info_gerenciador_agendamentos_aba_antigo' ] = 'Listar Programaccion' ;
$lang[ 'lang_info_gerenciador_agendamentos_aba_calendario' ] = 'Calendario' ;
$lang[ 'lang_info_gerenciador_agendamentos_aba_editar_agendamento' ] = 'Actualizar Programaccion' ;
$lang[ 'lang_info_gerenciador_agendamentos_misturar_musicas_sim' ] = 'Misturar Musicas: Si' ;
$lang[ 'lang_info_gerenciador_agendamentos_misturar_musicas_nao' ] = 'Misturar Musicas: No' ;
$lang[ 'lang_info_gerenciador_agendamentos_finalizacao' ] = 'Finalizaci&oacute;n' ;
$lang[ 'lang_info_gerenciador_agendamentos_selecione_playlist' ] = 'Selecciona una playlist' ;
$lang[ 'lang_acao_gerenciador_agendamentos_editar_resultado_ok' ] = 'Agendamento actualizado con exito.' ;
}

if($_POST["editar"]) {

list($hora,$minuto) = explode(":",$_POST["hora"]);
list($ano,$mes,$dia) = explode("-",$_POST["data"]);
$data_execussao = $ano."-".$mes."-".$dia;

if(count($_POST["dias"]) > 0){
  $dias = implode(",",$_POST["dias"]);
}

mysqli_query($conexao,"Update playlists_agendamentos set codigo_playlist = '".$_POST["codigo_playlist"]."', frequencia = '".$_POST["frequencia"]."', data = '".$data_execussao."', hora = '".$hora."', minuto = '".$minuto."', dias = '".$dias."', finalizacao = '".$_POST["finalizacao"]."', codigo_playlist_finalizacao = '".$_POST["codigo_playlist_finalizacao"]."', misturar_musicas = '".$_POST["misturar_musicas"]."', inicio = '".$_POST["inicio"]."' where codigo = '".$_POST["codigo_agendamento"]."'") or die(mysqli_error($conexao));

// Cria o sessão do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_acao_gerenciador_agendamentos_editar_resultado_ok'].'</div>';

header("Location: /gerenciar-agendamentos-calendario");
exit();
}

if($_POST["cadastrar"]) {

$dados_playlist = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$_POST["codigo_playlist"]."'"));

list($hora,$minuto) = explode(":",$_POST["hora"]);
list($ano,$mes,$dia) = explode("-",$_POST["data"]);
$data_execussao = $ano."-".$mes."-".$dia;

if(@count($_POST["dias"]) > 0){
    $dias = implode(",",$_POST["dias"]);
}

mysqli_query($conexao,"INSERT INTO playlists_agendamentos (codigo_stm,codigo_playlist,frequencia,data,hora,minuto,dias,inicio,finalizacao,codigo_playlist_finalizacao,misturar_musicas) VALUES ('".$dados_stm["codigo"]."','".$_POST["codigo_playlist"]."','".$_POST["frequencia"]."','".$data_execussao."','".sprintf("%02d",$hora)."','".sprintf("%02d",$minuto)."','".$dias.",','".$_POST["inicio"]."','".$_POST["finalizacao"]."','".$_POST["codigo_playlist_finalizacao"]."','".$_POST["misturar_musicas"]."')");

// Cria o sessão do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_acao_gerenciador_agendamentos_resultado_ok'].'</div>';

header("Location: /gerenciar-agendamentos-calendario");
exit();
}

if($_POST["remover_logs"]) {
mysqli_query($conexao,"Delete From playlists_agendamentos_logs Where codigo_stm = '".$dados_stm["codigo"]."'");

// Cria o sessão do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_acao_gerenciador_agendamentos_resultado_remover_logs'].'</div>';

header("Location: /gerenciar-agendamentos-calendario");
exit();
}


if(query_string('1') == "carregar") {

header('Content-Type: application/json; charset=ISO-8859-1');

$lista_agendamentos = '[';

$sql = mysqli_query($conexao,"SELECT * FROM playlists_agendamentos where codigo_stm = '".$dados_stm["codigo"]."' ORDER by data");
while ($dados_agendamento = mysqli_fetch_array($sql)) {

$dados_playlist = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$dados_agendamento["codigo_playlist"]."'"));
$dados_playlist_finalizacao = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$dados_agendamento["codigo_playlist_finalizacao"]."'"));
$duracao_playlist = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

$misturar = ($dados_agendamento["misturar_musicas"] == "sim") ? $lang[ 'lang_info_gerenciador_agendamentos_misturar_musicas_sim' ] : $lang[ 'lang_info_gerenciador_agendamentos_misturar_musicas_nao' ];

$finalizacao = ($dados_agendamento["codigo_playlist_finalizacao"] > 0 && $dados_agendamento["finalizacao"] == "iniciar_playlist") ? $lang[ 'lang_info_gerenciador_agendamentos_finalizacao' ].": ".$dados_playlist_finalizacao["nome"] : $lang[ 'lang_info_gerenciador_agendamentos_finalizacao' ].": Loop/Repetir";

$duracao = $lang[ 'lang_info_gerenciador_playlists_lista_tabela_duracao' ].": ".sprintf('%02d:%02d:%02d', ($duracao_playlist["total"]/3600),($duracao_playlist["total"]/60%60), $duracao_playlist["total"]%60);

if($dados_agendamento["frequencia"] == "1") {

list($ano,$mes,$dia) = explode("-",$dados_agendamento["data"]);
$data = $dia."/".$mes."/".$ano;

$descricao = $lang['lang_info_gerenciador_agendamentos_info_frequencia1']." ".$data." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."<br>".$misturar."<br>".$finalizacao."<br>".$duracao;

$lista_agendamentos .= '{"id": "'.$dados_agendamento["codigo"].'", "title": "'.$dados_playlist["nome"].'", "className": "bg-dark", "start": "'.$dados_agendamento["data"].' '.$dados_agendamento["hora"].':'.$dados_agendamento["minuto"].'", "end": "'.date("Y-m-d H:i", (strtotime(date($dados_agendamento["data"].' '.$dados_agendamento["hora"].':'.$dados_agendamento["minuto"])) + $duracao_playlist["total"])).'", "description": "'.$descricao.'"},';

} elseif($dados_agendamento["frequencia"] == "2") {

$period = new DatePeriod(
     new DateTime($_GET['start']),
     new DateInterval('P1D'),
     new DateTime($_GET['end'].' +1 day')
);

foreach ($period as $p_key => $p_val) {

$descricao = "".$lang['lang_info_gerenciador_agendamentos_info_frequencia2']." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."<br>".$misturar."<br>".$finalizacao."<br>".$duracao;

$lista_agendamentos .= '{"id": "'.$dados_agendamento["codigo"].'", "title": "'.$dados_playlist["nome"].'", "className": "bg-info", "start": "'.$p_val->format('Y-m-d').' '.$dados_agendamento["hora"].':'.$dados_agendamento["minuto"].'", "end": "'.date("Y-m-d H:i", (strtotime(date($p_val->format('Y-m-d').' '.$dados_agendamento["hora"].':'.$dados_agendamento["minuto"])) + $duracao_playlist["total"])).'", "description": "'.$descricao.'"},';
}

} else {

$array_dias_semana = explode(",",$dados_agendamento["dias"]);

$period = new DatePeriod(
     new DateTime($_GET['start']),
     new DateInterval('P1D'),
     new DateTime($_GET['end'].' +1 day')
);

foreach ($period as $p_key => $p_val) {

$dia_semana = date('N', strtotime($p_val->format('Y-m-d')));

if (in_array($dia_semana, $array_dias_semana)) { 

if($dia_semana == "1") {
$dia_nome = $lang['lang_label_segunda'];
} elseif($dia_semana == "2") {
$dia_nome = $lang['lang_label_terca'];
} elseif($dia_semana == "3") {
$dia_nome = $lang['lang_label_quarta'];
} elseif($dia_semana == "4") {
$dia_nome = $lang['lang_label_quinta'];
} elseif($dia_semana == "5") {
$dia_nome = $lang['lang_label_sexta'];
} elseif($dia_semana == "6") {
$dia_nome = $lang['lang_label_sabado'];
} elseif($dia_semana == "7") {
$dia_nome = $lang['lang_label_domingo'];
} else {
$dia_nome = "";
}

$descricao = $lang['lang_info_gerenciador_agendamentos_info_frequencia3']." ".$dia_nome." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."<br>".$misturar."<br>".$finalizacao."<br>".$duracao;

$lista_agendamentos .= '{"id": "'.$dados_agendamento["codigo"].'", "title": "'.$dados_playlist["nome"].'", "className": "bg-secondary", "start": "'.$p_val->format('Y-m-d').' '.$dados_agendamento["hora"].':'.$dados_agendamento["minuto"].'", "end": "'.date("Y-m-d H:i", (strtotime(date($p_val->format('Y-m-d').' '.$dados_agendamento["hora"].':'.$dados_agendamento["minuto"])) + $duracao_playlist["total"])).'", "description": "'.$descricao.'"},';

}

}

}

unset($lista_dias);
}

$lista_agendamentos = rtrim($lista_agendamentos, ',');

echo $lista_agendamentos.']';

exit();

}

if(query_string('1') == "editar-agendamento") {

$codigo = query_string('2');
    
$dados_agendamento = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists_agendamentos where codigo = '".$codigo."'"));

echo $dados_agendamento["codigo_playlist"]."|".$dados_agendamento["frequencia"]."|".$dados_agendamento["data"]."|".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."|".$dados_agendamento["dias"]."|".$dados_agendamento["inicio"]."|".$dados_agendamento["finalizacao"]."|".$dados_agendamento["codigo_playlist_finalizacao"]."|".$dados_agendamento["misturar_musicas"];
    
exit();
}

if(query_string('1') == "remover") {

$codigo = query_string('2');
    
$dados_agendamento = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists_agendamentos where codigo = '".$codigo."'"));

mysqli_query($conexao,"Delete From playlists_agendamentos where codigo = '".$dados_agendamento["codigo"]."'");
    
// Cria o sessão do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_info_remover_agendamento_resultado_ok'].'</div>';

header("Location: /gerenciar-agendamentos-calendario");
    
exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["porta"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <link rel="stylesheet" href="/inc/theme.css">
  <link rel="stylesheet" href="/inc/fullcalendar.css">  
  <link rel="stylesheet" href="/inc/custom-fullcalendar.advance.css">  
  <link rel="stylesheet" href="/inc/custom-flatpickr.css">  
  <link rel="stylesheet" href="/inc/theme-checkbox-radio.css">  
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> Streaming</a>
              <?php if($dados_stm["autodj"] == "sim") { ?>
              <div class="dropdown-divider"></div>              
              <a class="dropdown-item text-success" href="javascript:carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> AutoDJ</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> AutoDJ</a>
              <?php } ?>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_streaming($conexao,$dados_stm["porta"],$dados_servidor["codigo"]); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $porta_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>

      <div class="modal fade" id="modal_cadastrar" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_gerenciador_agendamentos_aba_cadastrar_agendamento']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-block">
                <form method="post" action="/gerenciar-agendamentos-calendario" name="agendamentos">
                  <table width="95%" border="0" align="center" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="160" height="50" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></td>
                                            <td align="left">
                                            <select name="codigo_playlist" id="codigo_playlist" class="form-control" style="width:100%;">
                                            <?php
                                            $query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
                                            while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
                                        
                                            $total_musicas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));
                                            $duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

                                            if($total_musicas > 0) {
                                            echo '<option value="'.$dados_playlist["codigo"].'">'.$dados_playlist["nome"].' ('.gmdate("H:i:s", $duracao["total"]).')</option>';
                                            } else {
                                            echo '<option value="'.$dados_playlist["codigo"].'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_musicas'].')</option>';
                                            }
                                            }
                                            ?>
                                            </select>        </td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencias']; ?></td>
                                            <td align="left">
                                            <select name="frequencia" id="frequencia" class="form-control" style="width:100%;" onchange="valida_opcoes_frequencia_agendamento(this.value);">
                                              <option value="1" selected="selected"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia1']; ?></option>
                                              <option value="2"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia2']; ?></option>
                                              <option value="3"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia3']; ?></option>
                                            </select>
                                            </td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_data_inicio']; ?></td>
                                            <td align="left"><input class="form-control" id="data" name="data" type="date" style="height: 36px;"></td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_horario_inicio']; ?></td>
                                            <td align="left"><input class="form-control" id="hora" name="hora" type="time" style="height:36px;"></td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_dias_especificos']; ?></td>
                                            <td align="left" valign="middle">
                                            <input name="dias[]" type="checkbox" value="1" id="dias" style="vertical-align:middle" /><?php echo $lang['lang_label_segunda']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="2" id="dias" style="vertical-align:middle" /><?php echo $lang['lang_label_terca']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="3" id="dias" style="vertical-align:middle" /><?php echo $lang['lang_label_quarta']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="4" id="dias" style="vertical-align:middle" /><?php echo $lang['lang_label_quinta']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="5" id="dias" style="vertical-align:middle" /><?php echo $lang['lang_label_sexta']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="6" id="dias" style="vertical-align:middle" /><?php echo $lang['lang_label_sabado']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="7" id="dias" style="vertical-align:middle" /><?php echo $lang['lang_label_domingo']; ?></td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_playlists_botao_misturar_musicas']; ?></td>
                                            <td align="left" valign="middle" class="texto_padrao">
                                            <input name="misturar_musicas" type="checkbox" value="sim" id="misturar_musicas" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_sim']; ?></td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_finalizacao']; ?></td>
                                            <td align="left" valign="middle" class="texto_padrao"><input type="radio" name="finalizacao" id="finalizacao" value="repetir" checked="checked" onclick="lista_playlist_finalizacao('nao')" />
                                            &nbsp;Repetir Musicas(loop)
                                              <input type="radio" name="finalizacao" id="finalizacao" value="iniciar_playlist" onclick="lista_playlist_finalizacao('sim')" />&nbsp;Iniciar Outra Playlist</td>
                                          </tr>
                                          <tr id="lista_playlist_finalizacao" style="display:none">
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></td>
                                            <td align="left">
                                            <select name="codigo_playlist_finalizacao" id="codigo_playlist_finalizacao" class="form-control" style="width:100%;">
                                              <option value="0"><?php echo $lang['lang_info_gerenciador_agendamentos_selecione_playlist']; ?></option>
                                            <?php
                                        $query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
                                        while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
                                      
                                        $total_musicas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));
                                        $duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

                                        if($total_musicas > 0) {
                                        echo '<option value="'.$dados_playlist["codigo"].'">'.$dados_playlist["nome"].' ('.gmdate("H:i:s", $duracao["total"]).')</option>';
                                        } else {
                                        echo '<option value="'.$dados_playlist["codigo"].'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_musicas'].')</option>';
                                        }
                                        }
                                            ?>
                                            </select>        </td>
                                          </tr>
                                        </table><input name="cadastrar" type="hidden" id="cadastrar" value="sim" />
                </form>
                </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-info" onClick="document.agendamentos.submit();"><?php echo $lang['lang_botao_titulo_cadastrar']; ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $lang['lang_botao_titulo_fechar']; ?></button>
                  </div>
            </div>
        </div>
      </div>


      <div class="modal fade" id="modal_editar" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_gerenciador_agendamentos_aba_cadastrar_agendamento']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-block">
                                <img id="loading_editar" src="/img/ajax-loader.gif" />
                                <form method="post" action="/gerenciar-agendamentos-calendario" id="editar_agendamento" name="editar_agendamento" style="display:none">
                  <table width="95%" border="0" align="center" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="160" height="50" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></td>
                                            <td align="left">
                                            <select name="codigo_playlist" id="codigo_playlist" class="form-control" style="width:100%;">
                                            <?php
                                            $query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
                                            while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
                                        
                                            $total_musicas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));
                                            $duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

                                            if($total_musicas > 0) {
                                            echo '<option value="'.$dados_playlist["codigo"].'">'.$dados_playlist["nome"].' ('.gmdate("H:i:s", $duracao["total"]).')</option>';
                                            } else {
                                            echo '<option value="'.$dados_playlist["codigo"].'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_musicas'].')</option>';
                                            }
                                            }
                                            ?>
                                            </select>        </td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencias']; ?></td>
                                            <td align="left">
                                            <select name="frequencia" id="frequencia" class="form-control" style="width:100%;" onchange="valida_opcoes_frequencia_agendamento(this.value);">
                                              <option value="1" selected="selected"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia1']; ?></option>
                                              <option value="2"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia2']; ?></option>
                                              <option value="3"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia3']; ?></option>
                                            </select>
                                            </td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_data_inicio']; ?></td>
                                            <td align="left"><input class="form-control" id="data" name="data" type="date" style="height: 36px;"></td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_horario_inicio']; ?></td>
                                            <td align="left"><input class="form-control" id="hora" name="hora" type="time" style="height:36px;"></td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_dias_especificos']; ?></td>
                                            <td align="left" valign="middle">
                                            <input name="dias[]" type="checkbox" value="1" id="dias1" style="vertical-align:middle" /><?php echo $lang['lang_label_segunda']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="2" id="dias2" style="vertical-align:middle" /><?php echo $lang['lang_label_terca']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="3" id="dias3" style="vertical-align:middle" /><?php echo $lang['lang_label_quarta']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="4" id="dias4" style="vertical-align:middle" /><?php echo $lang['lang_label_quinta']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="5" id="dias5" style="vertical-align:middle" /><?php echo $lang['lang_label_sexta']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="6" id="dias6" style="vertical-align:middle" /><?php echo $lang['lang_label_sabado']; ?>&nbsp;
                                            <input name="dias[]" type="checkbox" value="7" id="dias7" style="vertical-align:middle" /><?php echo $lang['lang_label_domingo']; ?></td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_playlists_botao_misturar_musicas']; ?></td>
                                            <td align="left" valign="middle" class="texto_padrao">
                                            <input name="misturar_musicas" type="checkbox" value="sim" id="misturar_musicas" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_sim']; ?></td>
                                          </tr>
                                          <tr>
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_finalizacao']; ?></td>
                                            <td align="left" valign="middle" class="texto_padrao"><input type="radio" name="finalizacao" id="finalizacao" value="repetir" checked="checked" onclick="lista_playlist_finalizacao_editar('nao')" />
                                            &nbsp;Repetir Musicas(loop)
                                              <input type="radio" name="finalizacao" id="finalizacao" value="iniciar_playlist" onclick="lista_playlist_finalizacao_editar('sim')" />&nbsp;Iniciar Outra Playlist</td>
                                          </tr>
                                          <tr id="lista_playlist_finalizacao_editar" style="display:none">
                                            <td height="40" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></td>
                                            <td align="left">
                                            <select name="codigo_playlist_finalizacao" id="codigo_playlist_finalizacao" class="form-control" style="width:100%;">
                                              <option value="0"><?php echo $lang['lang_info_gerenciador_agendamentos_selecione_playlist']; ?></option>
                                            <?php
                                        $query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
                                        while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
                                      
                                        $total_musicas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));
                                        $duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

                                        if($total_musicas > 0) {
                                        echo '<option value="'.$dados_playlist["codigo"].'">'.$dados_playlist["nome"].' ('.gmdate("H:i:s", $duracao["total"]).')</option>';
                                        } else {
                                        echo '<option value="'.$dados_playlist["codigo"].'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_musicas'].')</option>';
                                        }
                                        }
                                            ?>
                                            </select>        </td>
                                          </tr>
                                        </table><input name="editar" type="hidden" id="editar" value="sim" /><input name="codigo_agendamento" type="hidden" id="codigo_agendamento" value="" />
                </form>
                </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-info" onClick="document.editar_agendamento.submit();"><?php echo $lang['lang_botao_titulo_atualizar']; ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $lang['lang_botao_titulo_fechar']; ?></button>
                  </div>
            </div>
        </div>
      </div>

      <div class="modal fade" id="modal_logs" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document" style="width: 700px;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_gerenciador_agendamentos_aba_logs']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-block" style="padding: 5px;">
                <table id="data_table_logs" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info" style="width:100%!important">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_logs_data']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_logs_playlist']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM playlists_agendamentos_logs WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by data DESC LIMIT 100");
while ($dados_log_agendamento = mysqli_fetch_array($sql)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".formatar_data($dados_stm["formato_data"], $dados_log_agendamento["data"], $dados_stm["timezone"])."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_log_agendamento["playlist"]."</td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
                                          </div>
            </div>
        </div>
        </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">   

            <div class="col-md-12">
              <div class="card table-card">
                <div class="card-header">
                  <header><?php echo $lang['lang_info_gerenciador_agendamentos_aba_agendamentos']; ?></header>
                    <div class="card-header-right">
                      <button type="button" class="btn btn-success" onClick="$('#modal_cadastrar').modal('show');"><i class="fa fa-plus-circle"></i> <?php echo $lang['lang_botao_titulo_adicionar']; ?></button>
                      <button type="button" class="btn btn-info" onClick="$('#modal_logs').modal('show');"><i class="fa fa-file-text-o"></i> <?php echo $lang['lang_info_gerenciador_agendamentos_aba_logs']; ?></button>
                      <button type="button" class="btn btn-primary" onClick="window.location = '/gerenciar-agendamentos'"><i class="fa fa-list"></i> <?php echo $lang['lang_info_gerenciador_agendamentos_aba_antigo']; ?></button>
                    </div>
                </div>
                <div class="card-block" style="padding-left:5px;padding-right: 5px;padding-bottom: 5px;">
                  <div class="table-responsive">
                    <div id="calendar"></div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script src="/inc/fullcalendar.min.js"></script>
  <script src="/inc/fullcalendar.<?php echo $dados_stm["idioma_painel"]; ?>.js"></script>
  <script src="/inc/moment.min.js"></script>
  <script src="/inc/flatpickr.js"></script>
  <script>
  status_streaming('<?php echo $porta_code; ?>');
  setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                "order": [],
                "aaSorting": []
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });
function lista_playlist_finalizacao(opcao) {

if(opcao == "sim") {
$('#lista_playlist_finalizacao').show();
} else {
$('#lista_playlist_finalizacao').hide();
}

}
function lista_playlist_finalizacao_editar(opcao) {

if(opcao == "sim") {
$('#lista_playlist_finalizacao_editar').show();
} else {
$('#lista_playlist_finalizacao_editar').hide();
}

}
function remover_agendamento_calendario( codigo ) {

  if(window.confirm("Pt-BR: Deseja realmente remover?\nEn-US: Do you really want to remove?\nES: Realmente quieres eliminar?")) {
    window.location='/gerenciar-agendamentos-calendario/remover/'+codigo;
  }
}

// Função para carregar dados do agendamento a editar
function editar_agendamento_calendario( codigo ) {
  
  $('.popover').popover('hide');
  $('#loading_editar').show();
  $('#editar_agendamento').hide();
  $("#modal_editar").modal('show');

  $('#editar_agendamento select[name="codigo_playlist"] option').removeAttr("selected");
  $('#editar_agendamento select[name="frequencia"] option').removeAttr("selected");
  $('#editar_agendamento select[name="codigo_playlist_finalizacao"] option').removeAttr("selected");
  $('#editar_agendamento input[name="data"]').val();
  $('#editar_agendamento input[name="hora"]').val();

  $('#editar_agendamento input[name="inicio"]').attr("checked", false);
  $('#editar_agendamento input[name="misturar_musicas"]').attr("prop", false);
  $('#editar_agendamento input[name="finalizacao"]').attr("checked", false);

  $('#editar_agendamento input[name="codigo_agendamento"]').val(codigo);

  $('#editar_agendamento .switchery').remove();
  $('#editar_agendamento input:checkbox').prop("checked", false);
  $('#editar_agendamento input:checkbox').css('display', '');
  $('#editar_agendamento input:checkbox').removeAttr('data-switchery');
  
  var http = new Ajax();
  http.open("GET", "/gerenciar-agendamentos-calendario/editar-agendamento/"+codigo , true);
  http.onreadystatechange = function() {
    
  if(http.readyState == 4) {
      
    dados = http.responseText.split("|");

    var dias = dados[4].split(",");
    
    $('#editar_agendamento select[name="codigo_playlist"] option[value="'+dados[0]+'"]').attr("selected", "selected");
    $('#editar_agendamento select[name="frequencia"] option[value="'+dados[1]+'"]').attr("selected", "selected");
    $('#editar_agendamento input[name="data"]').val(dados[2]);
    $('#editar_agendamento input[name="hora"]').val(dados[3]);

    for (var i = 0; i < dias.length; i++) {
      $('#editar_agendamento input[id="dias'+dias[i]+'"]').trigger('click'); 
    }

    $('#editar_agendamento input[name="inicio"][value="'+dados[5]+'"]').attr("checked", "checked");

    if(dados[8] == "sim") {
      $('#editar_agendamento input[name="misturar_musicas"]').trigger('click'); 
    }

    $('#editar_agendamento input[name="finalizacao"][value="'+dados[6]+'"]').attr("checked", "checked");

    if(dados[6] == "iniciar_playlist") {
    $('#lista_playlist_finalizacao_editar').show();
    $('#editar_agendamento select[name="codigo_playlist_finalizacao"] option[value="'+dados[7]+'"]').attr("selected", "selected"); 
    } else {
    $('#lista_playlist_finalizacao_editar').hide();
    }

    $('#loading_editar').hide();
    $('#editar_agendamento').show();

    $("#editar_agendamento input:checkbox").each(function() {
    var switchery = new Switchery(this, {
                color: '#0ddbb9',
                jackColor: '#fff',
                size: 'small'
            });
    }); 

  }
  
  }
  http.send(null);
  delete http;
}

//Calendario
$(document).ready(function() {

    var calendar = $('#calendar').fullCalendar({
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay'
        },
        locale: '<?php echo $dados_stm["idioma_painel"]; ?>',
        events: '/gerenciar-agendamentos-calendario/carregar',
        editable: true,
        eventLimit: true,
        displayEventTime: false,
        eventStartEditable: false,
        eventDurationEditable: false,
        eventMouseover: function(event, jsEvent, view) {
        },
        eventMouseout: function(event, jsEvent, view) {},
        eventClick: function(event, jsEvent, view) {
            $('.popover').remove();
            $(this).attr('id', event.id);
            $('#'+event.id).popover({
                template: '<div class="popover popover-primary" role="tooltip"><div class="arrow"></div><h3 id="ppo_'+event.id+'" class="popover-header"></h3><div class="popover-body"></div></div>',
                html: true,
                title: event.title,
                content: event.description,
                placement: 'top',
            });

            $('#'+event.id).popover('show');
            $('#ppo_'+event.id).append('<button type="button" class="btn btn-sm btn-light btn-popover-close" onclick="$(\'.popover\').popover(\'hide\')"><i class="fa fa-times-circle-o"></i></button><button type="button" class="btn btn-sm btn-danger btn-popover-close" onclick="remover_agendamento_calendario('+event.id+')"><i class="fa fa-trash-o"></i></button><button type="button" class="btn btn-sm btn-info btn-popover-close" onclick="editar_agendamento_calendario('+event.id+')"><i class="fa fa-pencil"></i></button>');}
    })
    
});
  </script>
</body>
</html>