<?php
ini_set("memory_limit", "1024M");
ini_set("max_execution_time", 3600);
ini_set("date.timezone","America/Sao_Paulo");

require_once("/home/painel/public_html/admin/inc/conecta.php");
require_once("/home/painel/public_html/admin/inc/classe.ftp.php");

$dados_config_bkp = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM configuracoes_backup"));

$log .= "[".date("d/m/Y H:i:s")."] Iniciando robot de backup...\n\n";

if($dados_config_bkp["ftp_servidor"] && $dados_config_bkp["ftp_usuario"] && $dados_config_bkp["ftp_senha"]) {

if($dados_config_bkp["bkp_arquivos"] == "sim") {

	$log .= "[".date("d/m/Y H:i:s")."] Efetuando backup dos arquivos do painel para /home/painel/backup-painel-arquivos-".date("d_m_Y").".tar.gz ...\n";

	// Efetua backup dos arquivos do painel
	shell_exec("cd /home/painel;/usr/bin/tar -zcf /home/painel/backup-painel-arquivos-".date("d_m_Y").".tar.gz public_html/");

	// Verifica se arquivo de backup foi criado
	if(file_exists("/home/painel/backup-painel-arquivos-".date("d_m_Y").".tar.gz")) {
	
		// Verifica se arquivo criado tem minimo de tamanho recomendavel
		if(filesize("/home/painel/backup-painel-arquivos-".date("d_m_Y").".tar.gz") > 5242880) {
			
			$log .= "[".date("d/m/Y H:i:s")."] Backup dos arquivos do painel efetuado com <strong>sucesso</strong>.\n";
			
			// Faz upload para FTP remoto
			$log .= "[".date("d/m/Y H:i:s")."] Iniciando upload do backup para servidor FTP <strong>".$dados_config_bkp["ftp_servidor"]."</strong>\n";
			
			// Conexão FTP
			$ftp = new FTP();
			$ftp->conectar($dados_config_bkp["ftp_servidor"]);
			$ftp->autenticar($dados_config_bkp["ftp_usuario"],$dados_config_bkp["ftp_senha"]);
			
			if($ftp->enviar_arquivo("/home/painel/backup-painel-arquivos-".date("d_m_Y").".tar.gz","backup-painel-arquivos-".date("d_m_Y").".tar.gz")) {
				$log .= "[".date("d/m/Y H:i:s")."] Backup enviado com <strong>sucesso</strong> para FTP remoto.\n";
			} else {
				$log .= "[".date("d/m/Y H:i:s")."] <strong>Falha</strong> ao enviar backup para FTP remoto.\n";
			}
			
			unlink("/home/painel/backup-painel-arquivos-".date("d_m_Y").".tar.gz");
			
		} else {
			$log .= "[".date("d/m/Y H:i:s")."] <strong>Falha</strong> ao efetuar backup dos arquivos do painel, backup com tamanho menor que o aceitável.\n";
		}
	
	} else {
		$log .= "[".date("d/m/Y H:i:s")."] <strong>Falha</strong> ao efetuar backup dos arquivos do painel, o arquivo de backup não foi criado.\n";
	}
	
	$log .= "[".date("d/m/Y H:i:s")."] Processo de backup dos arquivos do painel finalizado.\n\n";
	
}

// Backup MySQL
if($dados_config_bkp["bkp_mysql"] == "sim") {

	$log .= "[".date("d/m/Y H:i:s")."] Efetuando backup do banco de dados para /home/painel/backup-painel-mysql-".date("d_m_Y").".tar.gz ...\n";

	// Lista as tabelas do banco de dados
	$lista_tabelas = array();
	
	if($dados_config_bkp["bkp_mysql_stats"] == "nao") {
	$excluir_tabela_stats = "--ignore-table=".$bd_streaming.".estatisticas";
	}
	
	// Efetua backup do banco de dados
	shell_exec("mysqldump -u ".$user." -p".$pass." ".$bd_streaming." --ignore-table=".$bd_streaming.".geoip ".$excluir_tabela_stats." > /home/painel/backup-painel-mysql-".date("d_m_Y").".sql");
	
	// Cria backup da tabela estatistica porém sem registros
	if($dados_config_bkp["bkp_mysql_stats"] == "nao") {
		$sql_stats .= 'DROP TABLE IF EXISTS `estatisticas`;';
        $row_stats = mysqli_fetch_row(mysqli_query($conexao,"SHOW CREATE TABLE `estatisticas`"));
        $sql_stats .= "\n\n".$row_stats[1].";\n\n";
		
		file_put_contents("/home/painel/backup-painel-mysql-".date("d_m_Y").".sql", $sql_stats, FILE_APPEND);
	}
	
	// Compacta arquivo SQL gerado
	shell_exec("cd /home/painel;/usr/bin/tar -zcf backup-painel-mysql-".date("d_m_Y").".tar.gz backup-painel-mysql-".date("d_m_Y").".sql");
	
	// Verifica se arquivo criado tem minimo de tamanho recomendavel
	if(filesize("/home/painel/backup-painel-mysql-".date("d_m_Y").".tar.gz") > 10240) {
	
		// Faz upload para FTP remoto
		$log .= "[".date("d/m/Y H:i:s")."] Iniciando upload do backup para servidor FTP <strong>".$dados_config_bkp["ftp_servidor"]."</strong>\n";
		
		// Conexão FTP
		$ftp = new FTP();
		$ftp->conectar($dados_config_bkp["ftp_servidor"]);
		$ftp->autenticar($dados_config_bkp["ftp_usuario"],$dados_config_bkp["ftp_senha"]);
		
		if($ftp->enviar_arquivo("/home/painel/backup-painel-mysql-".date("d_m_Y").".tar.gz","backup-painel-mysql-".date("d_m_Y").".tar.gz")) {
			$log .= "[".date("d/m/Y H:i:s")."] Backup MySQL enviado com <strong>sucesso</strong> para FTP remoto.\n";
		} else {
			$log .= "[".date("d/m/Y H:i:s")."] <strong>Falha</strong> ao enviar backup MySQL para FTP remoto.\n";
		}
		
	} else {
		$log .= "[".date("d/m/Y H:i:s")."] <strong>Falha</strong> ao efetuar backup do MySQL, backup com tamanho menor que o aceitável.\n";
	}
	
	@unlink("/home/painel/backup-painel-mysql-".date("d_m_Y").".sql");
	@unlink("/home/painel/backup-painel-mysql-".date("d_m_Y").".tar.gz");
	
	$log .= "[".date("d/m/Y H:i:s")."] Processo de backup do MySQL finalizado.\n\n";
	
}

$log .= "[".date("d/m/Y H:i:s")."] Robot de backup finalizado.\n\n";

} else {
$log .= "[".date("d/m/Y H:i:s")."] Modulo de backup não configurado. Configure os dados do FTP remoto antes de executar  backup...\n\n";
}

mysqli_query($conexao,"Update configuracoes_backup set log = '".$log."'");

echo $log;
?>