#!/bin/sh
# @configurar-ssl-site-adm.sh - Script para configurar SSL para dominio do site adm

# Muda prioridade de execussao
renice -20 $$

count=0

db="/home/painel/public_html/player/sites/lista_dominios_site_adm_configurar_ssl.txt"

sed -i -e 's/\r$//' $db

for dados in `cat $db`;
do

dominio=`echo $dados | cut -d ':' -f 1`
porta=`echo $dados | cut -d ':' -f 2`

sed -i "/${porta}/d" $db

cat <<EOT > /etc/httpd/conf.d/site_adm_$dominio.conf
NameVirtualHost *:80

<VirtualHost *:80>
    DocumentRoot /home/painel/public_html/player/sites/${porta}
    ServerName ${dominio}
    ServerAlias www.${dominio}
</VirtualHost>

EOT

systemctl reload httpd

certbot certonly --webroot --webroot-path /home/painel/public_html/player/sites/${porta} -d ${dominio}

if [ -f "/etc/letsencrypt/live/${dominio}/cert.pem" ]; then

cat <<EOT >> /etc/httpd/conf.d/site_adm_${dominio}.conf

NameVirtualHost *:443

<VirtualHost *:443>
    DocumentRoot /home/painel/public_html/player/sites/${porta}
    ServerName ${dominio}
    ServerAlias www.${dominio}

    SSLEngine on
    SSLProtocol all -SSLv2
    SSLCipherSuite DEFAULT:!EXP:!SSLv2:!DES:!IDEA:!SEED:+3DES
    SSLCertificateFile /etc/letsencrypt/live/${dominio}/cert.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/${dominio}/privkey.pem
    SSLCertificateChainFile /etc/letsencrypt/live/${dominio}/chain.pem

    SetEnvIf User-Agent ".*MSIE.*" \
         nokeepalive ssl-unclean-shutdown \
         downgrade-1.0 force-response-1.0

</VirtualHost>

EOT

count=`expr $count + 1`

echo
echo "[Site Adm] ${porta} ${dominio} configurado com sucesso."
echo

else

rm -f /etc/httpd/conf.d/site_adm_${dominio}.conf

echo
echo "[Site Adm] ${porta} ${dominio} erro ao gerar SSL."
echo

fi

done

if [ "$count" -gt 0 ]; then
systemctl reload httpd
fi
