<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Streaming <?php echo $dados_stm["porta"]; ?></title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/inc/ajax-streaming.js"></script>
		<script type="text/javascript" src="/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_stm["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<?php if($dados_revenda["url_logo"]) { ?>
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } else { ?>
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } ?>
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo $lang['lang_info_streaming_api_tab_titulo']; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/dashboard">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo $lang['lang_info_streaming_api_tab_titulo']; ?></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div class="row">
						<!-- cards -->
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<?php echo $lang['lang_info_streaming_api_info']; ?>
    <br />
    <br />
    <span class="texto_padrao_destaque">API XML:</span><br />
  <input type="text" value="<?php echo "http://".$_SERVER['HTTP_HOST']."/api/".$porta_code.""; ?>" style="width:100%; height:30px"  onclick="this.select()" readonly="readonly" />
<br />
<br />
<textarea readonly="readonly" style="width:100%; height:510px"  onclick="this.select()">
$xml = simplexml_load_file("<?php echo "http://".$_SERVER['HTTP_HOST']."/api/".$porta_code.""; ?>");

echo $xml->status; // Mostra o status da r&aacute;dio
echo "<br>";
echo $xml->porta; // Mostra a porta da r&aacute;dio
echo "<br>";
echo $xml->porta_dj; // Mostra a porta DJ da r&aacute;dio
echo "<br>";
echo $xml->ip; // Mostra o endereço do servidor da r&aacute;dio
echo "<br>";
echo $xml->ouvintes_conectados; // Mostra total de ouvintes conectados
echo "<br>";
echo $xml->titulo; // Mostra o nome da r&aacute;dio
echo "<br>";
echo $xml->plano_ouvintes; // Mostra o limite de ouvintes do plano
echo "<br>";
echo $xml->plano_ftp; // Mostra o limite de espaco do AutoDJ do plano
echo "<br>";
echo $xml->plano_bitrate; // Mostra o bitrate do plano
echo "<br>";
echo $xml->musica_atual; // Mostra a musica atual
echo "<br>";
echo $xml->proxima_musica; // Mostra a pr&oacute;xima musica do AutoDJ(nao é valido para transmissao ao vivo)
echo "<br>";
echo $xml->genero; // Mostra o genero da r&aacute;dio
echo "<br>";
echo $xml->shoutcast; // Mostra a URL do shoutcast
echo "<br>";
echo $xml->rtmp; // Mostra a URl do RTMP para uso em players proprios(se tiver RTMP)
echo "<br>";
echo $xml->rtsp; // Mostra a URl do RTSP para uso em players proprios(se tiver RTMP)
echo "<br>";
echo $xml->capa_musica; // Mostra a URL da imagem JPG da capa do album da musica
</textarea>
<br />
<br />
<span class="texto_padrao_destaque">API Json (jQuery/Javascript):</span><br />
  <input type="text" value="<?php echo "http://".$_SERVER['HTTP_HOST']."/api-json/".$porta_code.""; ?>" style="width:100%; height:30px"  onclick="this.select()" readonly="readonly" />
<br />
<br />
<textarea readonly="readonly" style="width:100%; height:370px"  onclick="this.select()">
<script type="text/javascript">
$.getJSON('<?php echo "http://".$_SERVER['HTTP_HOST']."/api-json/".$porta_code.""; ?>', function(data) {

var status = data.status; // Mostra o status da r&aacute;dio
var porta = data.porta; // Mostra a porta da r&aacute;dio
var porta_dj = data.porta_dj; // Mostra a porta DJ da r&aacute;dio
var ip = data.ip; // Mostra o endereço do servidor da r&aacute;dio
var ouvintes_conectados = data.ouvintes_conectados; // Mostra total de ouvintes conectados
var titulo = data.titulo; // Mostra o nome da r&aacute;dio
var plano_ouvintes = data.plano_ouvintes; // Mostra o limite de ouvintes do plano
var plano_ftp = data.plano_ftp; // Mostra o limite de espaco do AutoDJ do plano
var plano_bitrate = data.plano_bitrate; // Mostra o bitrate do plano
var musica_atual = data.musica_atual; // Mostra a musica atual
var proxima_musica = data.proxima_musica; // Mostra a pr&oacute;xima musica do AutoDJ(nao e valido para transmissao ao vivo)
var genero = data.genero; // Mostra o genero da r&aacute;dio
var shoutcast = data.shoutcast; // Mostra a URL do shoutcast
var rtmp = data.rtmp; // Mostra a URl do RTMP para uso em players proprios(se tiver RTMP)
var rtsp = data.rtsp; // Mostra a URl do RTSP para uso em players proprios(se tiver RTMP)
var capa_musica = data.capa_musica; // Mostra a URL da imagem JPG da capa do album da musica

});
</script>
</textarea>
								</div>
							</div>
						</div>
						<!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo $lang['lang_info_config_painel_idioma']; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<script src="/inc/js/theme.js"></script>
		<script src="/inc/theme-<?php echo $dados_stm["layout_painel"]; ?>.js"></script>
	  	<script>
	  	status_streaming('<?php echo $porta_code; ?>');
	  	setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
	  	</script>
	</body>
</html>