<?php
use WHMCS\Database\Capsule;

function stmadvance_configoptions(){
    
    $configarray = array(
        'Ouvintes' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Numero maximo de ouvintes. Ex.: 100)'
        ),
        'Bitrate' => array(
            'Type' => 'dropdown',
            'Options' => '24,32,48,64,128',
            'Description' => '<br>(Verifique limite de seu plano)'
        ),
        'Espaco AutoDJ' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Espaco para FTP do autodj em megabytes. Zero desativa o autodj)'
        ),
        'AAC+ RTMP' => array(
            'Type' => 'dropdown',
            'Options' => 'sim,nao',
            'Description' => '<br>(Verifique se esta ativado em seu plano)'
        ),
        'Idioma' => array(
            'Type' => 'dropdown',
            'Options' => 'pt-br,en-us,es',
            'Description' => '<br>(Idioma Painel - Portugues/English/Espanol)'
        ),
        'App Android' => array(
            'Type' => 'dropdown',
            'Options' => 'sim,nao',
            'Description' => '<br>(App Android)'
        ),
        'Encoder MP3' => array(
            'Type' => 'yesno',
            'Description' => '(Ativar/desativar uso de MP3)'
        ),
        'Encoder AACPlus' => array(
            'Type' => 'yesno',
            'Description' => '(Ativar/desativar uso de AACPlus)'
        ),
        'Programetes' => array(
            'Type' => 'yesno',
            'Description' => '(Ativar/desativar Programetes)'
        ),
        'Programas' => array(
            'Type' => 'yesno',
            'Description' => '(Ativar/desativar Programas)'
        ),
        'Download P & P' => array(
            'Type' => 'yesno',
            'Description' => '(Ativar/desativar download de conteudo)'
        ),
        'Camera Studio' => array(
            'Type' => 'yesno',
            'Description' => '(Ativar/desativar camera studio)'
        ),
        'Lives' => array(
                'Type' => 'dropdown',
                'Options' => 'sim,nao',
          'Description' => '<br>(Ativar/desativar lives Youtube, Facebook e etc...)'
        )
    );
    
    return $configarray;
    
}

function stmadvance_adminlink($params){
    $code = '<input type="button" value="Acessar Painel" onclick="window.location = \'' . $params['serverhostname'] . '/admin\';">';
    return $code;
}

function stmadvance_createaccount($params){
    
    global $debug;
      
  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "Porta", "relid" => $params['packageid'])
  );
  
  $data = stmadvance_select($parametros);

  if(empty($data)){
    $return = 'O campo adicional "Porta" no existe.<br>Crie um campo adicional com o nome "Porta" em Products/Services';
    return $return;
  }
  
    $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = stmadvance_select($parametros);

    if(empty($data)){
    $parametros = array(
      'table' => 'tblcustomfieldsvalues',
      'insert_array' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'], "value" => '')
    );
    stmadvance_insert($parametros);
    }
  
    $PortBase = $data;

    if (!empty($PortBase)){
    $return = 'Este streaming j esta criado.';
    return $return;
    }
  
  $stmadvance_api['acao'] = 'cadastrar';
  $stmadvance_api['ouvintes'] = $params['configoption1'];
  $stmadvance_api['bitrate'] = $params['configoption2'];
  $stmadvance_api['espaco'] = $params['configoption3'];
  $stmadvance_api['senha'] = substr(md5("acegikmoqsuxywz".time()),0,12);
  $stmadvance_api['aacplus'] = $params['configoption4'];
  $stmadvance_api['idioma'] = $params['configoption5'];
  $stmadvance_api['app_android'] = $params['configoption6'];
  $stmadvance_api['encoder_mp3'] = $params['configoption7'];
  $stmadvance_api['encoder_aacplus'] = $params['configoption8'];
  $stmadvance_api['identificacao']   = urlencode($params['clientsdetails']['firstname']." ".$params['clientsdetails']['lastname']);
  $stmadvance_api['programetes'] = $params['configoption9'];
  $stmadvance_api['programas'] = $params['configoption10'];
  $stmadvance_api['download_pp'] = $params['configoption11'];
  $stmadvance_api['acervo'] = $params['configoption12'];
  $stmadvance_api['camera_studio'] = $params['configoption13'];
  $stmadvance_api['lives'] = $params['configoption14'];
  
    $response = stmadvance_api ($params['serverhostname'],$params['serveraccesshash'],$stmadvance_api);
  
    if ($response['command'] == 'success'){
    
    list ($ip, $porta) = explode (':', $response['returned']);

    $parametros = array(
      'table' => 'tblhosting',
      'condition' => array("id" => $params['accountid']),
      'update_data' => array("username" => $porta, "password" => encrypt ($stmadvance_api['senha']), "dedicatedip" => $ip)
    );
    stmadvance_update($parametros);
      
    $parametros = array(
      'table' => 'tblcustomfields',
      'value' => 'id',
      'condition' => array("fieldname" => "Porta", "relid" => $params['packageid'])
    );
    $data = stmadvance_select($parametros);
    
    $dados_customfield = $data;

    
    $parametros = array(
      'table' => 'tblcustomfieldsvalues',
      'condition' => array("fieldid" => $dados_customfield, "relid" => $params['accountid']),
      'update_data' => array("value" => $porta)
    );
    stmadvance_update($parametros);
    
    return 'success';

    }
    return $response['error'];
}

function stmadvance_suspendaccount ($params){

    global $debug;

  
  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "Porta", "relid" => $params['packageid'])
  );
  
  $data = stmadvance_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = stmadvance_select($parametros);
  
  $PortBase = $data;

  if (empty($PortBase)){
    $return = 'O streaming no esta cadastrado.';
    return $return;
    }

    $stmadvance_api['acao'] = 'bloquear';
    $stmadvance_api['porta'] = $PortBase;

    $response = stmadvance_api ($params['serverhostname'],$params['serveraccesshash'],$stmadvance_api);

    if ($response['command'] == 'success'){

      return 'success';

    }

    return $response['error'];

}

function stmadvance_unsuspendaccount ($params){

    global $debug;

    $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "Porta", "relid" => $params['packageid'])
  );
  
  $data = stmadvance_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = stmadvance_select($parametros);
  
  $PortBase = $data;

  if (empty($PortBase)){
    $return = 'O streaming no esta criado, por favor clique no boto "Create" primeiro.';
    return $return;
    }

    $stmadvance_api['acao'] = 'desbloquear';
    $stmadvance_api['porta'] = $PortBase;

    $response = stmadvance_api ($params['serverhostname'],$params['serveraccesshash'],$stmadvance_api);

    if ($response['command'] == 'success'){
      return 'success';
    }
  
    return $response['error'];

  }

function stmadvance_terminateaccount ($params){

    global $debug;

     $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "Porta", "relid" => $params['packageid'])
  );
  
  $data = stmadvance_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = stmadvance_select($parametros);
  
  $PortBase = $data;

  if (empty($PortBase)){
    $return = 'O streaming no esta criado.';
    return $return;
    }


    $stmadvance_api['acao'] = 'remover';
    $stmadvance_api['porta'] = $PortBase;
  
    $response = stmadvance_api ($params['serverhostname'],$params['serveraccesshash'],$stmadvance_api);

    if ($response['command'] == 'success'){

    $parametros = array(
      'table'=>'tblcustomfieldsvalues',
      'condition'=>array('fieldid'=>$CustomFieldID, 'relid'=>$params['accountid'])
    );
    stmadvance_delete($parametros);
    
    $parametros = array(
      'table' => 'tblhosting',
      'condition' => array("id" => $params['accountid']),
      'update_data' => array("username" => '', "password" => '', "dedicatedip" => '')
    );
    stmadvance_update($parametros);
    
    return 'success';

    }
  
    return $response['error'];

}

function stmadvance_api($serverhostname, $serveraccesshash, $stmadvance_api){

    $requisicao = '';
    
    foreach ($stmadvance_api as $option => $setting) {
        if (is_array($setting)) {
            $setting = serialize($setting);
        }
        $requisicao .= $setting . "/";
    }

    $url_requisicao = "https://" . $serverhostname . "/admin/api/" . $serveraccesshash . "/" . $requisicao . "";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url_requisicao);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Modulo Streaming AdvanceHost WHMCS 2.4 (' . $_SERVER['HTTP_HOST'] . ')');
    $resultado = curl_exec($ch);
    curl_close($ch);
    

    if ($resultado === false) {
        return array(
            'command' => 'failed',
            'error' => 'No foi possvel se conectar ao painel de controle. Debug: ' . $url_requisicao . ''
        );
    } else {
        list($status, $porta, $msg) = explode('|', $resultado);
        if ($status == '0') {
            return array(
                'command' => 'failed',
                'error' => '' . $msg . ''
            );
        }

        return array(
            'command' => 'success',
            'returned' => '' . $porta . ''
        );
    }
}

function stmadvance_select($parametros){
  
  $table = $parametros['table'];
  $value = $parametros['value'];
  $condition = $parametros['condition'];
  
  try {
    if(!empty($condition) && !empty($value)){
      $data = Capsule::table($table)
            ->where($condition)
            ->value($value);
            return $data;
    }else if(!empty($condition)){
      $data = Capsule::table($table)
            ->where($condition)
            ->get();
            return $data;
    }else if(!empty($value)){
      $data = Capsule::table($table)
            ->value($value);
            return $data;
    }else if(empty($condition) && empty($value)){
      $data = Capsule::table($table)
            ->get();
          return $data;
    }else{
      return "Erro na sintaxe da consulta";
    } 
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function stmadvance_insert($parametros){
  
  $table = $parametros['table'];
  $insert_array = $parametros['insert_array'];
  
  try {
    Capsule::table($table)
      ->insert($insert_array);
    return true;
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function stmadvance_update($parametros){
  
  $table = $parametros['table'];
  $condition = $parametros['condition'];
  $update_data = $parametros['update_data'];
  
  try {
    Capsule::table($table)
       ->where($condition)
       ->update($update_data);
    return true;   
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function stmadvance_delete($parametros){
  
  $table = $parametros['table'];
  $condition = $parametros['condition'];
  
  try {
    Capsule::table($table)
      ->where($condition)
      ->delete();
      return true;
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
?>