<?php

// Função para checar status do autodj
function status_relay_icecast($ip,$porta,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin.cgi?sid=1&mode=viewxml&pass=".$senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

if(preg_match('/http/i',$xml->STREAMSOURCE)) {
return "ligado";
} else {
return "desligado";
}

}

// Função para checar status do autodj com IceCast
function status_streaming_transmissao_icecast($ip,$porta,$senha) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/stats");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);

if(curl_error($ch)) {
    return "off";
} else {

    $resultado = xml_entity_decode($resultado);

    $xml = @simplexml_load_string(utf8_encode($resultado));

    if($xml->sources > 0) {

        if(filter_var($xml->source->source_ip, FILTER_VALIDATE_IP) && $xml->source->source_ip == "127.0.0.1") {
            return "autodj";
        } elseif($xml->source_relay_connections > 0) {
            return "relay";
        } elseif(filter_var($xml->source->source_ip, FILTER_VALIDATE_IP) && $xml->source->source_ip != "127.0.0.1") {
            return "aovivo";
        } else {
            return "off";  
        }

    } else {
        return "off";
    }
}
curl_close($ch);
}

// Função para checar status do autodj com IceCast
function status_autodj_icecast($ip,$porta,$senha) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/stats");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

if(curl_error($ch)) {
    return "desligado";
} else {

    $resultado = xml_entity_decode($resultado);

    $xml = @simplexml_load_string(utf8_encode($resultado));

    if($xml->source_client_connections > 0) {

        if(filter_var($xml->source->source_ip, FILTER_VALIDATE_IP) && $xml->source->source_ip == "127.0.0.1") {
            return "ligado";
        } else {
            return "desligado";  
        }

    } else {
        return "desligado";
    }
}
curl_close($ch);
}

// Função para obter as estatisticas do streaming para robots icecast
function estatistica_streaming_icecast_robot($ip,$porta,$senha,$ponto) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/listclients?mount=".$ponto."");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado) {

$resultado = str_replace("&#x","",$resultado);

return $resultado;
}

}

function estatistica_ouvintes_conectados_icecast($ip,$porta,$senha,$ponto) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/listclients?mount=".$ponto."");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

if($xml->source->Listeners > 0) {

    for($i=0;$i<$xml->source->Listeners;$i++){

        $ip = $xml->source->listener[$i]->IP;
        $tempo_conectado = seconds2time($xml->source->listener[$i]->Connected);
        $player = formatar_useragent($xml->source->listener[$i]->UserAgent);

        $array_ouvintes[] = "".$ip."|".$tempo_conectado."|".$player."";

    }

}

return $array_ouvintes;
}

function icecast_info($ip,$porta,$senha) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/stats");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);

    $resultado = xml_entity_decode($resultado);

    $xml = @simplexml_load_string(utf8_encode($resultado));

    if($xml->sources > 0) {

    list($channels, $samplerate, $bitrate) = explode(";", $xml->source->audio_info);
    $encoder = (preg_match('/mpeg/i',$xml->source->server_type)) ? "MP3" : "AACPlus";

    return array("ouvintes_total" => $xml->listeners, "bitrate" => str_replace("bitrate=", "", $bitrate), "encoder" => $encoder, "musica" => $xml->source->title, "titulo" => $xml->source->server_name, "genero" => $xml->source->genre);

    }
curl_close($ch);
}
