<?php
require_once("inc/protecao-revenda.php");

// Estatísticas de uso do plano
$total_streamings_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."' AND status = '1'"));
$total_streamings_bloqueados = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."' AND status != '1'"));

$total_subrevendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$total_subrevendas_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(subrevendas) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$total_streamings = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));
$ouvintes = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(ouvintes) as total FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));
$ouvintes_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(ouvintes) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$espaco_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(espaco) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$espaco_streamings = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(espaco) as total FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));

$porcentagem_uso_subrevendas = ($dados_revenda["subrevendas"] == 0 || $dados_revenda["subrevendas"] > 999998) ? "0" : ($total_subrevendas+$total_subrevendas_subrevendas["total"])*100/$dados_revenda["subrevendas"];
$porcentagem_uso_streamings = ($dados_revenda["streamings"] == 0 || $dados_revenda["streamings"] > 999998) ? "0" : $total_streamings*100/$dados_revenda["streamings"];
$porcentagem_uso_ouvintes = ($dados_revenda["ouvintes"] == 0 || $dados_revenda["ouvintes"] > 999998) ? "0" : ($ouvintes["total"]+$ouvintes_subrevendas["total"])*100/$dados_revenda["ouvintes"];
$porcentagem_uso_espaco_ftp = ($dados_revenda["espaco"] == 0 || $dados_revenda["espaco"] > 999998) ? "0" : ($espaco_subrevendas["total"]+$espaco_streamings["total"])*100/$dados_revenda["espaco"];

$limite_subrevendas = ($dados_revenda["subrevendas"] == 999999) ? '<small>'.lang_info_ilimitado.'</small>' : $dados_revenda["subrevendas"];
$limite_streamings = ($dados_revenda["streamings"] == 999999) ? '<small>'.lang_info_ilimitado.'</small>' : $dados_revenda["streamings"];
$limite_ouvintes = ($dados_revenda["ouvintes"] == 999999) ? '<small>'.lang_info_ilimitado.'</small>' : $dados_revenda["ouvintes"];
$limite_espaco_ftp = tamanho($dados_revenda["espaco"]);

$uso_limite_subrevendas = $total_subrevendas+$total_subrevendas_subrevendas["total"];
$uso_limite_streamings = $total_streamings;
$uso_limite_ouvintes = $ouvintes["total"]+$ouvintes_subrevendas["total"];
$uso_limite_espaco_ftp = tamanho(($espaco_subrevendas["total"]+$espaco_streamings["total"]));

?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Reseller #<?php echo $dados_revenda["id"]; ?></title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/admin/inc/ajax-revenda.js"></script>
		<script type="text/javascript" src="/admin/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_revenda["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header-revenda.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<?php if($dados_revenda["url_logo"]) { ?>
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } else { ?>
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } ?>
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu-revenda.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1">Dashboard</span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/admin/revenda">Dashboard</a></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
					<div class="row">
						<!-- cards -->
						<div class="col-12">
              <div class="row">
                <?php if($dados_revenda["subrevendas"] > 0) { ?>
                <div class="col-sm-6 col-md-3">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo lang_info_pagina_informacoes_revenda_tab_plano_subrevendas; ?></h4>                      
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-users f-32"></i></p>
                        <p class="text-muted" id="total_ouvintes"><?php echo $uso_limite_subrevendas; ?> / <?php echo $limite_subrevendas; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-success" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_subrevendas; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_subrevendas" style="width: <?php echo $porcentagem_uso_subrevendas; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <?php } ?>
                <div class="<?php if($dados_revenda["subrevendas"] > 0) { echo "col-sm-6 col-md-3"; } else { echo "col-sm-6 col-md-4"; } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo lang_info_pagina_informacoes_revenda_tab_plano_streamings; ?></h4>                      
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-headphones f-32"></i></p>
                        <p class="text-muted" id="total_ouvintes"><?php echo $uso_limite_streamings; ?> / <?php echo $limite_streamings; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-success" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_streamings; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_streamings" style="width: <?php echo $porcentagem_uso_streamings; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="<?php if($dados_revenda["subrevendas"] > 0) { echo "col-sm-6 col-md-3"; } else { echo "col-sm-6 col-md-4"; } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo lang_info_pagina_informacoes_revenda_tab_plano_ouvintes; ?></h4>                      
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-user f-32"></i></p>
                        <p class="text-muted"><?php echo $uso_limite_ouvintes; ?> / <?php echo $limite_ouvintes; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-danger" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_ouvintes; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_ouvintes" style="width: <?php echo $porcentagem_uso_ouvintes; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="<?php if($dados_revenda["subrevendas"] > 0) { echo "col-sm-6 col-md-3"; } else { echo "col-sm-6 col-md-4"; } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo lang_info_pagina_informacoes_revenda_tab_plano_ftp; ?></h4>
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-hdd f-32"></i></p>
                        <p class="text-muted"><?php echo $uso_limite_espaco_ftp; ?> / <?php echo $limite_espaco_ftp; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-danger" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_espaco_ftp; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_espaco_ftp" style="width: <?php echo $porcentagem_uso_espaco_ftp; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>  
						<?php if($dados_revenda["subrevendas"] > 0) { ?>
						<div class="col-md-6 col-xl-6 col-xs-6 col-sm-6">
							<div class="card">
								<div class="card-header d-flex custom-card-header border-bottom-0 ">
									<h5 class="card-title"><?php echo lang_acao_pagina_revenda_titulo_ultimas_subrevendas; ?></h5>
								</div>
								<div class="card-body">
									<table class="table dataTable no-footer table-hover">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimas_subrevendas_id; ?></th>
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimas_subrevendas_email; ?></th>
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimas_subrevendas_plano; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$total_subrevendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));

if($total_subrevendas > 0) {

$sql_subrevenda = mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."' ORDER by codigo DESC LIMIT 5");
while ($dados_subrevenda = mysqli_fetch_array($sql_subrevenda)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".$dados_subrevenda["id"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_subrevenda["email"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_subrevenda["streamings"]." streamings | ".$dados_subrevenda["ouvintes"]." ".lang_info_pagina_busca_avancada_resultado_ouvintes." | ".$dados_subrevenda["bitrate"]." Kbps | ".tamanho($dados_subrevenda["espaco"])."</td>
</tr>";
}

} else {

echo "<tr>
    <td height='23' colspan='3' align='center' class='texto_padrao'>".lang_info_sem_registros."</td>
  </tr>";

}

?>
                                                </tbody>
                                            </table>
								</div>
							</div>
						</div>
						<?php } ?>
						<div class="<?php if($dados_revenda["subrevendas"] > 0) { echo "col-md-6 col-xl-6 col-xs-6 col-sm-6"; } else { echo "col-md-12 col-xl-12 col-xs-12 col-sm-12"; } ?>">
							<div class="card">
								<div class="card-header d-flex custom-card-header border-bottom-0 ">
									<h5 class="card-title"><?php echo lang_acao_pagina_revenda_titulo_ultimos_streamings; ?></h5>
								</div>
								<div class="card-body">
									<table class="table dataTable no-footer table-hover">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimos_streamings_porta; ?></th>
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimos_streamings_servidor; ?></th>
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimos_streamings_plano; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$total_streamings = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));

if($total_streamings > 0) {

$sql_stm = mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."' ORDER by codigo DESC LIMIT 5");
while ($dados_stm = mysqli_fetch_array($sql_stm)) {

$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

$servidor = ($dados_revenda["dominio_padrao"]) ? strtolower($dados_servidor["nome"]).".".$dados_revenda["dominio_padrao"] : strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"];

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["porta"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$servidor."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["ouvintes"]." ".lang_info_subrevenda_streamings_ouvintes." | ".$dados_stm["bitrate"]." Kbps | ".tamanho($dados_stm["espaco"])."</td>
</tr>";
}

} else {

echo "<tr>
    <td height='23' colspan='3' align='center' class='texto_padrao'>".lang_info_sem_registros."</td>
  </tr>";

}

?>
                                                </tbody>
                                            </table>
								</div>
							</div>
						</div>
						<!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo lang_info_pagina_configurar_streaming_idioma; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/admin/revenda-mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/admin/revenda-mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<li class="col-lg-6 mb-2">
									<a href="/admin/revenda-mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_revenda["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal-revenda.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<script src="/inc/js/theme.js"></script>
		<script src="/inc/theme-<?php echo $dados_revenda["layout_painel"]; ?>.js"></script>
	  	<script>
		  $('#busca_chave').keypress(function (e) {
		    if (e.which == 13) {
		       window.location = "/admin/revenda-streamings/resultado/porta/"+document.getElementById("busca_chave").value;
		    }
		  }); 
	  	</script>
	</body>
</html>