<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

// Função para capturar informações de um streaming no shoutcast
function sc_info($ip,$porta,$ponto) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/stats?sid=".$ponto."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

return array("ouvintes_total" => $xml->CURRENTLISTENERS, "ouvintes" => $xml->MAXLISTENERS, "bitrate" => $xml->BITRATE, "encoder" => $xml->CONTENT, "musica" => $xml->SONGTITLE, "titulo" => $xml->SERVERTITLE, "pico_ouvintes" => $xml->PEAKLISTENERS, "proxima_musica" => $xml->NEXTTITLE, "genero" => $xml->SERVERGENRE, "uptime" => $xml->STREAMUPTIME, "average" => $xml->AVERAGETIME, "unique" => $xml->UNIQUELISTENERS);
}


if($dados_stm["tipo_servidor"] == "icecast") {
$status_conexao_transmissao = status_streaming_transmissao_icecast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);

$info = icecast_info($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);

// Transmissao atual
$total_ouvintes = ($info["ouvintes_total"] > 0) ? $info["ouvintes_total"] : "0";
$bitrate = ($info["bitrate"] > 0) ? $info["bitrate"] : "0";
$encoder = $info["encoder"];

} else {
$status_conexao_transmissao = status_streaming_transmissao($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);

$info = shoutcast_info($dados_servidor["ip"],$dados_stm["porta"],1);
$proxima_musica = str_replace("\n","",$info["proxima_musica"]);
$encoder = (preg_match('/aacp/i',$info["encoder"])) ? "AACPlus" : "MP3";

// Transmissao atual
$total_ouvintes = ($info["ouvintes_total"] > 0) ? $info["ouvintes_total"] : "0";
$bitrate = ($info["bitrate"] > 0) ? $info["bitrate"] : "0";

}

$porcentagem_uso_ouvintes = ($dados_stm["ouvintes"] == 0 || $dados_stm["ouvintes"] > 999998) ? "0" : $total_ouvintes*100/$dados_stm["ouvintes"];
$porcentagem_uso_espaco_ftp = ($dados_stm["espaco"] == 0 || $dados_stm["espaco"] > 999998) ? "0" : $dados_stm["espaco_usado"]*100/$dados_stm["espaco"];
$porcentagem_uso_bitrate = ($info["bitrate"] > 0) ? $info["bitrate"]*100/$dados_stm["bitrate"] : "0";

$limite_ouvintes = ($dados_stm["ouvintes"] == 999999) ? '<small>'.lang_info_ilimitado.'</small>' : $dados_stm["ouvintes"];

// Mapa de ouvintes
$status_streaming = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);

if($status_streaming == "ligado") {

if($dados_stm["senha_admin"]) {


$total_pontos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."'"));

if($dados_stm["tipo_servidor"] == "icecast") {

$porta_admin_icecast = $dados_stm["porta"]+1;

$dados_icecast = @file_get_contents("http://".$dados_servidor["ip"].":".$porta_admin_icecast."/status-json.xsl?mount=/stream");

$dados_json_icecast = json_decode($dados_icecast, true);

$audio_info = explode(";",$dados_json_icecast["icestats"]["source"]["audio_info"]);

$encoder = (preg_match('/aac/i',$dados_json_icecast["icestats"]["source"]["server_type"])) ? "AACPlus" : "MP3";
$musica_atual = ($dados_json_icecast["icestats"]["source"]["artist"]) ? $dados_json_icecast["icestats"]["source"]["artist"]." - ".$dados_json_icecast["icestats"]["source"]["title"] : $dados_json_icecast["icestats"]["source"]["title"];
$bitrate = substr($audio_info[2], strrpos($audio_info[2], '=') + 1);
$pico_ouvintes = $dados_json_icecast["icestats"]["source"]["listener_peak"];

  // IceCast
  if($total_pontos > 0) {

  $sql = mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."' ORDER by id ASC");
  while ($dados_ponto = mysqli_fetch_array($sql)) {
    $stats_icecast[] = estatistica_ouvintes_conectados_icecast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"],$dados_ponto["ponto"]);
  }

    $stats_icecast = flatten_array($stats_shoutcast);

  } else {
    $stats_icecast = estatistica_ouvintes_conectados_icecast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"],"/stream");
  }

$estatisticas = $stats_icecast;

} else {

// Dados do streaming
$info = sc_info($dados_servidor["ip"],$dados_stm["porta"],1);
$encoder = (preg_match('/aacp/i',$info["encoder"])) ? "AACPlus" : "MP3";
$musica_atual = $info["musica"];
$bitrate = $info["bitrate"];
$streamuptime = $info["uptime"];
$encoder = (preg_match('/aacp/i',$info["encoder"])) ? "AACPlus" : "MP3";
$proxima_musica = str_replace("\n","",$info["proxima_musica"]);
$pico_ouvintes = $info["pico_ouvintes"];
$average_ouvintes_sc = $info["average"];
$unique_ouvintes = ($info["unique"] == 0 || empty($info["unique"])) ? "0" : $info["unique"];

  // Shoutcast
  if($total_pontos > 0) {

  $sql = mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."' ORDER by id ASC");
  while ($dados_ponto = mysqli_fetch_array($sql)) {
    $stats_shoutcast[] = estatistica_ouvintes_conectados_shoutcast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"],$dados_ponto["id"]);
  }

    $stats_shoutcast = flatten_array($stats_shoutcast);

  } else {
    $stats_shoutcast = estatistica_ouvintes_conectados_shoutcast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"],1);
  }

$estatisticas = $stats_shoutcast;

}

$porcentagem_uso_ouvintes = ($dados_stm["ouvintes"] == 0) ? "0" : @count($estatisticas)*100/$dados_stm["ouvintes"];
$porcentagem_uso_ouvintes = ($porcentagem_uso_ouvintes < 1 && @count($estatisticas) > 0) ? "1" : $porcentagem_uso_ouvintes;

$porcentagem_uso_ftp = ($dados_stm["espaco_usado"] == 0 || $dados_stm["espaco"] == 0) ? "0" : $dados_stm["espaco_usado"]*100/$dados_stm["espaco"];

// Insere os ouvintes conectados na tabela temporaria
if(@count($estatisticas) > 0) {

  $sql_check = mysqli_query($conexao,"SELECT codigo_stm,ip FROM ouvintes_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."'");
while ($dados_check = mysqli_fetch_array($sql_check)) {

  if(!preg_grep('/'.$dados_check["ip"].'/i',$estatisticas)) {
    mysqli_query($conexao,"Delete From ouvintes_conectados where ip = '".$dados_check["ip"]."' AND codigo_stm = '".$dados_stm["codigo"]."'");
  }

}

foreach($estatisticas as $estatistica) {

list($ip, $tempo_conectado, $player) = explode("|",$estatistica);

if (filter_var($ip, FILTER_VALIDATE_IP)) {

// Verifica se ja tem no banco de dados de geoip e usa banco de dados ao invez da API
$verifica_ip_geoip_db_atual = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM ouvintes_conectados where codigo_stm = '".$dados_stm["codigo"]."'  AND ip = '".$ip."'"));

if($verifica_ip_geoip_db_atual == 0) {

$dados_api_geoip = api_geoip($ip);

$pais_codigo = $dados_api_geoip["pais_sigla"];
$pais_nome = $dados_api_geoip["pais_nome"];
$cidade = $dados_api_geoip["cidade"];
$estado = $dados_api_geoip["estado"];
$latitude = $dados_api_geoip["latitude"];
$longitude = $dados_api_geoip["longitude"];

mysqli_query($conexao,"INSERT INTO ouvintes_conectados (codigo_stm,ip,tempo_conectado,pais_sigla,pais_nome,cidade,estado,player,latitude,longitude,atualizacao) VALUES ('".$dados_stm["codigo"]."','".$ip."','".$tempo_conectado."','".$pais_codigo."','".utf8_decode($pais_nome)."','".$cidade."','".$estado."','".$player."','".$latitude."','".$longitude."',NOW())");

} else {

mysqli_query($conexao,"Update ouvintes_conectados set tempo_conectado = '".$tempo_conectado."', atualizacao = NOW() where ip = '".$ip."'");

}

} // fim if FILTER_VALIDATE_IP

}
}

}
}
?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Streaming <?php echo $dados_stm["porta"]; ?></title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/inc/ajax-streaming.js"></script>
		<script type="text/javascript" src="/inc/javascript.js"></script>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css" integrity="sha256-kLaT2GOSpHechhsozzB+flnD+zUyjE2LlfWPgU04xyI=" crossorigin=""/>
<script src="https://unpkg.com/leaflet@1.9.3/dist/leaflet.js" integrity="sha256-WBkoXOwTeyKclOHuWtc+i2uENFpDZ9YPdf5Hf+D7ewM=" crossorigin=""></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_stm["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<?php if($dados_revenda["url_logo"]) { ?>
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } else { ?>
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } ?>
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo $lang["lang_info_pagina_informacoes_streaming_boas_vindas"]; ?> <?php echo $dados_stm["identificacao"]; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/dashboard">Dashboard</a></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
					<div class="row">
						<div class="col-xl-7 col-lg-12 col-md-12 col-sm-12">
							<div class="card">
								<div class="card-block">
									<iframe src="https://player.<?php echo $dados_config['dominio_padrao']; ?>/player-premium/<?php echo $dados_stm["porta"]; ?>/L2ltZy9sb2dvLXBlcXVlbm8ucG5n" frameborder="0" width="100%" height="300"></iframe>
								</div>
							</div>
						</div>
						<div class="col-xl-5 col-lg-12 col-md-12 col-sm-12">
							<!-- <div class="container"> -->
								<div class="row">
									<div class="col-xl-6 col-lg-6 col-md-6 col-xs-12">
										<div class="card sales-card circle-image1">
											<div class="row">
												<div class="col-8">
													<div class="ps-4 pt-4 pe-3 pb-4">
														<div class="">
															<h6 class="mb-2 tx-12 "><?php echo $lang['lang_info_porta']; ?></h6>
														</div>
														<div class="pb-0 mt-0">
															<div class="d-flex">
																<h4 class="tx-20 font-weight-semibold mb-2"><?php echo $dados_stm["porta"]; ?></h4>
															</div>															
															<p class="mb-0 tx-13 text-muted">
																<?php if($dados_stm["autodj"] == "sim") { ?>
																<?php echo $lang['lang_info_pagina_informacoes_streaming_tab_stm_porta']; ?> DJ<br>
																<span class="text-muted"> <?php echo $dados_stm["porta_dj"]; ?></span>
																<?php } ?>
															</p>
														</div>
													</div>
												</div>
												<div class="col-4">
													<div class="circle-icon bg-primary-transparent text-center align-self-center overflow-hidden">
														<i class="fa fa-user-circle tx-16 text-primary"></i>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="col-xl-6 col-lg-6 col-md-6 col-xs-12">
										<div class="card sales-card circle-image2">
											<div class="row">
												<div class="col-8">
													<div class="ps-4 pt-4 pe-3 pb-4">
														<div class="">
															<h6 class="mb-2 tx-12"><?php echo $lang['lang_info_pagina_informacoes_streaming_tab_plano_ouvintes']; ?></h6>
														</div>
														<div class="pb-0 mt-0">
															<div class="d-flex">
																<h4 class="tx-18 font-weight-semibold mb-2" id="total_ouvintes"><?php echo $total_ouvintes; ?> / <?php echo $dados_stm["ouvintes"]; ?></h4>
															</div>
															<div class="progress progress-md" style="<?php if($dados_stm["autodj"] == "sim") { ?>margin-top: 27px;<?php } else { ?>margin-top: 8px;<?php } ?>">
										                        <div class="progress-bar bg-success" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_ouvintes; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_ouvintes" style="width: <?php echo $porcentagem_uso_ouvintes; ?>%;"></div>
										                      </div>
														</div>
													</div>
												</div>
												<div class="col-4">
													<div class="circle-icon bg-info-transparent text-center align-self-center overflow-hidden">
														<i class="fa fa-users tx-16 text-info"></i>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="col-xl-6 col-lg-6 col-md-6 col-xs-12">
										<div class="card sales-card circle-image3">
											<div class="row">
												<div class="col-8">
													<div class="ps-4 pt-4 pe-3 pb-4">
														<div class="">
															<h6 class="mb-2 tx-12"><?php echo $lang['lang_info_pagina_informacoes_streaming_tab_ftp_espaco']; ?></h6>
														</div>
														<div class="pb-0 mt-0">
															<div class="d-flex">
																<h4 class="tx-16 font-weight-semibold mb-2"><?php echo tamanho($dados_stm["espaco_usado"]); ?> / <?php echo tamanho($dados_stm["espaco"]); ?></h4>
															</div>
										                      <div class="progress progress-md" style="margin-top: 24px;">
										                        <div class="progress-bar bg-danger" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_espaco_ftp; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_ouvintes" style="width: <?php echo $porcentagem_uso_espaco_ftp; ?>%;"></div>
										                      </div>
														</div>
													</div>
												</div>
												<div class="col-4">
													<div class="circle-icon bg-secondary-transparent text-center align-self-center overflow-hidden">
														<i class="far fa-hdd tx-16 text-secondary"></i>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="col-xl-6 col-lg-6 col-md-6 col-xs-12">
										<div class="card sales-card circle-image4">
											<div class="row">
												<div class="col-8">
													<div class="ps-4 pt-4 pe-3 pb-4">
														<div class="">
															<h6 class="mb-2 tx-12">Bitrate</h6>
														</div>
														<div class="pb-0 mt-0">
															<div class="d-flex">
																<h4 class="tx-18 font-weight-semibold mb-2"><?php echo $dados_stm["bitrate"]; ?> <small>Kbps</small></h4>
															</div>
										                      <div class="progress progress-md" style="margin-top: 21px;">
										                        <div class="progress-bar bg-warning" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_bitrate; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $porcentagem_uso_bitrate; ?>%;"></div>
										                      </div>
														</div>
													</div>
												</div>
												<div class="col-4">
													<div class="circle-icon bg-warning-transparent text-center align-self-center overflow-hidden">
														<i class="fa fa-signal tx-16 text-warning"></i>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						<div class="col-md-7 col-xl-7 col-xs-7 col-sm-7">
							<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
								<div class="card">
									<div class="card-header d-flex custom-card-header border-bottom-0 ">
										<h5 class="card-title">Streaming</h5>
									</div>
									<div class="card-block text-center" style="<?php if($dados_stm["autodj"] == "sim") { ?>padding-left: 10px;padding-right: 10px;padding-bottom: 10px<?php } else { ?>padding: 20px<?php } ?>">
										<button type="button" class="btn btn-primary" onClick="ligar_streaming('<?php echo $porta_code; ?>');" style="width: 195px; margin: 3px;"><i class="fa fa-play-circle" style="font-size: 28px"></i><br><?php echo $lang[ 'lang_botao_titulo_ligar' ]; ?> Streaming</button>
                      					<button type="button" class="btn btn-danger" onClick="desligar_streaming('<?php echo $porta_code; ?>');" style="width: 195px; margin: 3px;"><i class="fa fa-stop-circle" style="font-size: 28px"></i><br><?php echo $lang[ 'lang_botao_titulo_desligar' ]; ?> Streaming</button>
                      					<button type="button" class="btn btn-secondary" onClick="desligar_streaming('<?php echo $porta_code; ?>');ligar_streaming('<?php echo $porta_code; ?>');" style="width: 195px; margin: 3px;"><i class="fa fa-undo" style="font-size: 28px"></i><br><?php echo $lang[ 'lang_botao_titulo_reiniciar' ]; ?> Streaming</button>
									</div>
								</div>
							</div>
							<?php if($dados_stm["autodj"] == "sim") { ?>
							<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
								<div class="card">
									<div class="card-header d-flex custom-card-header border-bottom-0 ">
										<h5 class="card-title">AutoDJ</h5>
									</div>
									<div class="card-block text-center" style="padding-left: 10px;padding-right: 10px;padding-bottom: 10px">
										<button type="button" class="btn btn-primary" onClick="carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');" style="width: 195px; margin: 3px;"><i class="fa fa-play-circle" style="font-size: 28px"></i><br><?php echo $lang[ 'lang_botao_titulo_ligar' ]; ?> AutoDJ</button>
                      					<button type="button" class="btn btn-danger" onClick="desligar_autodj('<?php echo $porta_code; ?>');" style="width: 195px; margin: 3px;"><i class="fa fa-stop-circle" style="font-size: 28px"></i><br><?php echo $lang[ 'lang_botao_titulo_desligar' ]; ?> AutoDJ</button>
                      					<button type="button" class="btn btn-secondary" onClick="desligar_autodj('<?php echo $porta_code; ?>');carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');" style="width: 195px; margin: 3px;"><i class="fa fa-undo" style="font-size: 28px"></i><br><?php echo $lang[ 'lang_botao_titulo_reiniciar' ]; ?> AutoDJ</button>
									</div>
								</div>
							</div>
							<?php } ?>
						</div>
						<div class="col-md-5 col-xl-5 col-xs-5 col-sm-5">
							<div class="card">
								<div class="card-header d-flex custom-card-header border-bottom-0 ">
									<h5 class="card-title"><?php echo $lang['lang_info_ouvintes_conectados_mapa_tab_titulo']; ?></h5>
								</div>
								<div class="card-block">
									<div id="mapa_ouvintes" style="width:100%; height: 400px; margin: 0 auto"></div>
                                        <script type="text/javascript">
                                            var locations = [
                                              <?php
                                              if(count($estatisticas) > 0) {

                                              $sql_ouvintes = mysqli_query($conexao,"SELECT * FROM ouvintes_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by ip ASC");
                                              while ($dados_ouvinte = mysqli_fetch_array($sql_ouvintes)) {

                                              $latitude = $dados_ouvinte["latitude"];
                                              $longitude = $dados_ouvinte["longitude"];

                                              $player_icone = (file_exists("img/icones/players/".str_replace(" ","",$dados_ouvinte["player"]).".png")) ? str_replace(" ","",$dados_ouvinte["player"]) : "Outro";

                                              echo "['<strong>".$lang['lang_info_ouvintes_conectados_ouvinte'].":</strong> ".$dados_ouvinte["ip"]."<br><strong>".$lang['lang_info_ouvintes_conectados_localidade'].":</strong> ".addslashes($dados_ouvinte["estado"])." - ".addslashes($dados_ouvinte["cidade"])."<br><strong>Player:</strong> <img src=\"/img/icones/players/".$player_icone.".png\" border=\"0\" width=\"16\" height=\"16\" align=\"absmiddle\" />&nbsp;".$dados_ouvinte["player"]."', ".$latitude.", ".$longitude."],";

                                              }

                                              }
                                              ?>];

                                              const map = L.map('mapa_ouvintes').setView([0, 0], 2);

                                              const tiles = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
                                                maxZoom: 19,
                                                attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
                                              }).addTo(map);

                                              for (var i = 0; i < locations.length; i++) {
                                                marker = new L.marker([locations[i][1], locations[i][2]])
                                                  .bindPopup(locations[i][0])
                                                  .addTo(map);
                                              }
                                              function filtrar_mapa(coord) {

                                              const coords = coord.split(',');
                                              map.flyTo([coords[0], coords[1]], coords[2]);

                                              }
                                            </script>
								</div>
							</div>
						</div>
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-header d-flex custom-card-header border-bottom-0 ">
									<h5 class="card-title"><?php echo $lang['lang_acao_painel_logs']; ?></h5>
								</div>
								<div class="card-body">
									<div class="table-responsive">
                                            <table class="table table-hover mb-0">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo $lang['lang_info_streaming_logs_data']; ?></th>
                                                        <th><?php echo $lang['lang_info_streaming_logs_ip']; ?></th>
                                                        <th><?php echo $lang['lang_info_streaming_logs_navegador']; ?></th>
                                                        <th><?php echo $lang['lang_info_streaming_logs_log']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM logs_streamings WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo DESC LIMIT 5");
while ($dados_log = mysqli_fetch_array($sql)) {

$log = str_replace("<br>","",$dados_log["log"]);
$log = str_replace("<br />","",$log);

$log = (strlen($log) > 105) ? substr($log, 0, 105)."..." : $log;

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".formatar_data($dados_stm["formato_data"], $dados_log["data"], $dados_stm["timezone"])."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_log["ip"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_log["navegador"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$log."</td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
                                        </div>
								</div>
							</div>
						</div>
						<!-- </div> -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo $lang['lang_info_config_painel_idioma']; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<script src="/inc/js/theme.js"></script>
		<script src="/inc/theme-<?php echo $dados_stm["layout_painel"]; ?>.js"></script>
  		<script src="https://jvectormap.com/js/jquery-jvectormap-world-mill.js"></script>
	  	<script>
		  status_streaming('<?php echo $porta_code; ?>');
		  transmissao_atual();
		  setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
        setInterval("transmissao_atual()",60000);
       
	  	</script>
	</body>
</html>