<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

$estatistica = query_string('1');
$exibir = query_string('2');
$mes = query_string('3');
$ano = query_string('4');

$total_ouvintes_db = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$total_ouvintes_unicos_db = mysqli_num_rows(mysqli_query($conexao,"SELECT DISTINCT ip FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$tempo_conectado = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));

$average_ouvintes  = $tempo_conectado["total_tempo"]/$tempo_conectado["total_registros"];

?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Streaming <?php echo $dados_stm["porta"]; ?></title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/inc/ajax-streaming.js"></script>
		<script type="text/javascript" src="/inc/javascript.js"></script>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		  <script src="https://code.highcharts.com/highcharts.js"></script>
		  <script src="https://code.highcharts.com/highcharts-3d.js"></script>
		  <script src="https://code.highcharts.com/modules/exporting.js"></script>
  <style type="text/css">@media print{.no-print{display:none}}.rotate_45{-webkit-transform:rotate(-45deg);-moz-transform:rotate(-45deg);-ms-transform:rotate(-45deg);-o-transform:rotate(-45deg)}.rotate_90{-webkit-transform:rotate(-90deg);-moz-transform:rotate(-90deg);-ms-transform:rotate(-90deg);-o-transform:rotate(-90deg)}</style>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_stm["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<?php if($dados_revenda["url_logo"]) { ?>
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } else { ?>
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } ?>
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo $lang['lang_acao_ouvintes_stats']; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/dashboard">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo $lang['lang_acao_ouvintes_stats']; ?></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
					<div class="row">
						<!-- cards -->
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<h6 class="main-content-label  mb-2 "><?php echo $lang['lang_info_estatisticas_registros_tab_titulo']; ?></h6>
									 <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                              <td width="25%" height="70" align="center"><i class='fa fa-users' style="font-size: 32px;"></i></td>
                                              <td width="25%" align="center"><i class='fa fa-user' style="font-size: 32px;"></i></td>
                                              <td width="25%" align="center"><i class='fa fa-chart-line' style="font-size: 32px;"></i></td>
                                              <td width="25%" align="center"><i class='fa fa-clock' style="font-size: 32px;"></i></td>
                                            </tr>
                                            <tr>
                                              <td height="30" align="center"><strong><?php echo $total_ouvintes_db; ?></strong><br /><small><?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></small></td>
                                              <td align="center"><strong><?php echo $total_ouvintes_unicos_db; ?></strong><br /><small><?php echo $lang['lang_info_estatisticas_total_ouvintes_unicos']; ?></small></td>
                                              <td align="center"><strong><?php echo $total_ouvintes_db; ?></strong><br /><small><?php echo $lang['lang_info_estatisticas_total_ouvintes_pico']; ?></small></td>
                                              <td align="center"><strong><?php echo seconds2time($average_ouvintes); ?></strong><br /><small><?php echo $lang['lang_info_estatisticas_total_ouvintes_tempo_conectados']; ?></small></td>
                                            </tr>
                                          </table>
								</div>
							</div>
						</div>
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<h6 class="main-content-label  mb-2 "><?php echo $lang['lang_info_estatisticas_grafico_periodo_tab_titulo']; ?></h6>
									<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                              <td colspan="4" align="center">
                                              	<div class="input-group"><select name="estatistica" class="form-control" id="estatistica" onChange="tipo_estatistica(this.value);">
                                              <optgroup label="<?php echo $lang['lang_info_estatisticas_periodo_graficos']; ?>">
                                      <option value="1"><?php echo $lang['lang_info_estatisticas_estatistica_ouvintes_dia']; ?></option>
                                      <option value="2"><?php echo $lang['lang_info_estatisticas_estatistica_ouvintes_ano']; ?></option>
                                      <option value="3"><?php echo $lang['lang_info_estatisticas_grafico_tempo_medio_conectado']; ?></option>
                                      <option value="4"><?php echo $lang['lang_info_estatisticas_grafico_localidade']; ?></option>
                                      <option value="5"><?php echo $lang['lang_info_estatisticas_grafico_players']; ?></option>
                                      <option value="6"><?php echo $lang['lang_info_estatisticas_grafico_ouvintes_hora']; ?></option>
                                      </optgroup>
                                    </select>&nbsp;<select name="mes" class="form-control" id="mes">
                                              <optgroup label="<?php echo $lang['lang_info_estatisticas_periodo_meses']; ?>">
                                              <option value="todos">Anual(texto)</option>
                                      <option value="01" <?php if(date("m") == '01') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_01']; ?></option>
                                      <option value="02" <?php if(date("m") == '02') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_02']; ?></option>
                                      <option value="03" <?php if(date("m") == '03') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_03']; ?></option>
                                      <option value="04" <?php if(date("m") == '04') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_04']; ?></option>
                                      <option value="05" <?php if(date("m") == '05') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_05']; ?></option>
                                      <option value="06" <?php if(date("m") == '06') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_06']; ?></option>
                                      <option value="07" <?php if(date("m") == '07') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_07']; ?></option>
                                      <option value="08" <?php if(date("m") == '08') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_08']; ?></option>
                                      <option value="09" <?php if(date("m") == '09') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_09']; ?></option>
                                      <option value="10" <?php if(date("m") == '10') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_10']; ?></option>
                                      <option value="11" <?php if(date("m") == '11') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_11']; ?></option>
                                      <option value="12" <?php if(date("m") == '12') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_12']; ?></option>
                                      </optgroup>
                                    </select>&nbsp;<select name="ano" class="form-control" id="ano">
                                              <optgroup label="<?php echo $lang['lang_info_estatisticas_periodo_anos']; ?>">
                                        <?php
                                            $ano_inicial = date("Y")-1;
                                            $ano_final = date("Y")+1;
                                            $qtd = $ano_final-$ano_inicial;
                                                for($i=0; $i <= $qtd; $i++) {
                                                        if(sprintf("%02s",$ano_inicial+$i) == date("Y")) {
                                                            echo "<option value=\"".sprintf("%02s",$ano_inicial+$i)."\" selected=\"selected\">".sprintf("%02s",$ano_inicial+$i)."</option>\n";
                                                        } else {
                                                            echo "<option value=\"".sprintf("%02s",$ano_inicial+$i)."\">".sprintf("%02s",$ano_inicial+$i)."</option>\n";
                                                        }
                                                }
                                        ?>
                                        </optgroup>
                                    </select>&nbsp;<select name="exibir" class="form-control" id="exibir">
                                              <optgroup label="Exibir">
                                                <option value="grafico">Gr&aacute;fico</option>
                                                <option value="texto">Texto</option>
                                            </optgroup>
                                    </select>&nbsp;<button type="button" class="btn btn-info" onClick="window.location = '/estatisticas/'+document.getElementById('estatistica').value+'/'+document.getElementById('exibir').value+'/'+document.getElementById('mes').value+'/'+document.getElementById('ano').value+'';"><?php echo $lang['lang_botao_titulo_visualizar']; ?></button></div></td>
                                            </tr>
                                          </table>
								</div>
							</div>
						</div>
						 <?php if($estatistica) { ?>
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<?php if($estatistica == "1" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_ouvintes_dia',
                                                        type: 'area'
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?>'
                                                    },
                                                    subtitle: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano; ?>'
                                                    },
                                                    xAxis: {
                                                        categories: [
                                                        <?php
                                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");
                                                        
                                                        for($i=1;$i<=$array_dias_meses[$mes];$i++){
                                                        
                                                        $dias .= sprintf("%02s",$i).",";

                                                        }
                                                        
                                                        echo substr($dias, 0, -1);          
                                                        ?>              
                                                        ],
                                                        tickmarkPlacement: 'on',
                                                        title: {
                                                            enabled: false
                                                        }
                                                    },
                                                    yAxis: {
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?>'
                                                        },
                                                        labels: {
                                                            formatter: function() {
                                                                return this.value;
                                                            }
                                                        }
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return ''+
                                                                this.x +'/<?php echo $mes;?>/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_ouvintes']; ?>';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        area: {
                                                            stacking: 'normal',
                                                            lineColor: '#666666',
                                                            lineWidth: 1,
                                                            cursor: 'pointer',
                                                            marker: {
                                                                lineWidth: 1,
                                                                lineColor: '#666666',
                                                                enabled: false,
                                                                symbol: 'circle',
                                                                radius: 2,
                                                                states: {
                                                                    hover: {
                                                                    enabled: true
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    series: [{
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_dia']; ?>',
                                                        data: [
                                                        <?php
                                                        
                                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){
                                                        
                                                        $dia = sprintf("%02s",$i);
                                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                                        $total_ouvintes_mes = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));
                                                        
                                                        echo $total_ouvintes_mes.",";
                                                        echo "\n";
                                                        
                                                        }
                                                        ?>
                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <center><div id="grafico_ouvintes_dia" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "2" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_ouvintes_ano',
                                                        type: 'area'
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_ano']; ?>'
                                                    },
                                                    subtitle: {
                                                        text: '<?php echo $ano; ?>'
                                                    },
                                                    xAxis: {
                                                        categories: [
                                                        <?php
                                                        echo "'".$lang['lang_info_estatisticas_periodo_01']."','".$lang['lang_info_estatisticas_periodo_02']."','".$lang['lang_info_estatisticas_periodo_03']."','".$lang['lang_info_estatisticas_periodo_04']."','".$lang['lang_info_estatisticas_periodo_05']."','".$lang['lang_info_estatisticas_periodo_06']."','".$lang['lang_info_estatisticas_periodo_07']."','".$lang['lang_info_estatisticas_periodo_08']."','".$lang['lang_info_estatisticas_periodo_09']."','".$lang['lang_info_estatisticas_periodo_10']."','".$lang['lang_info_estatisticas_periodo_11']."','".$lang['lang_info_estatisticas_periodo_12']."'";
                                                        ?>              
                                                        ],
                                                        tickmarkPlacement: 'on',
                                                        title: {
                                                            enabled: false
                                                        }
                                                    },
                                                    yAxis: {
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?>'
                                                        },
                                                        labels: {
                                                            formatter: function() {
                                                                return this.value;
                                                            }
                                                        }
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return ''+
                                                                this.x +'/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_ouvintes']; ?>';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        area: {
                                                            stacking: 'normal',
                                                            lineColor: '#666666',
                                                            lineWidth: 1,
                                                            cursor: 'pointer',
                                                            marker: {
                                                                lineWidth: 1,
                                                                lineColor: '#666666',
                                                                enabled: false,
                                                                symbol: 'circle',
                                                                radius: 2,
                                                                states: {
                                                                    hover: {
                                                                    enabled: true
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    series: [{
                                                        name: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?>',
                                                        data: [
                                                        <?php
                                                        
                                                        $array_meses_ano = array("01","02","03","04","05","06","07","08","09","10","11","12");
                                                        
                                                        foreach($array_meses_ano as $mes_ano) {
                                                        
                                                        $mes_ano = sprintf("%02s",$mes_ano);
                                                        
                                                        $total_ouvintes_ano = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes_ano."'"));
                                                        
                                                        $total_ouvintes_meses .= $total_ouvintes_ano.",";
                                                        
                                                        }
                                                        echo substr($total_ouvintes_meses, 0, -1);  
                                                        ?>
                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <center><div id="grafico_ouvintes_ano" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "3" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_ouvintes_tempo_conectado',
                                                        type: 'area'
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_grafico_ouvintes_tempo_conectado_tab_titulo']; ?>'
                                                    },
                                                    subtitle: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano;?>'
                                                    },
                                                    xAxis: {
                                                        categories: [
                                                        <?php
                                                        $array_dias_meses = array("01" => "31", "02" => "28", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");
                                                        
                                                        for($i=1;$i<=$array_dias_meses[$mes];$i++){
                                                        
                                                        $dias .= sprintf("%02s",$i).",";

                                                        }
                                                        
                                                        echo substr($dias, 0, -1);          
                                                        ?>              
                                                        ],
                                                        tickmarkPlacement: 'on',
                                                        title: {
                                                            enabled: false
                                                        }
                                                    },
                                                    yAxis: {
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_tempo_conectado_minutos']; ?>'
                                                        },
                                                        labels: {
                                                            formatter: function() {
                                                                return this.value;
                                                            }
                                                        }
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return ''+
                                                                this.x +'/<?php echo $mes;?>/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_minutos']; ?>';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        area: {
                                                            stacking: 'normal',
                                                            lineColor: '#666666',
                                                            lineWidth: 1,
                                                            cursor: 'pointer',
                                                            marker: {
                                                                lineWidth: 1,
                                                                lineColor: '#666666',
                                                                enabled: false,
                                                                symbol: 'circle',
                                                                radius: 2,
                                                                states: {
                                                                    hover: {
                                                                    enabled: true
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    series: [{
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_tempo_conectado_minutos']; ?>',
                                                        data: [
                                                        <?php
                                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){
                                                        
                                                        $dia = sprintf("%02s",$i);
                                                        
                                                        $data = $ano."-".$mes."-".$dia;

                                                        
                                                        $tempo_conectado_stat = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));
                                                        
                                                        $media = ($tempo_conectado_stat["total_registros"] > 0) ? $tempo_conectado_stat["total_tempo"]/$tempo_conectado_stat["total_registros"] : '0';
                                                        
                                                        echo date('i',mktime(0,0,$media,15,03,2013)).",";
                                                        echo "\n";
                                                        
                                                        }
                                                        ?>
                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });

                                        </script>
                                        <center><div id="grafico_ouvintes_tempo_conectado" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "4" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_paises',
                                                        type: 'pie',
                                                            options3d: {
                                                                enabled: true,
                                                                alpha: 45,
                                                                beta: 0
                                                            }
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_paises']; ?>'
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        pie: {
                                                            allowPointSelect: true,
                                                            cursor: 'pointer',
                                                            depth: 35,
                                                            dataLabels: {
                                                                enabled: true
                                                            },
                                                            showInLegend: true
                                                        }
                                                    },
                                                    series: [{
                                                        type: 'pie',
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_paises']; ?>',
                                                        data: [
                                                        
                                                        <?php
                                                        
                                                        $sql_paises = mysqli_query($conexao,"SELECT distinct(pais) as pais, count(pais) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' GROUP by pais ORDER by total DESC LIMIT 5");
                                                        while ($dados_pais_ip = mysqli_fetch_array($sql_paises)) {

                                                        if($dados_pais_ip["total"] > 1) {
                                                        
                                                        echo "['".$dados_pais_ip["pais"]."', ".$dados_pais_ip["total"]."],";
                                                        echo "\n";

                                                        }

                                                        }
                                                        
                                                        ?>

                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_estados',
                                                        type: 'pie',
                                                            options3d: {
                                                                enabled: true,
                                                                alpha: 45,
                                                                beta: 0
                                                            }
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_estados']; ?>'
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        pie: {
                                                            allowPointSelect: true,
                                                            cursor: 'pointer',
                                                            depth: 35,
                                                            dataLabels: {
                                                                enabled: true
                                                            },
                                                            showInLegend: true
                                                        }
                                                    },
                                                    series: [{
                                                        type: 'pie',
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_estados']; ?>',
                                                        data: [
                                                        
                                                        <?php
                                                        
                                                        $sql_estados = mysqli_query($conexao,"SELECT distinct(estado) as estado, count(estado) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND estado != '' GROUP by estado ORDER by total DESC LIMIT 6");
                                                        while ($dados_stat_estado = mysqli_fetch_array($sql_estados)) {

                                                        if($dados_stat_estado["total"] > 1) {
                                                        
                                                        echo "['".$dados_stat_estado["estado"]."', ".$dados_stat_estado["total"]."],";
                                                        echo "\n";

                                                        }

                                                        }
                                                        
                                                        ?>

                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_cidades',
                                                        type: 'pie',
                                                            options3d: {
                                                                enabled: true,
                                                                alpha: 45,
                                                                beta: 0
                                                            }
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_cidades']; ?>'
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        pie: {
                                                            allowPointSelect: true,
                                                            cursor: 'pointer',
                                                            depth: 35,
                                                            dataLabels: {
                                                                enabled: true
                                                            },
                                                            showInLegend: true
                                                        }
                                                    },
                                                    series: [{
                                                        type: 'pie',
                                                        data: [
                                                        
                                                        <?php
                                                        
                                                        $sql_cidades = mysqli_query($conexao,"SELECT distinct(cidade) as cidade, count(cidade) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND cidade != '' GROUP by cidade ORDER by total DESC LIMIT 6");
                                                        while ($dados_stat_cidade = mysqli_fetch_array($sql_cidades)) {

                                                        if($dados_stat_cidade["total"] > 0) {
                                                        
                                                        echo "['".$dados_stat_cidade["cidade"]."', ".$dados_stat_cidade["total"]."],";
                                                        echo "\n";

                                                        }

                                                        }
                                                        
                                                        ?>

                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <center><div id="grafico_paises" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <br /><br />
                                        <center><div id="grafico_estados" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <br /><br />
                                        <center><div id="grafico_cidades" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "5" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_players',
                                                        type: 'pie',
                                                            options3d: {
                                                                enabled: true,
                                                                alpha: 45,
                                                                beta: 0
                                                            }
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_info_stats_players']; ?>'
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        pie: {
                                                            allowPointSelect: true,
                                                            cursor: 'pointer',
                                                            depth: 35,
                                                            dataLabels: {
                                                                enabled: true
                                                            },
                                                            showInLegend: true
                                                        }
                                                    },
                                                    series: [{
                                                        type: 'pie',
                                                        data: [
                                                        
                                                        <?php
                                                        
                                                        $sql_players = mysqli_query($conexao,"SELECT distinct(player) as player, count(player) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND player != '' GROUP by player ORDER by total DESC LIMIT 6");
                                                        while ($dados_player = mysqli_fetch_array($sql_players)) {

                                                        if($dados_player["total"] > 0) {
                                                        
                                                        echo "['".$dados_player["player"]."', ".$dados_player["total"]."],";
                                                        echo "\n";

                                                        }

                                                        }
                                                        
                                                        ?>

                                                        ]
                                                    }]
                                                });
                                            });
                                            
                                        });
                                        </script>
                                        <center><div id="grafico_players" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "6" && $exibir == "grafico") { ?>
                                        <script type="text/javascript">
                                        $(function () {
                                            var chart;
                                            $(document).ready(function() {
                                                chart = new Highcharts.Chart({
                                                    chart: {
                                                        renderTo: 'grafico_ouvintes_tempo_conectado_hora',
                                                        type: 'area'
                                                    },
                                                    title: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_grafico_ouvintes_hora_tab_titulo']; // Ouvintes Conectados por Hora ?>'
                                                    },
                                                    subtitle: {
                                                        text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano;?>'
                                                    },
                                                    xAxis: {
                                                        categories: ['00:00-00:59','01:00-01:59','02:00-02:59','03:00-03:59','04:00-04:59','05:00-05:59','06:00-06:59','07:00-07:59','08:00-08:59','09:00-09:59','10:00-10:59','11:00-11:59','12:00-12:59','13:00-13:59','14:00-14:59','15:00-15:59','16:00-16:59','17:00-17:59','18:00-18:59','19:00-19:59','20:00-20:59','21:00-21:59','22:00-22:59','23:00-23:59'],
                                                        tickmarkPlacement: 'on',
                                                    },
                                                    yAxis: {
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_estatisticas_total_ouvintes']; // Total de Ouvintes ?>'
                                                        },
                                                        labels: {
                                                            formatter: function() {
                                                                return this.value;
                                                            }
                                                        }
                                                    },
                                                    tooltip: {
                                                        formatter: function() {
                                                            return ''+this.x+': '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_ouvintes']; // ouvinte(s) ?>';
                                                        }
                                                    },
                                                    plotOptions: {
                                                        area: {
                                                            stacking: 'normal',
                                                            lineColor: '#666666',
                                                            lineWidth: 1,
                                                            cursor: 'pointer',
                                                            marker: {
                                                                lineWidth: 1,
                                                                lineColor: '#666666',
                                                                enabled: false,
                                                                symbol: 'circle',
                                                                radius: 2,
                                                                states: {
                                                                    hover: {
                                                                    enabled: true
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    series: [{
                                                        name: '<?php echo $lang['lang_info_estatisticas_info_stats_ouvintes_ano']; ?>',
                                                        data: [<?php
                                                        
                                                        for($i=0;$i<=23;$i++){
                                                        
                                                        $hora = sprintf("%02s",$i);
                                                        
                                                        $total_ouvintes = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data,hora FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND HOUR(hora) = '".$hora."'"));
                                                        
                                                        $array_total_ouvintes .= $total_ouvintes.",";
                                                        
                                                        }
                                                        echo substr($array_total_ouvintes, 0, -1);  
                                                        
                                                        unset($array_total_ouvintes);
                                                        unset($total_ouvintes);
                                                        ?>]
                                                    }]
                                                });
                                            });
                                            
                                        });

                                        </script>
                                        <center><div id="grafico_ouvintes_tempo_conectado_hora" style="min-width: 600px; height: 300px; margin: 0 auto"></div></center>
                                        <?php } else if($estatistica == "1" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td colspan="4" align="center">
                                        <?php if(is_numeric($mes)) { ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="40" align="center" class="texto_padrao_vermelho_destaque" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br><span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              01</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              02</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              03</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              04</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              05</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              06</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              07</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              08</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              09</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              10</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              11</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              12</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              13</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              14</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              15</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              16</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              17</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              18</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              19</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              20</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              21</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              22</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              23</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              24</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              25</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              26</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              27</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              28</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              29</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              30</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              31</td>
                                          </tr>
                                          <tr>
                                            <td height="25" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        // Mes especifico

                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");

                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){

                                        $dia = sprintf("%02s",$i);          
                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                        $total_ouvintes_dia = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $total_ouvintes_dia; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <?php } else { ?>

                                        <?php
                                        // Todos os meses
                                        for($iMes=1;$iMes<=date("m");$iMes++){

                                        $mes = sprintf("%02s",$iMes);   
                                        ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="40" align="center" class="texto_padrao_vermelho_destaque" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br><span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              01</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              02</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              03</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              04</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              05</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              06</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              07</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              08</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              09</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              10</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              11</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              12</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              13</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              14</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              15</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              16</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              17</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              18</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              19</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              20</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              21</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              22</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              23</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              24</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              25</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              26</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              27</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              28</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              29</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              30</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              31</td>
                                          </tr>
                                          <tr>
                                            <td height="25" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");

                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){

                                        $dia = sprintf("%02s",$i);          
                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                        $total_ouvintes_dia = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $total_ouvintes_dia; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <?php } ?>
                                        <?php } ?>
                                        </td>
                                        </tr>
                                        </table>
                                        <?php } else if($estatistica == "2" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $ano; ?></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_01']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_02']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_03']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_04']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_05']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_06']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_07']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_08']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_09']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_10']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_11']; ?></div></td>
                                            <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $lang['lang_info_estatisticas_periodo_12']; ?></div></td>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $array_meses_ano = array("01","02","03","04","05","06","07","08","09","10","11","12");
                                                        
                                        foreach($array_meses_ano as $mes_ano) {
                                                        
                                        $mes_ano = sprintf("%02s",$mes_ano);
                                                        
                                        $total_ouvintes_mes = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes_ano."'"));

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $total_ouvintes_mes; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                                          </td>
                                                        </tr>
                                                      </table>
                                        <?php } else if($estatistica == "3" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <?php if(is_numeric($mes)) { ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="40" align="center" class="texto_padrao_vermelho_destaque" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br><span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              01</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              02</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              03</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              04</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              05</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              06</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              07</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              08</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              09</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              10</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              11</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              12</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              13</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              14</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              15</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              16</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              17</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              18</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              19</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              20</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              21</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              22</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              23</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              24</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              25</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              26</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              27</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              28</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              29</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              30</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              31</td>
                                          </tr>
                                          <tr>
                                            <td height="25" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo ucfirst($lang['lang_info_estatisticas_legenda_minutos']); ?></td>
                                        <?php
                                        // Mes especifico

                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");

                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){

                                        $dia = sprintf("%02s",$i);          
                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                        $tempo_conectado_stat = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));
                                                        
                                        $media = ($tempo_conectado_stat["total_registros"] > 0) ? $tempo_conectado_stat["total_tempo"]/$tempo_conectado_stat["total_registros"] : '0';

                                        $media = $media/60;

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo round($media); ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <?php } else { ?>

                                        <?php
                                        // Todos os meses
                                        for($iMes=1;$iMes<=date("m");$iMes++){

                                        $mes = sprintf("%02s",$iMes);   
                                        ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="40" align="center" class="texto_padrao_vermelho_destaque" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br><span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              01</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              02</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              03</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              04</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              05</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              06</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              07</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              08</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              09</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              10</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              11</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              12</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              13</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              14</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              15</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              16</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              17</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              18</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              19</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              20</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              21</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              22</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              23</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              24</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              25</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              26</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              27</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              28</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              29</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              30</td>
                                            <td width="21" align="center" class="texto_padrao" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><span class="texto_padrao_pequeno">Dia</span><br>
                                              31</td>
                                          </tr>
                                          <tr>
                                            <td height="25" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo ucfirst($lang['lang_info_estatisticas_legenda_minutos']); ?></td>
                                        <?php
                                        $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");

                                        for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){

                                        $dia = sprintf("%02s",$i);          
                                        $data = $ano."-".$mes."-".$dia;
                                                        
                                        $tempo_conectado_stat = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data."'"));
                                                        
                                        $media = ($tempo_conectado_stat["total_registros"] > 0) ? $tempo_conectado_stat["total_tempo"]/$tempo_conectado_stat["total_registros"] : '0';

                                        $media = $media/60;

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo round($media); ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <?php } ?>
                                        <?php } ?>
                                                        </td>
                                                        </tr>
                                                      </table>
                                        <?php } else if($estatistica == "4" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_info_stats_paises']; ?></td>
                                        <?php
                                        $sql_paises = mysqli_query($conexao,"SELECT distinct(pais) as pais, count(pais) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND pais != 'Not found' GROUP by pais ORDER by pais ASC LIMIT 10");
                                        while ($dados_pais_ip = mysqli_fetch_array($sql_paises)) {

                                        if($dados_pais_ip["total"] > 1) {

                                        $pais = ($dados_pais_ip["pais"]) ? $dados_pais_ip["pais"] : "Not found";

                                        ?>
                                        <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $pais; ?></div></td>
                                        <?php } ?>
                                        <?php } ?>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $sql_paises = mysqli_query($conexao,"SELECT distinct(pais) as pais, count(pais) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND pais != 'Not found' GROUP by pais ORDER by codigo ASC LIMIT 10");
                                        while ($dados_pais_ip = mysqli_fetch_array($sql_paises)) {

                                        if($dados_pais_ip["total"] > 1) {

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $dados_pais_ip["total"]; ?></td>
                                        <?php } ?>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_info_stats_estados']; ?></td>
                                        <?php
                                        $sql_estados = mysqli_query($conexao,"SELECT distinct(estado) as estado, count(estado) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND estado != 'Not found' GROUP by estado ORDER by codigo ASC LIMIT 10");
                                        while ($dados_estado_ip = mysqli_fetch_array($sql_estados)) {

                                        if($dados_estado_ip["total"] > 1) {

                                        $estado = ($dados_estado_ip["estado"]) ? $dados_estado_ip["estado"] : "Not found";

                                        ?>
                                        <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $estado; ?></div></td>
                                        <?php } ?>
                                        <?php } ?>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $sql_estados = mysqli_query($conexao,"SELECT distinct(estado) as estado, count(estado) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND estado != 'Not found' GROUP by estado ORDER by codigo ASC LIMIT 10");
                                        while ($dados_estado_ip = mysqli_fetch_array($sql_estados)) {

                                        if($dados_estado_ip["total"] > 1) {

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $dados_estado_ip["total"]; ?></td>
                                        <?php } ?>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_info_stats_cidades']; ?></td>
                                        <?php
                                        $sql_cidades = mysqli_query($conexao,"SELECT distinct(cidade) as cidade, count(cidade) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND cidade != 'Not found' GROUP by cidade ORDER by codigo ASC LIMIT 10");
                                        while ($dados_cidade_ip = mysqli_fetch_array($sql_cidades)) {

                                        if($dados_cidade_ip["total"] > 1) {

                                        $cidade = ($dados_cidade_ip["cidade"]) ? $dados_cidade_ip["cidade"] : "Not found";

                                        ?>
                                        <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $cidade; ?></div></td>
                                        <?php } ?>
                                        <?php } ?>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $sql_cidades = mysqli_query($conexao,"SELECT distinct(cidade) as cidade, count(cidade) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND cidade != 'Not found' GROUP by cidade ORDER by codigo ASC LIMIT 10");
                                        while ($dados_cidade_ip = mysqli_fetch_array($sql_cidades)) {

                                        if($dados_cidade_ip["total"] > 1) {

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $dados_cidade_ip["total"]; ?></td>
                                        <?php } ?>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                                          </td>
                                                        </tr>
                                                      </table>
                                        <?php } else if($estatistica == "5" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_info_stats_players']; ?></td>
                                        <?php
                                        $sql_players = mysqli_query($conexao,"SELECT distinct(player) as player, count(player) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' GROUP by player ORDER by player ASC LIMIT 10");
                                        while ($dados_player_ip = mysqli_fetch_array($sql_players)) {

                                        if($dados_player_ip["total"] > 1) {

                                        $player = ($dados_player_ip["player"]) ? $dados_player_ip["player"] : "Not found";

                                        ?>
                                        <td width="55" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45"><?php echo $player; ?></div></td>
                                        <?php } ?>
                                        <?php } ?>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        $sql_players = mysqli_query($conexao,"SELECT distinct(player) as player, count(player) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' GROUP by player ORDER by player ASC LIMIT 10");
                                        while ($dados_player_ip = mysqli_fetch_array($sql_players)) {

                                        if($dados_player_ip["total"] > 1) {

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $dados_player_ip["total"]; ?></td>
                                        <?php } ?>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                                          </td>
                                                        </tr>
                                                      </table>
                                        <?php } else if($estatistica == "6" && $exibir == "texto") { ?>
                                        <table width="788" border="0" cellspacing="0" cellpadding="0" align="center">
                                                        <tr>
                                                          <td colspan="4" align="center">
                                        <?php if(is_numeric($mes)) { ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="300" height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br>
                                              <span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">00:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">01:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">02:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">03:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">04:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">05:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">06:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">07:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">08:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">09:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">10:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">11:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">12:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">13:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">14:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">15:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">16:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">17:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">18:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">19:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">20:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">21:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">22:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">23:00</div></td>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        // Mes especifico

                                        for($i=0;$i<=23;$i++){
                                                        
                                        $hora = sprintf("%02s",$i);
                                                        
                                        $total_ouvintes_hora = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data,hora FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND HOUR(hora) = '".$hora."'")); 

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $total_ouvintes_hora; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <?php } else { ?>
                                        <?php
                                        // Todos os meses
                                        for($iMes=1;$iMes<=date("m");$iMes++){

                                        $mes = sprintf("%02s",$iMes);   
                                        ?>
                                        <table width="780" border="0" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="300" height="60" align="center" class="texto_status_erro" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?><br>
                                              <span class="texto_padrao_vermelho"><?php echo $ano; ?></span></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">00:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">01:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">02:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">03:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">04:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">05:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">06:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">07:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">08:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">09:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">10:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">11:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">12:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">13:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">14:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">15:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">16:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">17:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">18:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">19:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">20:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">21:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">22:00</div></td>
                                            <td width="300" height="60" align="center" class="texto_padrao_destaque" style="border-top:#999999 1px solid;border-bottom:#999999 1px solid;border-right:#999999 1px solid;"><div class="rotate_45">23:00</div></td>
                                            </tr>
                                          <tr>
                                            <td height="35" class="texto_padrao_pequeno" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;border-left:#999999 1px solid;">&nbsp;<?php echo $lang['lang_info_estatisticas_total_ouvintes']; ?></td>
                                        <?php
                                        // Mes especifico

                                        for($i=0;$i<=23;$i++){
                                                        
                                        $hora = sprintf("%02s",$i);
                                                        
                                        $total_ouvintes_hora = mysqli_num_rows(mysqli_query($conexao,"SELECT codigo_stm,data,hora FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND HOUR(hora) = '".$hora."'")); 

                                        ?>
                                        <td align="center" style="border-bottom:#999999 1px solid;border-right:#999999 1px solid;" class="texto_padrao"><?php echo $total_ouvintes_hora; ?></td>
                                        <?php } ?>
                                          </tr>
                                        </table>
                                        <br />
                                        <?php } ?>
                                        <?php } ?>
                                                          </td>
                                                        </tr>
                                                      </table>
                                        <?php } ?>
								</div>
							</div>
						</div>
						 <?php } ?>
						<!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo $lang['lang_info_config_painel_idioma']; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<script src="/inc/js/theme.js"></script>
		<script src="/inc/theme-<?php echo $dados_stm["layout_painel"]; ?>.js"></script>
	  	<script>
	  	status_streaming('<?php echo $porta_code; ?>');
	  	setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
	  	</script>
	</body>
</html>