<?php
require_once("admin/inc/protecao-final.php");

@mysqli_query($conexao,"ALTER TABLE `playlists_agendamentos` ADD `finalizacao` CHAR(20) NOT NULL DEFAULT 'repetir';");
@mysqli_query($conexao,"ALTER TABLE `playlists_agendamentos` ADD `codigo_playlist_finalizacao` INT(10) NOT NULL DEFAULT '0';");
@mysqli_query($conexao,"ALTER TABLE `playlists_agendamentos` ADD `misturar_musicas` CHAR(3) NOT NULL DEFAULT 'nao';");
@mysqli_query($conexao,"ALTER TABLE `playlists_agendamentos` ADD `inicio` INT(1) NOT NULL DEFAULT '2';");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

if($_POST["cadastrar"]) {

$dados_playlist = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$_POST["codigo_playlist"]."'"));

list($hora,$minuto) = explode(":",$_POST["hora"]);
list($ano,$mes,$dia) = explode("-",$_POST["data"]);
$data_execussao = $ano."-".$mes."-".$dia;

if(@count($_POST["dias"]) > 0){
    $dias = implode(",",$_POST["dias"]);
}

mysqli_query($conexao,"INSERT INTO playlists_agendamentos (codigo_stm,codigo_playlist,frequencia,data,hora,minuto,dias,inicio,finalizacao,codigo_playlist_finalizacao,misturar_musicas) VALUES ('".$dados_stm["codigo"]."','".$_POST["codigo_playlist"]."','".$_POST["frequencia"]."','".$data_execussao."','".sprintf("%02d",$hora)."','".sprintf("%02d",$minuto)."','".$dias.",','".$_POST["inicio"]."','".$_POST["finalizacao"]."','".$_POST["codigo_playlist_finalizacao"]."','".$_POST["misturar_musicas"]."')");

// Cria o sessão do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_acao_gerenciador_agendamentos_resultado_ok'].'</div>';

header("Location: /gerenciar-agendamentos");
exit();
}

if($_POST["remover_logs"]) {
mysqli_query($conexao,"Delete From playlists_agendamentos_logs Where codigo_stm = '".$dados_stm["codigo"]."'");

// Cria o sessão do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_acao_gerenciador_agendamentos_resultado_remover_logs'].'</div>';

header("Location: /gerenciar-agendamentos");
exit();
}
?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Streaming <?php echo $dados_stm["porta"]; ?></title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/inc/ajax-streaming.js"></script>
		<script type="text/javascript" src="/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_stm["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<?php if($dados_revenda["url_logo"]) { ?>
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } else { ?>
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<?php } ?>
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo $lang['lang_info_gerenciador_agendamentos_tab_titulo']; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/dashboard">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo $lang['lang_info_gerenciador_agendamentos_tab_titulo']; ?></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
					<div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
					<div class="row">
						<!-- cards -->
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<table id="data_table1" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_horario_agendado']; ?></th>
                                                        <th class="nosort sorting_disabled" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_executar_acao']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM playlists_agendamentos where codigo_stm = '".$dados_stm["codigo"]."' ORDER by data DESC");
while ($dados_agendamento = mysqli_fetch_array($sql)) {

$dados_playlist = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$dados_agendamento["codigo_playlist"]."'"));

list($ano,$mes,$dia) = explode("-",$dados_agendamento["data"]);
$data = $dia."/".$mes."/".$ano;

if($dados_agendamento["frequencia"] == "1") {
$descricao = "".$lang['lang_info_gerenciador_agendamentos_info_frequencia1']." ".$data." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."";
} elseif($dados_agendamento["frequencia"] == "2") {
$descricao = "".$lang['lang_info_gerenciador_agendamentos_info_frequencia2']." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."";
} else {

$array_dias = explode(",",$dados_agendamento["dias"]);

foreach($array_dias as $dia) {

if($dia == "1") {
$dia_nome = "<font color='#003399'>".$lang['lang_label_segunda']."</font>";
} elseif($dia == "2") {
$dia_nome = "<font color='#FF0000'>".$lang['lang_label_terca']."</font>";
} elseif($dia == "3") {
$dia_nome = "<font color='#FF9900'>".$lang['lang_label_quarta']."</font>";
} elseif($dia == "4") {
$dia_nome = "<font color='#CC0066'>".$lang['lang_label_quinta']."</font>";
} elseif($dia == "5") {
$dia_nome = "<font color='#009900'>".$lang['lang_label_sexta']."</font>";
} elseif($dia == "6") {
$dia_nome = "<font color='#663300'>".$lang['lang_label_sabado']."</font>";
} elseif($dia == "7") {
$dia_nome = "<font color='#663399'>".$lang['lang_label_domingo']."</font>";
} else {
$dia_nome = "";
}

$lista_dias .= "".$dia_nome.", ";

}

$descricao = "".$lang['lang_info_gerenciador_agendamentos_info_frequencia3']." ".substr($lista_dias, 0, -2)." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."";
}

$agendamento_code = code_decode($dados_agendamento["codigo"],"E");

echo "<tr id='".$agendamento_code."'>
<td height='25' align='left' scope='col'>&nbsp;".$dados_playlist["nome"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$descricao."</td>
<td height='25' align='left' scope='col'><a href='javascript:remover_agendamento(\"".$agendamento_code."\");' data-toggle='tooltip' data-placement='bottom' title='".$lang['lang_info_gerenciador_agendamentos_acao_remover']."'><i class='fa fa-trash text-danger'></i></a></td>
</tr>";

unset($lista_dias);
unset($dia_nome);
}
?>
                                                </tbody>
                                            </table>
								</div>
							</div>
						</div>
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<form method="post" action="/gerenciar-agendamentos" name="agendamentos">
                                                <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                  <tr>
                                                    <td width="140" height="50" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></strong></td>
                                                    <td align="left">
                                                    <select name="codigo_playlist" id="codigo_playlist" class="form-control" style="width:100%;">
                                                    <?php
                                                    $query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
                                                    while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
                                                
                                                    $total_musicas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));
                                                    $duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

                                                    if($total_musicas > 0) {
                                                    echo '<option value="'.$dados_playlist["codigo"].'">'.$dados_playlist["nome"].' ('.gmdate("H:i:s", $duracao["total"]).')</option>';
                                                    } else {
                                                    echo '<option value="'.$dados_playlist["codigo"].'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_musicas'].')</option>';
                                                    }
                                                    }
                                                    ?>
                                                    </select>
                                                </td>
                                                  </tr>
                                                  <tr>
                                                    <td height="50" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_frequencias']; ?></strong></td>
                                                    <td align="left">
                                                    <select name="frequencia" id="frequencia" class="form-control" style="width:100%;" onchange="valida_opcoes_frequencia(this.value);">
                                                      <option value="1" selected="selected"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia1']; ?></option>
                                                      <option value="2"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia2']; ?></option>
                                                      <option value="3"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia3']; ?></option>
                                                    </select>
                                                </td>
                                                  </tr>
                                                  <tr>
                                                    <td height="50" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_data_inicio']; ?></strong></td>
                                                    <td align="left"><input class="form-control" id="data" name="data" type="date" style="width:200px;"></td>
                                                  </tr>
                                                  <tr>
                                                    <td height="50" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_horario_inicio']; ?></td>
                                                    <td align="left"><input class="form-control" id="hora" name="hora" type="time" style="width:200px;"></td>
                                                  </tr>                                                  
                                                  <tr>
                                                    <td height="35" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_dias_especificos']; ?></strong></td>
                                                    <td align="left">
                                                    <input name="dias[]" type="checkbox" value="1" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_segunda']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="2" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_terca']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="3" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_quarta']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="4" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_quinta']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="5" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_sexta']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="6" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_sabado']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="7" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_domingo']; ?></td>
                                                  </tr>
                                                  <tr>
                                                    <td height="35" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_inicio']; ?></strong></td>
                                                    <td align="left"><input type="radio" name="inicio" id="inicio" value="1" />&nbsp;<?php echo $lang['lang_info_gerenciador_agendamentos_inicio_imediato']; ?>&nbsp;&nbsp;
                                                      <input type="radio" name="inicio" id="inicio" value="2" checked="checked" />&nbsp;<?php echo $lang['lang_info_gerenciador_agendamentos_inicio_apos']; ?></td>
                                                  </tr>

      <tr>
        <td height="30" align="left" style="padding-left:5px;"><strong>Ordem M&uacute;sicas</strong></td>
        <td align="left" valign="middle" class="texto_padrao"><input type="radio" name="misturar_musicas" id="misturar_musicas" value="nao" checked="checked" />&nbsp;Seguir Ordem
          <input type="radio" name="misturar_musicas" id="misturar_musicas" value="sim" />&nbsp;Misturar</td>
      </tr>
      <tr>
        <td height="30" align="left" style="padding-left:5px;"><strong>Finaliza&ccedil;&atilde;o</strong></td>
        <td align="left" valign="middle" class="texto_padrao"><input type="radio" name="finalizacao" id="finalizacao" value="repetir" checked="checked" onclick="lista_playlist_finalizacao('nao')" />&nbsp;Repetir Músicas(loop)
          <input type="radio" name="finalizacao" id="finalizacao" value="iniciar_playlist" onclick="lista_playlist_finalizacao('sim')" />&nbsp;Iniciar Outra Playlist</td>
      </tr>
      <tr id="lista_playlist_finalizacao" style="display:none">
        <td width="160" height="30" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></strong></td>
        <td width="730" align="left">
        <select name="codigo_playlist_finalizacao" id="codigo_playlist_finalizacao" class="form-control" style="width:100%;">
        <?php
    $query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
    while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
  
    $total_musicas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));
    $duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

    if($total_musicas > 0) {
    echo '<option value="'.$dados_playlist["codigo"].'">'.$dados_playlist["nome"].' ('.sprintf('%02d:%02d:%02d', ($duracao["total"]/3600),($duracao["total"]/60%60), $duracao["total"]%60).')</option>';
    } else {
    echo '<option value="'.$dados_playlist["codigo"].'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_musicas'].')</option>';
    }
    }
        ?>
        </select>        </td>
      </tr>
                                                  <tr>
                                                    <td height="50" colspan="2" align="right"><input name="cadastrar" type="hidden" id="cadastrar" value="sim" /><button type="button" class="btn btn-info" onClick="document.agendamentos.submit();"><?php echo $lang['lang_botao_titulo_cadastrar']; ?></button></td>
                                                  </tr>
                                                </table>
                                            </form>
								</div>
							</div>
						</div>
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-header d-flex custom-card-header border-bottom-0 ">
										<h5 class="card-title"><?php echo $lang['lang_info_gerenciador_agendamentos_aba_logs']; ?></h5>
										<div class="card-options">
											<a href="javascript:void(0);" class="btn btn-danger btn-sm"><i class='fa fa-trash'></i> <?php echo $lang['lang_info_gerenciador_agendamentos_acao_remover']; ?> Logs</a>
										</div>
									</div>
								<div class="card-body">
									<form action="/gerenciar-agendamentos" method="post" name="form_remover_logs"><input name="remover_logs" type="hidden" value="sim" /></form>
									<table id="data_table2" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_logs_data']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_logs_playlist']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM playlists_agendamentos_logs WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo DESC LIMIT 100");
while ($dados_log_agendamento = mysqli_fetch_array($sql)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".formatar_data($dados_stm["formato_data"], $dados_log_agendamento["data"], $dados_stm["timezone"])."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_log_agendamento["playlist"]."</td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
								</div>
							</div>
						</div>
						<!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo $lang['lang_info_config_painel_idioma']; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<li class="col-lg-6 mb-2">
									<a href="/mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<!-- Internal Data tables -->
		<script src="/inc/plugins/datatable/js/jquery.dataTables.min.js"></script>
		<script src="/inc/plugins/datatable/js/dataTables.bootstrap5.js"></script>
		<script src="/inc/plugins/datatable/js/dataTables.buttons.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.bootstrap5.min.js"></script>
		<script src="/inc/plugins/datatable/js/jszip.min.js"></script>
		<script src="/inc/plugins/datatable/pdfmake/pdfmake.min.js"></script>
		<script src="/inc/plugins/datatable/pdfmake/vfs_fonts.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.html5.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.print.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.colVis.min.js"></script>
		<script src="/inc/plugins/datatable/dataTables.responsive.min.js"></script>
		<script src="/inc/plugins/datatable/responsive.bootstrap5.min.js"></script>
		<script src="/inc/js/table-data.js"></script>
		<!-- End Internal Data tables -->
		<script src="/inc/js/theme.js"></script>
		<script src="/inc/theme-<?php echo $dados_stm["layout_painel"]; ?>.js"></script>
	  	<script>
	  	status_streaming('<?php echo $porta_code; ?>');
	  	setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
        $(document).ready(function() {

            var table = $('#data_table1').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                "order": [],
                "aaSorting": []
            });
            $('#data_table1 tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });


            var table = $('#data_table2').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                "order": [],
                "aaSorting": []
            });
            $('#data_table2 tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });
        });
        function lista_playlist_finalizacao(opcao) {

if(opcao == "sim") {
document.getElementById('lista_playlist_finalizacao').style.display = 'table-row';
} else {
document.getElementById('lista_playlist_finalizacao').style.display = 'none';
}

}
	  	</script>
	</body>
</html>