<?php
ini_set("memory_limit", "256M");
ini_set("max_execution_time", 3600);

require_once("/home/painel/public_html/admin/inc/conecta.php");
require_once("/home/painel/public_html/admin/inc/funcoes.php");

$inicio_execucao = tempo_execucao();

/////////////////////////////////////////////
/////////// Limpeza de Playlists ////////////
/////////////////////////////////////////////

echo "--------------------------------------------------------------------\n";
echo "-Executando limpeza de playlists...\n";
echo "--------------------------------------------------------------------\n";

// Remove playlists cujo streaming já não existe mais
$query_playlists = mysqli_query($conexao,"SELECT * FROM playlists");
while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
	
	$verifica_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_playlist["codigo_stm"]."'"));
	
	if($verifica_stm == 0) {
		mysqli_query($conexao,"Delete From playlists where codigo = '".$dados_playlist["codigo"]."'");
		mysqli_query($conexao,"Delete From playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'");
	}

}

// Remove músicas cuja playlist já não existe mais
mysqli_query($conexao,"DELETE FROM playlists_musicas WHERE codigo_playlist = '0'");

$query_playlists_musica = mysqli_query($conexao,"SELECT * FROM playlists_musicas");
while ($dados_playlist_musica = mysqli_fetch_array($query_playlists_musica)) {

	$verifica_playlist = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$dados_playlist_musica["codigo_playlist"]."'"));
	
	if($verifica_playlist == 0) {
		mysqli_query($conexao,"Delete From playlists_musicas where codigo = '".$dados_playlist_musica["codigo"]."'");
	}

}

/////////////////////////////////////////////
////////////// Limpeza de Logs //////////////
/////////////////////////////////////////////

echo "--------------------------------------------------------------------\n";
echo "-Executando limpeza de logs...\n";
echo "--------------------------------------------------------------------\n";

$data1 = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-45, date("Y")));
$data2 = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-45, date("Y")));
$data3 = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-30, date("Y")));

mysqli_query($conexao,"Delete From logs WHERE data < '".$data1."'");

mysqli_query($conexao,"Delete From logs_streamings WHERE data < '".$data2."'");

mysqli_query($conexao,"Delete From logs_migracoes WHERE data < '".$data2."'");

mysqli_query($conexao,"Delete From playlists_agendamentos_logs WHERE data < '".$data3."'");

mysqli_query($conexao,"Delete From logs_monitoramento WHERE data < '".$data3."'");

/////////////////////////////////////////////
////////////// Limpeza de DJs ///////////////
/////////////////////////////////////////////

echo "--------------------------------------------------------------------\n";
echo "-Executando limpeza de Djs...\n";
echo "--------------------------------------------------------------------\n";

$query_djs = mysqli_query($conexao,"SELECT * FROM djs");
while ($dados_dj = mysqli_fetch_array($query_djs)) {

	$verifica_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_dj["codigo_stm"]."'"));
	
	if($verifica_stm == 0) {
		mysqli_query($conexao,"Delete From djs where codigo = '".$dados_dj["codigo"]."'");
	}

}

/////////////////////////////////////////////
///////// Limpeza de Estatísticas ///////////
/////////////////////////////////////////////

echo "--------------------------------------------------------------------\n";
echo "-Executando limpeza de estatísticas...\n";
echo "--------------------------------------------------------------------\n";

$query_stats = mysqli_query($conexao,"SELECT * FROM estatisticas");
while ($dados_stats = mysqli_fetch_array($query_stats)) {

	$verifica_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_stats["codigo_stm"]."'"));
	
	if($verifica_stm == 0) {
		mysqli_query($conexao,"Delete From estatisticas where codigo = '".$dados_stats["codigo"]."'");
	}

}

// Remove os registros anteriores a 1 ano
$data_ano = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-365, date("Y")));
mysqli_query($conexao,"Delete From estatisticas WHERE data < '".$data_ano."'");

/////////////////////////////////////////////
////////// Limpeza de Agendamentos //////////
/////////////////////////////////////////////

echo "--------------------------------------------------------------------\n";
echo "-Executando limpeza de agendamentos...\n";
echo "--------------------------------------------------------------------\n";

$query_agendamentos = mysqli_query($conexao,"SELECT * FROM playlists_agendamentos");
while ($dados_agendamento = mysqli_fetch_array($query_agendamentos)) {

	$verifica_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_agendamento["codigo_stm"]."'"));
	$verifica_playlist = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$dados_agendamento["codigo_playlist"]."'"));
	
	if($verifica_stm == 0) {
		mysqli_query($conexao,"Delete From playlists_agendamentos where codigo = '".$dados_agendamento["codigo"]."'");
	}
	
	if($verifica_playlist == 0) {
		mysqli_query($conexao,"Delete From playlists_agendamentos where codigo = '".$dados_agendamento["codigo"]."'");
	}

}

mysqli_query($conexao,"Delete From playlists_agendamentos where frequencia = '1' AND data < NOW()");

// Fim

$fim_execucao = tempo_execucao();

$tempo_execucao = number_format(($fim_execucao-$inicio_execucao),2);

echo "\n\n--------------------------------------------------------------------\n\n";
echo "Tempo de execução: ".$tempo_execucao." segundo(s);\n\n";
?>