#!/bin/sh

dominio_painel=$1
ip_mysql=$1
dominio_servidor=$2
porta_ssh_atual=$3
senha_root_atual=$4
senha_root_novo=$5
ip_atual=$6

if [ -z "$porta_ssh_atual" ]; then
porta_ssh_atual="6985"
fi

echo "**INICIADO**" > /home/auto-instalador-migrador-shoutcast.log

cd
wget -O sshpass-1.06.tar.gz http://$dominio_painel/sources-modulo-instalador/sshpass-1.06.tar.gz
tar -zxvf sshpass-1.06.tar.gz
cd sshpass-1.06/
./configure && make && make install

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Iniciando migracao..." >> /home/auto-instalador-migrador-shoutcast.log

systemctl stop httpd

# Migracao

cat << 'EOT' > /home/monitor-hd.sh
#!/bin/sh

while [ true ]; do
    cd /home/streaming
    du -ha --max-depth=0 | awk '{ print $1;}' > /home/espaco-usado-novo.log
    sleep 60
done
EOT

chmod 777 /home/monitor-hd.sh

nohup /home/monitor-hd.sh > /dev/null & echo $!

sshpass -p "$senha_root_atual" ssh -p $porta_ssh_atual -o StrictHostKeyChecking=no root@$ip_atual "cd /home/streaming;du -ha --max-depth=0" > /home/espaco-usado-atual.log

echo "**INICIADO-MIGRACAO**" >> /home/auto-instalador-migrador-shoutcast.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Iniciando migracao do conteudo(este processo pode levar um tempo)..." >> /home/auto-instalador-migrador-shoutcast.log

sshpass -p "$senha_root_atual" rsync --progress -rogpae "ssh -p $porta_ssh_atual -o StrictHostKeyChecking=no" root@$ip_atual:/etc/letsencrypt/ /etc/letsencrypt/
sshpass -p "$senha_root_atual" rsync --progress -rogpae "ssh -p $porta_ssh_atual -o StrictHostKeyChecking=no" root@$ip_atual:/etc/httpd/conf.d/ssl.conf /etc/httpd/conf.d/ssl.conf
sshpass -p "$senha_root_atual" rsync --progress -rogpae "ssh -p $porta_ssh_atual -o StrictHostKeyChecking=no" root@$ip_atual:/var/spool/cron/root /var/spool/cron/root
sshpass -p "$senha_root_atual" rsync --progress -rogpae "ssh -p $porta_ssh_atual -o StrictHostKeyChecking=no" root@$ip_atual:/etc/pure-ftpd/pureftpd-mysql.conf /etc/pure-ftpd/pureftpd-mysql.conf
sshpass -p "$senha_root_atual" rsync --progress -rogpae "ssh -p $porta_ssh_atual -o StrictHostKeyChecking=no" root@$ip_atual:/etc/pure-ftpd/pure-ftpd.conf /etc/pure-ftpd/pure-ftpd.conf
sshpass -p "$senha_root_atual" rsync --progress -rogpae "ssh -p $porta_ssh_atual -o StrictHostKeyChecking=no" root@$ip_atual:/etc/php.ini /etc/php.ini
sshpass -p "$senha_root_atual" rsync --progress -rogpae "ssh -p $porta_ssh_atual -o StrictHostKeyChecking=no" root@$ip_atual:/home/streaming/ /home/streaming/

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Migracao de conteudo concluida..." >> /home/auto-instalador-migrador-shoutcast.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Finalizando configuracao..." >> /home/auto-instalador-migrador-shoutcast.log

/bin/ps aux | /bin/grep 'monitor-hd.sh' | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -9

systemctl enable vnstat
systemctl enable pure-ftpd
systemctl enable httpd
systemctl enable crond

systemctl restart sshd
systemctl restart vnstat
systemctl restart httpd
systemctl restart crond
systemctl restart pure-ftpd

echo "[`date '+%d-%m-%Y %H:%M:%S'`] Validando instalacao..." >> /home/auto-instalador-migrador-shoutcast.log

status_apache=`lynx -head -dump http://localhost:555 | head -n 1 | awk {'print $2'}`

if [ $status_apache -ne 200 ]; then

echo "**ERRO**" >> /home/auto-instalador-migrador-shoutcast.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Erro iniciar apache! A instalacao foi concluida porem nao foi possivel iniciar o apache corretamente, por favor verifique acessando o servidor via SSH e executando comando: systemctl restart httpd" >> /home/auto-instalador-migrador-shoutcast.log

exit 1

fi


echo "**CONCLUIDO-MIGRACAO**" >> /home/auto-instalador-migrador-shoutcast.log
echo >> /home/auto-instalador-migrador-shoutcast.log
echo "[`date '+%d-%m-%Y %H:%M:%S'`] Migracao do servidor $dominio_servidor concluida com sucesso!" >> /home/auto-instalador-migrador-shoutcast.log
echo >> /home/auto-instalador-migrador-shoutcast.log
rm -f /home/auto-instalador-migrador-shoutcast.sh