<?php
require_once("inc/protecao-admin.php");

if($dados_config["idioma_painel"] == "pt-br") {
$lang_sortable = "Portuguese-Brasil";
} elseif($dados_config["idioma_painel"] == "en-us") {
$lang_sortable = "English";
} else {
$lang_sortable = "Spanish";
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Administra&ccedil;&atilde;o</title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">  
  <?php if($dados_revenda["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico" />
  <script type="text/javascript" src="/admin/inc/ajax.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>
<body>
  <div class="container-scroller">
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Administra&ccedil;&atilde;o</span></a>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><i class="fa fa-lock text-yellow"></i></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav mr-lg-2">
          <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        </ul>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>
    <div class="container-fluid page-body-wrapper">
      <nav class="sidebar sidebar-offcanvas" id="sidebar">
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-streamings">
              <i class="fa fa-headphones text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_streaming; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-revendas">
              <i class="fa fa-users text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_revenda; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-servidores">
              <i class="fa fa-tasks text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_servidor; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-avisos">
              <i class="fa fa-info-circle text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_avisos; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-tutoriais">
              <i class="fa fa-life-bouy text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_tutoriais; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-apps">
              <i class="fa fa-android text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_apps; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-logs-acoes">
              <i class="fa fa-file-text-o text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_logs_acoes; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-backup">
              <i class="fa fa-shield text-icones"></i>
              <span class="menu-title">Backup</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-estatisticas">
              <i class="fa fa-bar-chart-o text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_estatisticas; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-configuracoes">
              <i class="fa fa-cog text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_configuracoes; ?></span>
            </a>
          </li>   
        </ul>
      </nav>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_pagina_revendas_titulo; ?></header>
                                        <div class="card-header-right">
                                            <button type="button" class="btn btn-info" onClick="window.location = '/admin/admin-cadastrar-revenda';"><i class="fa fa-file-plus"></i><?php echo lang_botao_titulo_cadastrar; ?></button>
                                        </div>
                  </div>
                <div class="card-body">
                    <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_revendas_responsavel; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_revendas_plano; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_revendas_streamings; ?></th>
                                                        <th><?php echo lang_pagina_revendas_acoes; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php

if(query_string('2') == 'resultado') {

if(preg_match("/@/i",query_string('3'))) {
$query = "SELECT * FROM revendas where email like '%".query_string('3')."%'";
} else {
$query = "SELECT * FROM revendas where (nome like '%".query_string('3')."%' AND tipo = '1') OR id = '".query_string('3')."'";
}

} else {
$query = "SELECT * FROM revendas where tipo = '1'";
}

$sql = mysqli_query($conexao,"".$query." ORDER by nome ASC");
while ($dados_revenda = mysqli_fetch_array($sql)) {

$total_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_revenda["codigo"]."'"));

$limite_subrevendas = ($dados_revenda["subrevendas"] == 999999) ? "Ilimitado" : $dados_revenda["subrevendas"];
$limite_streamings = ($dados_revenda["streamings"] == 999999) ? "Ilimitado" : $dados_revenda["streamings"];
$limite_espectadores = ($dados_revenda["espectadores"] == 999999) ? "Ilimitado" : $dados_revenda["espectadores"];

if($dados_revenda["status"] > 1) {
$cor_status = "class='table-danger'";
}

$revenda_code = code_decode($dados_revenda["codigo"],"E");

echo "<tr id='".$revenda_code."' ".$cor_status.">
<td height='25' align='left' scope='col'>&nbsp;".$dados_revenda["nome"]." - ".$dados_revenda["id"]."&nbsp;</td>
<td height='25' align='left' scope='col'>&nbsp;".$limite_subrevendas." / ".$limite_streamings." / ".$limite_espectadores." / ".$dados_revenda["bitrate"]." Kbps / ".tamanho($dados_revenda["espaco"])."</td>
<td height='25' align='center' scope='col'>&nbsp;".$total_stm."</td>
<td height='25' align='left' scope='col'><a href='javascript:acessar_painel_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_acessar_painel."'><i class='fa fa-home f-16 text-pink'></i></a>&nbsp;<a href='/admin/admin-configurar-revenda/".$revenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_configuracao."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='/admin/admin-streamings/resultado-revenda/".$revenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_listar_streamings."'><i class='fa fa-video-camera f-16 text-green'></i></a>&nbsp;
<a href='javascript:alterar_senha_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_senha."'><i class='fa fa-lock f-16 text-yellow'></i></a>&nbsp;
<a href='javascript:bloquear_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings/".$revenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings."'><i class='fa fa-retweet f-16 text-pink'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings-servidor/".$revenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings_servidor."'><i class='fa fa-retweet f-16 text-purple'></i></a>&nbsp;
<a href='javascript:remover_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_remover."'><i class='fa fa-trash-o f-16 text-red'></i></a>&nbsp;</td>
</tr>";

unset($cor_status);

// Verifique se tem subrevenda e lista
$total_subrevendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));

if($total_subrevendas > 0) {

$sql_subrevenda = mysqli_query($conexao,"SELECT * FROM revendas where codigo_revenda = '".$dados_revenda["codigo"]."' ORDER by id ASC");
while ($dados_subrevenda = mysqli_fetch_array($sql_subrevenda)) {

$total_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_subrevenda["codigo"]."'"));

$limite_subrevendas = ($dados_subrevenda["subrevendas"] == 999999) ? "Ilimitado" : $dados_subrevenda["subrevendas"];
$limite_streamings = ($dados_subrevenda["streamings"] == 999999) ? "Ilimitado" : $dados_subrevenda["streamings"];
$limite_espectadores = ($dados_subrevenda["espectadores"] == 999999) ? "Ilimitado" : $dados_subrevenda["espectadores"];

if($dados_subrevenda["status"] > 1) {
$cor_status = "class='table-danger'";
}

$subrevenda_code = code_decode($dados_subrevenda["codigo"],"E");

echo "<tr id='".$subrevenda_code."' ".$cor_status.">
<td align='left' scope='col'><i class='fa fa-chevron-right f-12 text-blue' style='padding-left:20px'></i>&nbsp;".$dados_subrevenda["nome"]." - ".$dados_subrevenda["id"]."</td>
<td align='left' scope='col'>&nbsp;".$limite_subrevendas." / ".$limite_streamings." / ".$limite_espectadores." / ".$dados_subrevenda["bitrate"]." Kbps / ".tamanho($dados_subrevenda["espaco"])."</td>
<td align='center' scope='col'>&nbsp;".$total_stm."</td>
<td height='25' align='left' scope='col'><a href='javascript:acessar_painel_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_acessar_painel."'><i class='fa fa-home f-16 text-pink'></i></a>&nbsp;<a href='/admin/admin-configurar-revenda/".$subrevenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_configuracao."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='/admin/admin-streamings/resultado-revenda/".$subrevenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_listar_streamings."'><i class='fa fa-video-camera f-16 text-green'></i></a>&nbsp;
<a href='javascript:alterar_senha_revenda(\"".$subrevenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_senha."'><i class='fa fa-lock f-16 text-yellow'></i></a>&nbsp;
<a href='javascript:bloquear_revenda(\"".$subrevenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_revenda(\"".$subrevenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings/".$subrevenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings."'><i class='fa fa-retweet f-16 text-pink'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings-servidor/".$subrevenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings_servidor."'><i class='fa fa-retweet f-16 text-purple'></i></a>&nbsp;
<a href='javascript:remover_revenda(\"".$subrevenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_remover."'><i class='fa fa-trash-o f-16 text-red'></i></a>&nbsp;</td>
</tr>";

// Verifique se tem subrevenda e lista
$total_subrevendas_sub = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_subrevenda["codigo"]."'"));

if($total_subrevendas_sub > 0) {

$sql_subrevenda_sub = mysqli_query($conexao,"SELECT * FROM revendas where codigo_revenda = '".$dados_subrevenda["codigo"]."' ORDER by id ASC");
while ($dados_subrevenda_sub = mysqli_fetch_array($sql_subrevenda_sub)) {

$total_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_subrevenda_sub["codigo"]."'"));

$limite_subrevendas = ($dados_subrevenda_sub["subrevendas"] == 999999) ? "Ilimitado" : $dados_subrevenda_sub["subrevendas"];
$limite_streamings = ($dados_subrevenda_sub["streamings"] == 999999) ? "Ilimitado" : $dados_subrevenda_sub["streamings"];
$limite_espectadores = ($dados_subrevenda_sub["espectadores"] == 999999) ? "Ilimitado" : $dados_subrevenda_sub["espectadores"];

if($dados_subrevenda["status"] > 1) {
$cor_status = "class='table-danger'";
}

$subrevenda_sub_code = code_decode($dados_subrevenda_sub["codigo"],"E");

echo "<tr id='".$subrevenda_sub_code."' ".$cor_status.">
<td align='left' scope='col'><i class='fa fa-long-arrow-right f-12 text-blue' style='padding-left:25px'></i>&nbsp;".$dados_subrevenda_sub["nome"]." - ".$dados_subrevenda_sub["id"]."</td>
<td align='left' scope='col'>&nbsp;".$limite_subrevendas." / ".$limite_streamings." / ".$limite_espectadores." / ".$dados_subrevenda_sub["bitrate"]." Kbps / ".tamanho($dados_subrevenda_sub["espaco"])."</td>
<td align='center' scope='col'>&nbsp;".$total_stm."</td>
<td height='25' align='left' scope='col'><a href='javascript:acessar_painel_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_acessar_painel."'><i class='fa fa-home f-16 text-pink'></i></a>&nbsp;<a href='/admin/admin-configurar-revenda/".$subrevenda_sub_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_configuracao."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='/admin/admin-streamings/resultado-revenda/".$subrevenda_sub_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_listar_streamings."'><i class='fa fa-video-camera f-16 text-green'></i></a>&nbsp;
<a href='javascript:bloquear_revenda(\"".$subrevenda_sub_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_revenda(\"".$subrevenda_sub_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings/".$subrevenda_sub_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings."'><i class='fa fa-retweet f-16 text-pink'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings-servidor/".$subrevenda_sub_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings_servidor."'><i class='fa fa-retweet f-16 text-purple'></i></a>&nbsp;
<a href='javascript:remover_revenda(\"".$subrevenda_sub_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_remover."'><i class='fa fa-trash-o f-16 text-red'></i></a>&nbsp;</td>
</tr>";

unset($cor_status);
}
}

}
}

}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
      <!-- modal -->                
        <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                  <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
              </div>
          </div>
        </div>

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  }); 
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "aaSorting": [],
                "order": [],
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });  
  </script>
</body>
</html>