package org.farng.mp3;

import java.io.*;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

import com.wowza.io.IRandomAccessReader;
import com.wowza.wms.logging.WMSLoggerFactory;

public class RandomAccessFile implements Closeable, DataInput, DataOutput
{
	//private java.io.RandomAccessFile randomFile = null;
	private IRandomAccessReader randomAccessReader = null;
	private byte[] buffer = new byte[16];
	private ByteBuffer tmpBuffer;
	
	public RandomAccessFile(File file, String mode) throws FileNotFoundException
	{
		//this.randomFile = new java.io.RandomAccessFile(file, mode);
	}
	
	public RandomAccessFile(String name, String mode) throws FileNotFoundException
	{
		//this.randomFile = new java.io.RandomAccessFile(name, mode);
	}
	
	public RandomAccessFile(IRandomAccessReader randomAccessReader)
	{
		this.randomAccessReader = randomAccessReader;
		this.tmpBuffer = ByteBuffer.wrap(buffer);
	}
	
	public boolean readBoolean() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 1);
		return buffer[0] != 0;
	}

	public byte readByte() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 1);
		return buffer[0];
	}

	public char readChar() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 1);
		return (char)buffer[0];
	}

	public double readDouble() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 8);
		tmpBuffer.position(0);
		return tmpBuffer.getDouble();
	}

	public float readFloat() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 4);
		tmpBuffer.position(0);
		return tmpBuffer.getFloat();
	}

	public void readFully(byte[] b, int off, int len) throws IOException
	{
		this.randomAccessReader.read(b, off, len);
	}

	public void readFully(byte[] b) throws IOException
	{
		this.randomAccessReader.read(b, 0, b.length);
	}

	public int readInt() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 4);
		tmpBuffer.position(0);
		return tmpBuffer.getInt();
	}

	public String readLine() throws IOException
	{
		doStackTrace();
		return "";
	}

	public long readLong() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 8);
		tmpBuffer.position(0);
		return tmpBuffer.getLong();
	}

	public short readShort() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 2);
		tmpBuffer.position(0);
		return tmpBuffer.getShort();
	}

	public int readUnsignedByte() throws IOException
	{
		doStackTrace();
		return 0;
	}

	public int readUnsignedShort() throws IOException
	{
		doStackTrace();
		return 0;
	}

	public String readUTF() throws IOException
	{
		doStackTrace();
		return "";
	}
	
	public void close() throws IOException
	{
	}

	public long getFilePointer() throws IOException
	{
		return this.randomAccessReader.getFilePointer();
	}

	public long length() throws IOException
	{
		//System.out.println("RandomAccessFile: length: "+this.randomAccessReader.length());
		return this.randomAccessReader.length();
	}

	public int read() throws IOException
	{
		this.randomAccessReader.read(buffer, 0, 1);
		return buffer[0];
	}

	public int read(byte[] b, int off, int len) throws IOException
	{
		//System.out.println("RandomAccessFile: read: "+len);
		return this.randomAccessReader.read(b, off, len);
	}

	public int read(byte[] b) throws IOException
	{
		return this.randomAccessReader.read(b, 0, b.length);
	}

	public void seek(long pos) throws IOException
	{
		this.randomAccessReader.seek(pos);
	}

	public void setLength(long newLength) throws IOException
	{
		doStackTrace();
	}

	public int skipBytes(int n) throws IOException
	{
		long savePos = this.randomAccessReader.getFilePointer();
		this.randomAccessReader.seek(savePos + n);
		return (int)(this.randomAccessReader.getFilePointer() - savePos);
	}

	public void write(byte[] b, int off, int len) throws IOException
	{
		doStackTrace();
	}

	public void write(byte[] b) throws IOException
	{
		doStackTrace();
	}

	public void write(int b) throws IOException
	{
		doStackTrace();
	}
	
	public FileDescriptor getFD() throws IOException
	{
		doStackTrace();
		return null;
	}
	
	public FileChannel getChannel()
	{
		doStackTrace();
		return null;
	}

	public void writeBoolean(boolean v) throws IOException
	{
		doStackTrace();
	}

	public void writeByte(int v) throws IOException
	{
		doStackTrace();
	}

	public void writeBytes(String s) throws IOException
	{
		doStackTrace();
	}

	public void writeChar(int v) throws IOException
	{
		doStackTrace();
	}

	public void writeChars(String s) throws IOException
	{
		doStackTrace();
	}

	public void writeDouble(double v) throws IOException
	{
		doStackTrace();
	}

	public void writeFloat(float v) throws IOException
	{
		doStackTrace();
	}

	public void writeInt(int v) throws IOException
	{
		doStackTrace();
	}

	public void writeLong(long v) throws IOException
	{
		doStackTrace();
	}

	public void writeShort(int v) throws IOException
	{
		doStackTrace();
	}

	public void writeUTF(String str) throws IOException
	{
		doStackTrace();
	}
	
	// We expect tmp may only be null, so suppress the warning
	@SuppressWarnings("null")
    public void doStackTrace()
	{
		try
		{
			String tmp = null;
			tmp.substring(12);
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(RandomAccessFile.class).error("RandomAccessFile: doStackTrace ", e);
			e.printStackTrace();
		}
	}
}
