<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h5>Software Requirements</h5>
<p>To configure Microsoft PlayReady encryption services using the BuyDRM KeyOS key management system, you must have a BuyDRM account.</p>

<p>Wowza DRM is required. If you purchased a license for Wowza media server software before January&nbsp;1,&nbsp;2015, contact <a href="mailto:sales@wowza.com">sales@wowza.com</a> to learn more about how to license Wowza DRM.</p>

<h5>BuyDRM User Key</h5>
<p>Enter the BuyDRM user key that's associated with your BuyDRM account.</p>

<h5>Stream Protection</h5>
<p>Select the streaming formats that you want to encrypt using the BuyDRM encryption service. BuyDRM KeyOS provides Microsoft PlayReady encryption services for MPEG-DASH, Apple HLS, and Microsoft Smooth Streaming.</p>

<h5>Stream Name Mapping</h5>
<p>Specify the live or on demand sources to be encrypted by mapping stream names (for live sources) or file names (for on demand sources) to PlayReady key information that's used for encryption.</p>

<p>In <strong>Stream Name</strong>, you can use simple stream names or full file names to specify individual source items for encryption or wildcards to map multiple source items for encryption. The stream name value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters. You must match each <strong>Stream Name</strong> entry to the following ID values:</p>
<ul>
	<li><strong>Key ID</strong>. The Microsoft PlayReady key ID.
	<li><strong>Content ID</strong>. The BuyDRM content ID.
	<li><strong>Media ID</strong>. The BuyDRM media ID.
</ul>

<p>For more information about additional values that you can use in these fields, see <a href="https://www.wowza.com/docs/how-to-set-up-and-test-buydrm-keyos-drm-playready#buydrmstreammap" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Map file details (buydrmstreammap.txt)</a>.</p>

<p>When a new stream is started or played, the server searches for the stream name and encryption is applied if a match is found in the mapping file.</p>

<h5>Playing Encrypted Streams</h5>
<p>When you create an account with BuyDRM, you'll get BuyDRM KeyOS licensing documentation that describes how to enable playback of encrypted content, along with the BuyDRM and Smooth Streaming sample players. For more information, see <a href="https://www.wowza.com/docs/how-to-set-up-and-test-buydrm-keyos-drm-playready#buydrmplayback" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Playing the Encrypted Streams</a>.</p>