<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}&vhost=${wmsutil:urlEncode(vhost)}&streamName=${wmsutil:urlEncode(streamName)}
</c:set>
<wmsform:setpagetitle page="incomingstream_details" appName="${appName}"/>
<wmsdialog:pantiltzoom page="appconfig.incomingstreams"/>

<c:set var="instanceName" value="${requestScope.formData['instanceName']}"/>
<c:set var="streamName" value="${requestScope.formData['streamName']}"/>
<c:set var="recorderName" value="${requestScope.formData['recorderName']}"/>
<c:set var="streamState" value="${requestScope.formData['streamState']}"/>
<c:set var="managedStream" value="${requestScope.formData['managedStream']}"/>
<c:set var="recordingSet" value="${requestScope.formData['recordingSet']}"/>
<c:set var="streamConfig" value="${requestScope.formData['streamConfig']}"/>
<c:set var="streamStats" value="${requestScope.formData['streamStats']}"/>
<c:set var="ptzEnabled" value="${requestScope.formData['ptzEnabled']}"/>
<c:set var="refreshRate" value="${requestScope.formData['sourceControlImageRefreshRate']}"/>
<c:set var="refreshMinimumRate" value="${requestScope.formData['sourceControlImageRefreshMinimumRate']}"/>

<c:set var="pagename">
	<wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="head"/>${wmsutil:escapeHtml(streamName)}
</c:set>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<div class="col-md-5">
			<happ>${wmsutil:escapeHtml(appName)} ${pagename}</happ>
			<br> <small class="text-muted"><wmsform:objvalue page="appConfig" obj="uiAppType" /></small>
		</div>
		<wmsform:applicationbuttons page="${page}" streamName="${wmsutil:urlEncode(streamName)}" instanceName="${wmsutil:urlEncode(instanceName)}" />
	</div>
	<p><a onclick="javascript:loadApplication('${wmsutil:escapeHtml(appName)}', '${appType}', 'incomingstreams')"><i class="fa fa-arrow-left"></i> Return to Incoming Streams Page</a></p>
	<hr />
	<div class="row">
		<div class="col-md-8 main-content">
			<wmsform:rightrailhideshow />
			<form:form method="post" commandName="formData" id="defaultForm">
				<wmsform:errors path="errorMessage" cssClass="alert alert-danger" />
				<wmsform:button page="common" cssClass="btn btn-default"
					onClick="javascript:loadIncomingStreamDetails('${wmsutil:escapeHtml(appName)}','${appType}','incomingstreams_details','${wmsutil:escapeHtml(instanceName)}','${wmsutil:escapeHtml(streamName)}')"
					obj="refresh" icon="fa fa-repeat" />
				<sec:authorize access="hasAnyRole('admin')">
					<c:choose>
						<c:when test="${recordingSet=='false'}">
						 <wmsform:button page="appconfig.incomingstreams.details" cssClass="btn btn-default" onClick="javascript:startRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instanceName)}', '${wmsutil:escapeHtml(streamName)}')" obj="record" icon="fa fa-circle text-danger"/>
						</c:when>
						<c:otherwise>
							<wmsform:button page="appconfig.incomingstreams.details" cssClass="btn btn-default" onClick="javascript:stopRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instanceName)}', '${wmsutil:escapeHtml(recorderName)}')" obj="stopRecording" icon="fa fa-stop"/>
							<c:if test="${streamState=='Recording in Progress'}">
								<wmsform:button page="appconfig.incomingstreams.details" cssClass="btn btn-default" onClick="javascript:splitRecordingShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instanceName)}', '${wmsutil:escapeHtml(recorderName)}')" obj="splitRecording" icon="fa fa-code-fork"/>
							</c:if>
						</c:otherwise>
					</c:choose>
					<c:if test="${managedStream=='true'}">
						<wmsform:button page="appconfig.incomingstreams.details" onClick="javascript:disconnectStreamShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instanceName)}', '${wmsutil:escapeHtml(streamName)}')" obj="disconnect" icon="fa fa-times"/>
						<wmsform:button page="appconfig.incomingstreams.details" onClick="javascript:resetStreamShow('${wmsutil:escapeHtml(appName)}', '${wmsutil:escapeHtml(instanceName)}', '${wmsutil:escapeHtml(streamName)}')" obj="reset" icon="fa fa-sign-in"/>
						<c:if test="${ptzEnabled=='true'}">
							<wmsform:button page="appconfig.incomingstreams.details" onClick="javascript:showPTZ('${appName}', '${instanceName}', '${streamName}', '${refreshRate}', '${refreshMinimumRate}')" obj="PtzButton" icon="fa fa-arrows" cssClass="btn btn-default"/>
						</c:if>
					</c:if>
				</sec:authorize>
				<hr />

				<div id="app-monitoring-now">
					<div class="row">
						<div class="col-md-6">
							<h4>
								<wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="connections"/>
							</h4>
							<div class="row">
								<div class="col-md-6">
									<table class="table table-condensed table-hover">
										<tr>
											<td><strong><wmsform:getlocalestring page="common" obj="total"/></strong></td>
											<td><strong><span
													class="app-connection-count pull-right"
													id="app-total-connections">${streamStats.totalConnections}</span></strong></td>
										</tr>
										<tr>
											<td><wmsform:getlocalestring page="common" obj="adobeHDS"/></td>
											<td><span class="app-connection-count pull-right"
												id="app-sanjose-connections">${streamStats.connectionCount.SANJOSE}</span></td>
										</tr>
										<tr>
											<td><wmsform:getlocalestring page="common" obj="adobeRTMP"/></td>
											<td><span class="app-connection-count pull-right"
												id="app-rtmp-connections">${streamStats.connectionCount.RTMP}</span></td>
										</tr>
										<tr>
											<td><wmsform:getlocalestring page="common" obj="appleHLS"/></td>
											<td><span class="app-connection-count pull-right"
												id="app-cupertino-connections">${streamStats.connectionCount.CUPERTINO}</span></td>
										</tr>
										<tr>
											<td><wmsform:getlocalestring page="common" obj="microsoftSmooth"/></td>
											<td><span class="app-connection-count"
												id="app-smooth-connections">${streamStats.connectionCount.SMOOTH}</span></td>
										</tr>
										<td><wmsform:getlocalestring page="common" obj="mpegDash"/></td>
										<td><span class="app-connection-count"
											id="app-dash-connections">${streamStats.connectionCount.MPEGDASH}</span></td>
										</tr>
										<tr>
											<td><wmsform:getlocalestring page="common" obj="rtspRtp"/></td>
											<td><span class="app-connection-count"
												id="app-rtp-connections">${streamStats.connectionCount.RTP}</span></td>
										</tr>
									</table>
								</div>
								<div class="col-md-6">
									<div id="piecharts" style="height: 180px; margin-top: 40px;"
										class="wowza-pie-charts"></div>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<h4><wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="streamUptime" /></h4>
							<div id="uptime-time-up-label">
								<p>
									<strong>${wmsutil:escapeHtml(streamName)}</strong> <wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="upSince" /> <span
										id="uptime-time"></span>
								</p>
							</div>
							<div id="uptime-time-down-label">
								<p>
									<strong>${wmsutil:escapeHtml(streamName)}</strong> <wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="notRunning" /></span>
								</p>
							</div>
							<div id="uptime-pretty-up-label">
								<p>
									<strong>${wmsutil:escapeHtml(streamName)}</strong> <wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="upAbout" />
									<span id="uptime-pretty"></span>
								</p>
							</div>
							<div id="uptime-pretty-down-label">
								<p>
									<strong>${wmsutil:escapeHtml(streamName)}</strong> <wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="notRunning" />
								</p>
							</div>
							<h4><wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="network" /></h4>
							<p>
								<strong><wmsform:getlocalestring page="common" obj="bytesIn" /></strong> <span id="bytes-in">${streamStats.bytesIn}</span>
								&nbsp;@&nbsp; <span id="bytes-in-rate" style="display: inline;">${streamStats.bytesInRate}</span>
							</p>
							<p>
								<strong><wmsform:getlocalestring page="common" obj="bytesOut" /></strong> <span id="bytes-out">${streamStats.bytesOut}</span>
								&nbsp;@&nbsp; <span id="bytes-out-rate" style="display: inline;">${streamStats.bytesOutRate}</span>
							</p>
						</div>
					</div>
					<hr />
				</div>

				<c:choose>
					<c:when test="${streamState=='Recording in Progress'}">
						<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="streamState" icon="fa fa-circle" iconClass="text-danger" />
					</c:when>
					<c:when test="${streamState=='Waiting for stream'}">
						<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="streamState" icon="fa fa-time" />
					</c:when>
					<c:when test="${streamState=='Recorder error'}">
						<div class="text-danger">
							<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="streamState" icon="fa fa-exclamation-circle" iconClass="text-danger" />
							<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="errorString" showTitle="false" />
						</div>
					</c:when>
					<c:otherwise>
						<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="streamState" icon="fa fa-arrow-right fa-fw" />
					</c:otherwise>
				</c:choose>

				<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="sourceIp" />
				<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="instanceName" />

				<c:if test="${recordingSet==true}">
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="currentFile" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="currentDuration" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="currentSize" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="segmentationType" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="recorderInfoDetails" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="recordingStartTime" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="outputPath" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="baseFile" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="fileTemplate" />
					<wmsform:viewproperty page="appconfig.incomingstreams.details" obj="fileVersionDelegateName" />
				</c:if>

				<wmsform:startrecording page="appconfig.incomingstreams.details" />
				<wmsdialog:stoprecording page="appconfig.incomingstreams.details" />
				<wmsdialog:splitrecording page="appconfig.incomingstreams.details" />
				<wmsdialog:resetstream page="appconfig.incomingstreams.details" />
				<wmsdialog:disconnectstream page="appconfig.incomingstreams.details" />
			</form:form>
			<div class="hidden-sm hidden-xs">
				<div id="streameditNote" class="well">
					<wmsform:getlocalestring page="appconfig.incomingstreams.details" obj="editText" />
				</div>
			</div>
		</div>
		<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
	    	<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
		</div>
	</div>
</div>
<script language="javascript">
$(document).ready(function() {
	console.log("streamname:${streamName}");

	// this is here because when we added PTZ support, we now jump from one section to another without user interactions.
	// typically, the user selects which app section they are in then drills down, now when they finish some "Sources (Live)" connecions 
	// we jump from "Sources (Live)" in the sidebar to "Incoming Streams" and have the new streams incoming details shown.
	// so we now have to update the side bar if we did this.
	
	// Set the parent page so query params in IncomingStreamDetailsController are satisfied. always do it here rather than from all other 
	// pages we can get to from this pages 
	incomingStreamDetailsParentPage="incomingstreams";
	
	if ("${updateSB}"=='true')
	{
		// remove the orange hightlight from the publishers section
		var publisherSB = document.getElementById("appName="+lastApplication+":publishers");
		publisherSB.className = publisherSB.className.replace('-active','');

		// add the orange hightlight to the incomingstreams section
		var incomingSB = document.getElementById("appName="+lastApplication+":incomingstreams");
		incomingSB.className = incomingSB.className + "-active";

		// update the url in the browser bar
		location.hash="#application/${vhost}/${appName}/${appType}/incomingstreams_details/&instance=${instanceName}&stream=${streamName}&returnPage=incomingstreams";
	}

	var sIp = $("#sourceIpValue").text().trim();
	if ((sIp == "none") || (sIp == "local (Transcoder)"))
		$("#streameditNote").hide();

	if(isNaN("${streamStats.uptime}")||"${streamStats.uptime}"==0) {
		$("#uptime-pretty").html("not running");
		$("#uptime-time").html("not running");
		$("#uptime-time-up-label").hide();
		$("#uptime-pretty-up-label").hide();
		$("#uptime-time-down-label").show();
		$("#uptime-pretty-down-label").show();
	} else {
		$("#uptime-time-down-label").hide();
		$("#uptime-pretty-down-label").hide();
		$("#uptime-time-up-label").show();
		$("#uptime-pretty-up-label").show();
		WOWZA.Util.setUptimeSeconds("${streamStats.uptime}"*1000, "#uptime-pretty", "#uptime-time",false);
	}
 	var pieData = {
		connections:{label: "",
			data: [
			 {label:"HDS", data: "${streamStats.connectionCount.SANJOSE}"},
			 {label:"RTMP", data: "${streamStats.connectionCount.RTMP}"},
			 {label:"HLS", data: "${streamStats.connectionCount.CUPERTINO}"},
			 {label:"DASH", data: "${streamStats.connectionCount.MPEGDASH}"},
			 {label:"Smooth", data: "${streamStats.connectionCount.SMOOTH}"},
			 {label:"RTSP/RTP", data: "${streamStats.connectionCount.RTP}"}
			 ]
		}
	};
	var pies = WOWZA.Charts.Pie("piecharts", pieData,{legend: {
		show: false
	},
	colors: WOWZA.Util.FlotColors, classes:"col-md-12"});
	$("#bytes-in-rate").html(WOWZA.Util.HumanReadableBits("${streamStats.bytesInRate}"*8, 'bits/s'));
	$("#bytes-out-rate").html(WOWZA.Util.HumanReadableBits("${streamStats.bytesOutRate}"*8, 'bits/s'));
});

function showPTZ(appName, instanceName, streamName, refreshRate, refreshMinimumRate)
{
	var streamName2 = streamName.substring(0,streamName.indexOf(".stream"));
	panTiltZoomShow(appName,instanceName, streamName2, refreshRate, refreshMinimumRate);
}
</script>
