<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<wmsform:setpagetitle page="publishersAxis"/>
<wmsdialog:pantiltzoom page="publishersAxis"/>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}&vhost=${wmsutil:urlEncode(vhost)}
</c:set>

<p><a href="javascript:returnStreamFile()"><i class="fa fa-arrow-left"></i><wmsform:getlocalestring page="appconfig.publishers" obj="incoming.returnlink" /></a></p>
<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>

<re:mark>hidden attributes are added to query params so don't include them on AJAX calls</re:mark>
<fieldset>
	<form:hidden path="vhost" />
	<form:hidden path="uiAppName" />
	<form:hidden path="uiAppType" />
	<form:hidden path="instanceName"/>
	<form:hidden path="section" />
	<form:hidden path="version"/>
	<form:hidden path="driverName" value="Axis"/>
</fieldset>

<div class="row">
	<div class="col-md-12">
		<div class="media">
			<img src="img/axis-logo.png" />
			<div class="media-body">
				<p class="lead">
					<wmsform:getlocalestring page="appconfig.publishers.encoders.axis" obj="description" />
				</p>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-md-12">
		<wmsform:editproperty page="appconfig.publishers.encoders.axis" obj="publishersStreamFileName" required="true" />
		<div id="publishersStreamFileNameWarnings" class="alert alert-danger"></div>
		<!--rtsp is 554 and set by server. -->
		<wmsform:editproperty page="appconfig.publishers.encoders.axis" obj="cameraIpAddress" required="true" />
		<b><wmsform:getlocalestring page="appconfig.publishers.encoders.axis" obj="configurePTZ" /></b>
		<wmsform:editpropertycheckbox page="appconfig.publishers.encoders.axis" obj="ptzEnabled" onChange="enablePTZSettings()" />
		<div id="PTZSettings" style="display:none">
			<wmsform:editproperty page="appconfig.publishers.encoders.axis" obj="cameraUsername" required="true"/>
			<wmsform:editproperty page="appconfig.publishers.encoders.axis" obj="cameraPassword" inputType="password" required="true"/>
			<wmsform:editproperty page="appconfig.publishers.encoders.axis" obj="cameraPassword2" inputType="password" required="true"/>
		</div>
		<br/>
		<wmsform:buttonprimary page="appconfig.publishers.encoders.axis" obj="CreateConnectionRTSP" onClick="javascript:createConnection()" icon="fa fa-video-camera" />
		<br/>
	</div>
	<br />
	<b><wmsform:getlocalestring page="appconfig.publishers.encoders.axis" obj="configureEncoder" /></b>
	<div class="container">
		<wmsform:getlocalestring page="appconfig.publishers.encoders.axis" obj="configureEncoder2" />
	</div>
</div>

<c:set var="dupStreamFileNameError">
	<wmsform:getlocalestring page="common" obj="StreamFileName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="common" obj="emptyField"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="common" obj="invalidFileNameLength"/>
</c:set>
<c:set var="notANumberError">
	<wmsform:getlocalestring page="common" obj="invalidNumber"/>
</c:set>
<c:set var="passwordMisMatch">
	<wmsform:getlocalestring page="common" obj="passwordMisMatch"/>
</c:set>


<script>
//default page layout
$(document).ready(function()
{
	$('#publishersStreamFileNameWarnings').hide();
	$('#cameraIpAddress').removeAttr('readonly');
	$('#CreateConnectionRTSP').removeClass('disabled');
	enablePTZSettings();
});

function goToIncomingStreams()
{
        loadApplication('${wmsutil:escapeHtml(appName)}' , '${appType}' , 'incomingstreams_details' , 'instance=_definst_&stream=' + $("#publishersStreamFileName").val() + '.stream&uiAppType=' + $("#uiAppType").val() + '&uiAppName=' + $("#uiAppName").val());
}

function returnStreamFile()
{
	loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','publishers');
}

function createConnection()
{
	$('#publishersStreamFileNameErrorMsg').hide();
	$('#cameraIpAddressErrorMsg').hide();
	$('#cameraUsernameErrorMsg').hide();
	$('#cameraPasswordErrorMsg').hide();
	$('#cameraPassword2ErrorMsg').hide();
	postAJAXForm('applications/${appType}/publishers/encoder/AXIS.htm','appType=${appType}&appName=${wmsutil:urlEncode(appName)}');
}

function enablePTZSettings()
{
	var ptzEnabled = $("input[name='ptzEnabled']:checked").val();
	if (ptzEnabled == 'true')
		$("#PTZSettings").show();
	else
		$("#PTZSettings").hide();
}
</script>
