<%@ include file="/WEB-INF/jsp/taglibs.jsp"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<p><a href="javascript:loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','publishers')"><i class="fa fa-arrow-left"></i><wmsform:getlocalestring page="appconfig.publishers" obj="incoming.returnlink" /></a></p>
<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>

<div class="row">
	<wmsform:pageerror/>
	<wmsform:pagewarning/>
	<wmsform:pageinformation/>
</div>
<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="vhost"/>
	<form:hidden path="uiAppName" />
	<form:hidden path="uiAppType"/>
	<form:hidden path="section" />
	<form:hidden path="action" />
	<form:hidden path="publishUserOptions" />
</fieldset>
<div class="row">
	<div class="col-md-12">
		<!--<p><wmsform:getlocalestring page="appconfig.publishers" obj="header"/></p> -->
		<h4 style="padding-top: 0px">
			<wmsform:getlocalestring page="appconfig.publishers.encoders.gocoder" obj="name" />
		</h4>
		<div class="media">
			<a href="https://www.wowza.com/products/gocoder" target="_blank" class="pull-left"> <img
				class="img-responsive" src="img/iTunesArtwork.png" style="height: 90px; width: 90px">
			</a>
			<div class="media-body">
				<p class="lead">
					<wmsform:getlocalestring page="appconfig.publishers" obj="description1" />
				</p>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<h5>
			<wmsform:getlocalestring page="appconfig.publishers" obj="headerConfigure" />
		</h5>
		<p>
			<wmsform:getlocalestring page="appconfig.publishers" obj="description4" />
		</p>
		<p>
			<wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.step1" />
		<div class="row">
			<div class="col-md-12">
				<wmsform:editproperty page="appconfig.publishers.encoders" obj="hostServer" cssSize="col-md-4" cssClass="form-control" required="true"/>
				<div id="hostServerWarnings" class="alert alert-danger"></div>
				<wmsform:editproperty page="appconfig.publishers.encoders" obj="hostPort" cssSize="col-md-4" cssClass="form-control" required="true"/>
				<div id="hostPortWarnings" class="alert alert-danger"></div>
				<wmsform:editproperty page="appconfig.publishers.encoders" obj="streamName" cssSize="col-md-4" cssClass="form-control" required="true"/>
				<div id="streamNameWarnings" class="alert alert-danger"></div>
				<wmsform:editpropertydropdown page="appconfig.publishers.encoders" obj="publishUser" cssSize="col-md-4" cssClass="form-control"/>
			</div>
		</div>
		<script>
			/*
			$(document).ready(
					function() {
						setTimeout(function() {
							$("input[name='hostServer']:visible").keypress(function() {
								buildGoCoderUrl();
							});
							$("input[name='hostPort']:visible").keypress(function() {
								buildGoCoderUrl();
							});
							$("input[name='streamName']:visible").keypress(function() {
								buildGoCoderUrl();
							});
							$("select[id='publishUser']:visible").change(function() {
								buildGoCoderUrl();
							});
						}, 0);
						function buildGoCoderUrl() {
								var serv = $("input[name='hostServer']:visible").val();
								var port = $("input[name='hostPort']:visible").val();
								var stream = $("input[name='streamName']:visible").val();
								var user = $("select[id='publishUser']:visible option:selected").val();
								var newhref = "configure/?publishHost=" + serv + "&publishPort=" + port
										+ "&publishApplication=${appName}&publishStream=" + stream + "&publishUseTCP=YES";
								if(user!=undefined && user.trim() != "") {
									newhref += "&publishUser="+user;
								}
								$("#gocoderUrl").attr("href", encodeURIComponent("gocoder://"+newhref));
								$("#gocoderUrlAndroid").attr("href", encodeURIComponent("http://gocoder/"+newhref));
						}
						setTimeout(buildGoCoderUrl,0);
					}); */
		</script>
		<a class="btn btn-default" id="gocoderUrl" href="" onClick="javascript:iOsFormCheck()">
			<i class="fa fa-gear"></i> Auto-configure GoCoder for iOS
		</a>
		<a class="btn btn-default" id="gocoderUrlAndroid" href="" onClick="javascript:androidFormCheck()">
			<i class="fa fa-gear"></i> Auto-configure GoCoder for Android
		</a>
		<h5>
			<wmsform:getlocalestring page="appconfig.publishers" obj="headerEmail" />
		</h5>
		<p>
			<wmsform:getlocalestring page="appconfig.publishers" obj="description2" />
		</p>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<div class="row">
			<div class="input-group col-md-7">
				<input class="form-control" name="emailAddress" id="emailAddress" type="text" placeholder="Email Address"><span
					class="input-group-btn"><button class="btn btn-default" name="emailLink" id="emailLink"
						onClick="javascript:sendGoCoderEmail();return false;"> <!-- return false doesn't work in Firefox 33.1 -->
						<i class="fa fa-envelope"></i>
						<fmt:message key='common.email' />
					</button></span>
			</div>
		</div>
		<div class="help-block">
			<wmsform:getlocalestring page="appconfig.publishers" obj="tableFooter" />
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<p>
			<wmsform:getlocalestring page="appconfig.publishers" obj="tableMessage" />
		</p>
	</div>
</div>

<c:set var="emailSubject">
	<wmsform:getlocalestring page="appconfig.publishers" obj="email.subject" />
</c:set>

<c:set var="emailMessage">
	<wmsform:getlocalestring page="appconfig.publishers" obj="email.message" />
</c:set>

<c:set var="dupStreamFileNameError">
	<wmsform:getlocalestring page="common" obj="StreamFileName.dup"/>
</c:set>
<c:set var="blankFieldError">
	<wmsform:getlocalestring page="common" obj="emptyField"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="common" obj="invalidFileNameLength"/>
</c:set>
<c:set var="notANumberError">
	<wmsform:getlocalestring page="common" obj="invalidNumber"/>
</c:set>
<c:set var="invalidPortRangeError">
	<wmsform:getlocalestring page="common" obj="port.error"/>
</c:set>
<script>
$(document).ready(function() {
	$('#streamNameErrorMsg').hide();
	$('#hostPortErrorMsg').hide();
	$('#hostServerErrorMsg').hide();
	$('#streamNameWarnings').hide();
	$('#hostPortWarnings').hide();
	$('#hostServerWarnings').hide();

	$('#emailLink').click(function(event) {
		postAJAXForm('applications/${appType}/publishers/encoder/validateEncoder.htm','appName=${wmsutil:urlEncode(appName)}'); // vhost is included in form:hidden vhost=${wmsutil:urlEncode(vhost)}&

		//we are in a form:form where method is post (MainAppView.jsp). prevent that.
		event.preventDefault ? event.preventDefault() : event.returnValue = false;
		//when we return from controller, check action var before sending email
	});

	if ( $("#action").val() == "jspAction" )
	{
		action.value = "false";
		buildGoCoderUrl();
		var emailBody = "${emailMessage}";
		var url = $("#gocoderUrl").attr("href");
		var urlAndroid = $("#gocoderUrlAndroid").attr("href");
		emailBody += "GoCoder for iOS: "+url+" \r\n\r\nGoCoder for Android: "+urlAndroid;
		location.href = "mailto:" + $("#emailAddress").val() + "?subject=" + encodeURIComponent("${emailSubject}")
				+ "&body=" + encodeURIComponent(emailBody);
	}
});
function buildGoCoderUrl() {
	//without setter defined grab visible //var serv = $("input[name='hostServer']:visible").val();
	var serv = encodeURIComponent(hostServer.value);
	var port = encodeURIComponent(hostPort.value);
	var stream = encodeURIComponent(streamName.value);
	var user = encodeURIComponent($("select[id='publishUser'] option:selected").val());

	var newhref = "configure/?publishHost=" + serv + "&publishPort=" + port
			+ "&publishApplication=${appName}&publishStream=" + stream + "&publishUseTCP=YES";
	if (user !== undefined && user != "undefined") {
        if (user.trim() != "") {
            newhref += "&publishUser=" + encodeURIComponent(user);
        }
    }
	$("#gocoderUrl").attr("href", "gocoder://"+newhref);
	$("#gocoderUrlAndroid").attr("href", "http://gocoder/"+newhref);
}
function androidFormCheck() {
	if ( formCheck() )
	{
		buildGoCoderUrl();
		window.location.href = $("#gocoderUrlAndroid").attr("href");
	}
	else{
		event.preventDefault ? event.preventDefault() : event.returnValue = false;
	}
}
function iOsFormCheck() {
	if ( formCheck() )
	{
		buildGoCoderUrl();
		window.location.href = $("#gocoderUrl").attr("href");
	}
	else{
		event.preventDefault ? event.preventDefault() : event.returnValue = false;
	}
}
function validateStreamName() {
	$('#streamNameErrorMsg').hide();

	var ok=true;
	var sName= $("#streamName").val().trim();

	if(sName.lastIndexOf(".stream", sName.length - 7) != -1)
	{
		sName = sName.substr(0,sName.length-7);
	}
	if(!isValidStreamName(sName))
	{
		$('#streamNameErrorMsg').html("Stream File: ${invalidNameError}");
		$('#streamNameErrorMsg').show();
		ok=false;
	}
	if(!isValidFileNameLength(sName))
	{
		$('#streamNameErrorMsg').html("Stream File: ${invalidNameLengthError}");
		$('#streamNameErrorMsg').show();
		ok=false;
	}
	if(sName=="")
	{
		$('#streamNameErrorMsg').html("${blankFieldError}");
		$('#streamNameErrorMsg').show();
		ok=false;
	}


	return ok;
} //end validateStreamName

function validateHostPort() {
	$('#hostPortErrorMsg').hide();

	var ok=true;
	port = $("input[name='hostPort']:visible").val().trim();
	if (isNaN(port))
	{
		$('#hostPortErrorMsg').html("${notANumberError}");
		$('#hostPortErrorMsg').show();
		ok=false;
	}
	else if(port=="")
	{
		$('#hostPortErrorMsg').html("${blankFieldError}");
		$('#hostPortErrorMsg').show();
		ok=false;
	}
	else if ((parseInt(port,10) < 1) || (parseInt(port,10) > 65535))
	{
		$('#hostPortErrorMsg').html("${invalidPortRangeError}");
		$('#hostPortErrorMsg').show();
		ok=false;
	}
	return ok;
}

function validateHostServer() {
	$('#hostServerErrorMsg').hide();

	var ok=true;
	server = $("input[name='hostServer']:visible").val().trim();
	if(server=="")
	{
		$('#hostServerErrorMsg').html("${blankFieldError}");
		$('#hostServerErrorMsg').show();
		ok=false;
	}
	return ok;
}

function formCheck() {
	var ok = validateStreamName();
	ok &= validateHostPort();
	ok &= validateHostServer();
	return ok;
}
</script>
