<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<c:if test="${appType=='live' or appType=='liveedge' or appType=='livehttporigin'}">
<h5>Secure RTMP Connection</h5>
<p>To require that RTMP-based player applications connect to this application over a secure RTMP protocol connection (RTMPE, RTMPTE, or RTMPS), select this option.</p>
<blockquote><strong>Note:</strong> RTMPS network encryption security is enabled by the <a href="https://www.wowza.com/docs/how-to-get-ssl-certificates-from-the-streamlock-service" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Wowza StreamLock AddOn</a>.</blockquote>
</c:if>

<h5>SecureToken Playback Protection</h5>
<p>You can configure a Wowza Streaming Engine instance to use a Secure Hash Algorithm (SHA) or the Tiny Encryption Algorithm (TEA) and a private shared secret to generate a security token to help protect content against spoofing threats. Select a <strong>SecureToken</strong> option and then either enter a string of alphanumeric characters in the <strong>Shared Secret</strong> box or click <strong>Generate SecureToken Shared Secret</strong> to create the private shared secret. The server and client must use the same private shared secret to support SecureToken playback protection. See <a href="https://www.wowza.com/docs/how-to-protect-streaming-using-securetoken-in-wowza-streaming-engine" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Protect streaming using SecureToken in Wowza Streaming Engine</a>.</p>

<p><strong>SecureToken option - Protect all protocols using hash (SecureToken version&nbsp;2)</strong></p>

<p>Select this option to use SecureToken for all streaming protocols. You must specify the Secure Hash Algorithm (SHA) version that the Wowza Streaming Engine instance uses for hash generation in the <strong>Hash Algorithm</strong> list and a prefix value that the Wowza Streaming Engine instance uses to identify public SecureToken query parameters in client request URLs in the <strong>Hash Query Parameter Prefix</strong> box (or use the default prefix <em>wowzatoken</em>). The prefix value can only have the following characters that are safe to use in URLs: alphanumeric characters (a - z, A - Z, 0 - 9), percent sign (&#37;), period (.), underscore (&#95;), tilde (&#126;), and hyphen (&#45;).</p>

<p>For backward-compatibility with Flash-based players, you can select <strong>Use TEA for RTMP token security</strong>. This configures the server to use the Tiny Encryption Algorithm (TEA), instead of the selected hash algorithm, to generate an encrypted key as the security token when it gets a request for an RTMP stream. All other streaming protocols are protected by the selected hash algorithm.</p>

<p>You can enable an additional level of security by selecting <strong>Include client IP address in hash generation</strong>. This causes the hash that's generated to be unique for each connecting client.</p>

<blockquote><strong>Note:</strong> Your web server administrator must use the same shared secret value that's configured for the Wowza application to support SecureToken. JavaScript code shouldn't be used in the client webpage to generate the hash as the code is visible in the webpage source and would pose a potential security risk. See <a href="https://www.wowza.com/docs/how-to-protect-streaming-using-securetoken-in-wowza-streaming-engine#hash" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Hash generation</a>.</blockquote>

<p><strong>SecureToken option - Protect RTMP protocol using TEA (SecureToken version&nbsp;1)</strong></p>

<p>Select this option to use SecureToken for just the RTMP streaming protocol (other streaming protocols aren't protected if you select this option). This option configures the server to use the Tiny Encryption Algorithm (TEA) to generate an encrypted key as the security token when it gets a request for an RTMP stream.</p>

<blockquote><strong>Note:</strong> You must update the code for Flash-based players to use the same shared secret value that's configured for the Wowza application to support SecureToken. See <a href="https://www.wowza.com/docs/how-to-protect-streaming-using-securetoken-in-wowza-streaming-engine#flash" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Configuring players for SecureToken</a>.</blockquote>

<h5>Client Restrictions</h5>
<p>To manage playback connections from clients at specific IP addresses, select one of the following options:</p>
    <ul>
        <li>To allow connections from specific IP addresses, select <strong>Only allow playback from the following IP addresses</strong> and then enter the allowed IP addresses as a comma-separated list in the box.
        <li>To prevent connections from specific IP addresses (allowing all others), select <strong>Do NOT allow playback from the following IP addresses</strong> and then enter the restricted IP addresses as a comma-separated list in the box.
    </ul>