<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<div id="panTiltZoomModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="panTiltZoomModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				<div class="modal-header">
					<button type="button" class="close" onClick="javascript:panTiltZoomClose()">x</button>
					<h4 id="panTiltZoomModalLabel" class="modal-title"><wmsform:getlocalestring page="pantiltzoom" obj="pantiltzoomdialog.title"/></h4> <%-- ${page} --%>
				</div>
				<div class="modal-body">
					<p class="breakall"><wmsform:getlocalestring page="pantiltzoom" obj="pantiltzoomdialog.message"/> </p>
					<div id="ptz-preview">
					
					</div>
					<div id="ptz-controls">
						<div id="ptz-dpad">
							<div id="ptz-dpad-top" onclick="javascript:ptzUp();"></div>
							<div id="ptz-dpad-left" onclick="javascript:ptzLeft();"></div>
							<div id="ptz-dpad-center" onclick="javascript:ptzRecallHome();"></div>
							<div id="ptz-dpad-right" onclick="javascript:ptzRight();"></div>
							<div id="ptz-dpad-bottom" onclick="javascript:ptzDown();"></div>
						</div>
						<div id="ptz-zoom">
							<div id="ptz-zoom-in" onclick="javascript:ptzZoomIn();"></div>
							<div id="ptz-zoom-out" onclick="javascript:ptzZoomOut();"></div>
						</div>
					</div>
					<div id="imageCapture">
						<img src="" style="width:auto; height:180px;" id="image"/>
					</div>
					
					<div id="cameraWarning" class="alert alert-warning" > 
						<p class="text-warning"><wmsform:getlocalestring page="pantiltzoom" obj="pantiltzoomdialog.warning"/></p>
					</div>
				</div>
				<div class="modal-footer">
					<wmsform:buttonprimary page= "common" obj="close" onClick="javascript:panTiltZoomClose();" />
				</div>
			</fieldset></form>
		</div>
	</div>
</div>

<script type="text/javascript">

var refreshIntervalId = null;
var keepPolling = false;

$(document).ready(function() {
	$("#panTiltZoomModal").modal('show');
	$('#panTiltZoomModal').on('hidden.bs.modal', function() 
		{
			stopPolling();
	    });
	startPolling();
})

function startPolling()
{
	keepPolling = true;
	loadImage();
}

function stopPolling()
{
	keepPolling = false;
	if (refreshIntervalId != null)
	{
		clearTimeout(refreshIntervalId);
		refreshIntervalId = null;
	}
}

function panTiltZoomClose() {
	stopPolling();	
	$("#panTiltZoomModal").modal('hide');
}

function loadImage()
{
	var vhost = "${vhost}";
	var appName = "${appName}";
	var instanceName = "${instanceName}";
	var streamName = "${streamName}";
	var refreshRate = ${refreshRate};
	var refreshMinimumRate = ${refreshMinimumRate};

	$.ajax({
		url:"sourceControlDialog/getImage.jsdata?vhost=" + encodeURIComponent(vhost) + "&appName=" + encodeURIComponent(appName) + "&instance=" + encodeURIComponent(instanceName) + "&stream=" + encodeURIComponent(streamName),
        context: document.body,
        global: false
	}).fail(function(jqXHR, textStatus) {
		console.log("failed to get image");
	}).done(function(data, textStatus, jqXHR) {
		if (!(data instanceof Object) && data.substring(0, redirectLoginString.length) == redirectLoginString) {
			document.location = "login.htm" + location.hash;
			return;
		}
		if (data.length > 0)
			document.images['image'].src = "data:image/jpeg;base64," + data;
	});	
	if (keepPolling) {
	    if (refreshRate >= refreshMinimumRate) {
            refreshIntervalId = setTimeout(loadImage, refreshRate);
        } else {
        	refreshIntervalId = setTimeout(loadImage, refreshMinimumRate);
        }
    }
}
	
function ptzUp() {
	$.ajax({
		type: "POST",
		url:"sourceControlDialog/panTilt?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&instance=${wmsutil:urlEncode(instanceName)}&stream=${wmsutil:urlEncode(streamName)}&direction=PanTiltUp",
		context: document.body,
		global: false
	}).fail(function(jqXHR, testStatus) {
		console.log("failed to tilt up");
	}).done(function(data, textStatus, jqXHR){
		console.log("Tilted up");
	});
}

function ptzRight() {
	$.ajax({
		type: "POST",
		url:"sourceControlDialog/panTilt?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&instance=${wmsutil:urlEncode(instanceName)}&stream=${wmsutil:urlEncode(streamName)}&direction=PanTiltRight",
		context: document.body,
		global: false
	}).fail(function(jqXHR, testStatus) {
		console.log("failed to pan right");
	}).done(function(data, textStatus, jqXHR){
		console.log("pan right");
	});
}

function ptzDown() {
	$.ajax({
		type: "POST",
		url:"sourceControlDialog/panTilt?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&instance=${wmsutil:urlEncode(instanceName)}&stream=${wmsutil:urlEncode(streamName)}&direction=PanTiltDown",
		context: document.body,
		global: false
	}).fail(function(jqXHR, testStatus) {
		console.log("failed to tilt Down");
	}).done(function(data, textStatus, jqXHR){
		console.log("Tilted Down");
	});
}

function ptzLeft() {
	$.ajax({
		type: "POST",
		url:"sourceControlDialog/panTilt?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&instance=${wmsutil:urlEncode(instanceName)}&stream=${wmsutil:urlEncode(streamName)}&direction=PanTiltLeft",
		context: document.body,
		global: false
	}).fail(function(jqXHR, testStatus) {
		console.log("failed to pan left");
	}).done(function(data, textStatus, jqXHR){
		console.log("Panned left");
	});	
}

function ptzRecallHome() {
	$.ajax({
		type: "POST",
		url:"sourceControlDialog/panTilt?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&instance=${wmsutil:urlEncode(instanceName)}&stream=${wmsutil:urlEncode(streamName)}&direction=PanTiltHome",
		context: document.body,
		global: false
	}).fail(function(jqXHR, testStatus) {
		console.log("failed to pan home");
	}).done(function(data, textStatus, jqXHR){
		console.log("panned home");
	});
}

function ptzZoomIn() {
	$.ajax({
		type: "POST",
		url:"sourceControlDialog/zoom?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&instance=${wmsutil:urlEncode(instanceName)}&stream=${wmsutil:urlEncode(streamName)}&direction=ZoomIn",
		context: document.body,
		global: false
	}).fail(function(jqXHR, testStatus) {
		console.log("failed to zoom in");
	}).done(function(data, textStatus, jqXHR){
		console.log("zoomed in");
	});
}

function ptzZoomOut() {
	$.ajax({
		type: "POST",
		url:"sourceControlDialog/zoom?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&instance=${wmsutil:urlEncode(instanceName)}&stream=${wmsutil:urlEncode(streamName)}&direction=ZoomOut",
		context: document.body,
		global: false
	}).fail(function(jqXHR, testStatus) {
		console.log("failed to zoom out");
	}).done(function(data, textStatus, jqXHR){
		console.log("Zoomed out");
	});	
}
</script>