<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>
<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="action"/>

	<c:choose>
		<c:when test="${action=='new'}">
			<wmsform:buttonadd  onClick="javascript:saveMediaCacheSource()"/>

		</c:when>
		<c:otherwise>
			<wmsform:buttonsave  onClick="javascript:saveMediaCacheSource()"/>
		</c:otherwise>
	</c:choose>
	<c:choose>
		<c:when test="${action=='new' or action=='quickEdit'}">
			<wmsform:buttoncancel onClick="javascript:returnMediaCache()" />
		</c:when>
		<c:otherwise>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachesource/view.htm','sourceName=${sourceName}')" />
		</c:otherwise>
	</c:choose>
	<c:choose>
		<c:when test="${action=='new'}">
			<wmsform:editproperty page="mediaCache.source" obj="sourceName" required="true" cssClass="form-control" cssSize="col-md-6"/>
			<wmsform:editpropertytextarea page="mediaCache.source" obj="description" cssClass="form-control" autocapitalize="sentences"/>
			<wmsform:editpropertydropdown page="mediaCache.source" obj="sourceType" required="true" cssSize="col-md-4"/>
		</c:when>
		<c:otherwise>
			<form:hidden path="sourceName"/>
			<wmsform:editpropertytextarea page="mediaCache.source" obj="description" cssClass="form-control" autocapitalize="sentences"/>
			<form:hidden path="sourceType"/>
		</c:otherwise>
	</c:choose>

	<div id="prefixView" style="display:none">
		<wmsform:editproperty page="mediaCache.source" obj="prefix" required='true' cssClass="form-control" cssSize="col-md-6"/>
	</div>

	<div id="basePathView" style="display:none">
		<wmsform:editproperty page="mediaCache.source" obj="basePath" required='true' cssClass="form-control"/>
	</div>

	<wmsform:editproperty page="mediaCache.source" obj="awsAccessKeyID" cssClass="form-control"/>
	<wmsform:editproperty page="mediaCache.source" obj="awsSecretAccessKey" cssClass="form-control"/>
	<wmsform:editpropertycheckbox page="mediaCache.source" obj="useS3BucketName"/>

	<div id="azureOptions" style="display:none" >
	<wmsform:editproperty page="mediaCache.source" obj="azureAccountName" cssClass="form-control"/>
	<wmsform:editproperty page="mediaCache.source" obj="azureContainerName" cssClass="form-control"/>
	<wmsform:editproperty page="mediaCache.source" obj="azureAccountKey" cssClass="form-control"/>
	</div>

	<div id="googleCSOptions" style="display:none" >
	<wmsform:editproperty page="mediaCache.source" obj="googleServiceID" cssClass="form-control"/>
	<wmsform:editpropertydropdown page="mediaCache.source" obj="googleEncMethod" cssSize="col-md-3" />
	</div>

	<div id="googleCSFileOptions" style="display:none" >
	<wmsform:editproperty page="mediaCache.source" obj="googleServicePrivateKeyFile" cssClass="form-control"/>
	<wmsform:editproperty page="mediaCache.source" obj="googleServicePrivateKeyPassword" cssClass="form-control"/>
	</div>

	<div id="googleCSJSONOptions" style="display:none" >
	<wmsform:editpropertygooglecstextarea page="mediaCache.source" obj="googleServiceKey" cssClass="form-control" />
	</div>

	<div id="validateView" class="well " style="display:none">
			<h4><wmsform:getlocalestring page="mediaCache.source" obj="validationConfiguration"/></h4>
			<label class="control-label"><wmsform:getlocalestring page="mediaCache.source" obj="sampleContent"/></label>
			<input id="sampleContent" type="text" class="form-control" value=""/><br>
			<br>
			<wmsform:getlocalestring page="mediaCache.source" obj="willBeContent"/><br>
			<pre id="validationResult">http:///mycompany.com/media/sample.mp4</pre>
		</div>

	<label class="control-label"><wmsform:getlocalestring page="mediaCache.source" obj="minTTLstr"/></label>
	<table>
		<tr>
			<td align="center">
				  <wmsform:editpropertydropdown page="mediaCache.source" obj="minTTLDays"  cssClass="form-control" showTitle="no"/>
			</td>
			<td class="timecoloncolumn"> day(s) </td>
			<td>&nbsp;&nbsp;&nbsp;</td>
			<td align="center">
				<wmsform:editpropertydropdown page="mediaCache.source" obj="minTTLHours"  cssClass="form-control" showTitle="no"/>
			</td>
			<td class="timecoloncolumn"> : </td>
			<td align="center">
	 			<wmsform:editpropertydropdown page="mediaCache.source" obj="minTTLMinutes"  cssClass="form-control" showTitle="no"/>
			</td>
			<td class="timecoloncolumn"> : </td>
			<td align="center">
	 			<wmsform:editpropertydropdown page="mediaCache.source" obj="minTTLSeconds"  cssClass="form-control" showTitle="no"/>
			</td>
		</tr>
	</table>
	<div class="form-group error">
		<wmsform:errors path="minTTLErrorPlaceholder"/>
	</div>

	<label class="control-label"><wmsform:getlocalestring page="mediaCache.source" obj="maxTTLstr"/></label>
	<table>
		<tr>
			<td align="center">
				<wmsform:editpropertydropdown page="mediaCache.source" obj="maxTTLDays"  cssClass="form-control" showTitle="no"/>
			</td>
			<td class="timecoloncolumn"> day(s) </td>
			<td>&nbsp;&nbsp;&nbsp;</td>
			<td align="center">
				<wmsform:editpropertydropdown page="mediaCache.source" obj="maxTTLHours"  cssClass="form-control" showTitle="no"/>
			</td>
			<td class="timecoloncolumn"> : </td>
			<td align="center">
				<wmsform:editpropertydropdown page="mediaCache.source" obj="maxTTLMinutes"  cssClass="form-control" showTitle="no"/>
			</td>
			<td class="timecoloncolumn"> : </td>
			<td align="center">
				<wmsform:editpropertydropdown page="mediaCache.source" obj="maxTTLSeconds"  cssClass="form-control" showTitle="no"/>
			</td>
		</tr>
	</table>
	<div class="form-group error">
		<wmsform:errors path="maxTTLErrorPlaceholder"/>
	</div>
	<br>
	<c:choose>
		<c:when test="${action=='new'}">
			<wmsform:buttonadd  onClick="javascript:saveMediaCacheSource()"/>

		</c:when>
		<c:otherwise>
			<wmsform:buttonsave  onClick="javascript:saveMediaCacheSource()"/>
		</c:otherwise>
	</c:choose>
	<c:choose>
		<c:when test="${action=='new' or action=='quickEdit'}">
			<wmsform:buttoncancel onClick="javascript:returnMediaCache()" />
		</c:when>
		<c:otherwise>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachesource/view.htm','sourceName=${sourceName}')" />
		</c:otherwise>
	</c:choose>

</fieldset>

<script>
$('#prefix').keyup(function() {
	fixValidationResult();
});
$('#basePath').keyup(function() {
	fixValidationResult();
});
$('#sampleContent').keyup(function() {
	fixValidationResult();
});
$('#useS3BucketName1').click(function() {
	fixValidationResult();
});
$('#sourceType').change(function() {
	fixSourceType(true);
});
$('#googleEncMethod').change(function() {
	showGoogleEncOptions();
});

var hasErrors=false;
<form:errors path="*">
	hasErrors=true;
</form:errors>


function saveMediaCacheSource()
{
//	lastTab="Sources";
	postAJAXForm('server/mediacachesource/edit.htm','');
}

fixSourceType(false);

function showGoogleEncOptions()
{
    googleEncType = $('#googleEncMethod').val();
    srcType = $('#sourceType').val();

    if(srcType=='GoogleCloudStorage')
    {
        if ( googleEncType=='JSON' )
        {
        $('#googleCSFileOptions').hide();
		$("[googlecs-p12-help]").hide();
        $("[googlecs-json-help]").show();
    	$('#googleCSJSONOptions').show();
        }
        else if ( googleEncType=='P12' )
        {
        $('#googleCSFileOptions').show();
       	$("[googlecs-p12-help]").show();
        $("[googlecs-json-help]").hide();
    	$('#googleCSJSONOptions').hide();
        }
        else
        {
  		$('#googleCSFileOptions').hide();
       	$("[googlecs-p12-help]").hide();
       	$("[googlecs-json-help]").hide();
    	$('#googleCSJSONOptions').hide();
    	}
    }
    else
    {
   	$('#googleCSFileOptions').hide();
    $('#googleCSJSONOptions').hide();
    }

}

function fixSourceType(forced)
{
	srcType = $('#sourceType').val();
	if(srcType=='AmazonS3')
	{
		$('#sampleContent').val("amazons3/mybucket/mypath/sample.mp4");
		//$('#basePathCtrlGroup').hide();
		$('#useS3BucketNameCtrlGroup').show();
		$('#awsAccessKeyIDCtrlGroup').show();
		$('#awsSecretAccessKeyCtrlGroup').show();
		$('#prefixView').show();
		$('#basePathView').show();
		$('#awsOptions').show();
		$('#azureOptions').hide();
		$('#googleCSOptions').hide();
		$('#validateView').show();
		$("[aws-title-help]").show();
		$("[file-title-help]").hide();
		$("[http-title-help]").hide();
		$("[azure-title-help]").hide();
		$("[googlecs-title-help]").hide();
		$("[googlecs-main-help]").hide();
		$("[prefixbasepath-options-help]").show();
		$("[validation-options-help]").show();
		$("[aws-main-help]").show();
		if('${action}'=='new')
		{
			if(!hasErrors || forced)
			{
				$('#prefix').val("amazons3/");
				$('#basePath').val("http://s3.amazonaws.com/");
			}
		}
	}
	else if(srcType=='HTTP')
	{
		$('#sampleContent').val("http/mycompany.com/media/sample.mp4");
		$('#basePathCtrlGroup').show();
		$('#prefixView').show();
		$('#basePathView').show();
		$('#awsOptions').hide();
		$('#azureOptions').hide();
		$('#googleCSOptions').hide();
		$('#useS3BucketNameCtrlGroup').hide();
		$('#awsAccessKeyIDCtrlGroup').hide();
		$('#awsSecretAccessKeyCtrlGroup').hide();
		$('#validateView').show();
		$("[aws-title-help]").hide();
		$("[aws-main-help]").hide();
		$("[file-title-help]").hide();
		$("[http-title-help]").show();
		$("[azure-title-help]").hide();
		$("[azure-main-help]").hide();
		$("[googlecs-title-help]").hide();
		$("[googlecs-main-help]").hide();
		$("[prefixbasepath-options-help]").show();
		$("[validation-options-help]").show();
		if('${action}'=='new')
		{
			if(!hasErrors || forced)
			{
				$('#prefix').val("http/");
				$('#basePath').val("");
			}
		}

	}
	else if(srcType=='Azure')
	{
		$('#sampleContent').val("http/mycompany.com/media/sample.mp4");
		$('#basePathCtrlGroup').show();
		$('#prefixView').show();
		$('#basePathView').hide();
		$('#awsOptions').hide();
		$('#azureOptions').show();
		$('#googleCSOptions').hide();
		$('#useS3BucketNameCtrlGroup').hide();
		$('#awsAccessKeyIDCtrlGroup').hide();
		$('#awsSecretAccessKeyCtrlGroup').hide();
		$('#validateView').hide();
		$("[aws-title-help]").hide();
		$("[aws-main-help]").hide();
		$("[file-title-help]").hide();
		$("[http-title-help]").hide();
		$("[azure-title-help]").show();
		$("[googlecs-title-help]").hide();
		$("[googlecs-main-help]").hide();
		$("[validation-options-help]").hide();
		$("[prefixbasepath-options-help]").hide();
		$("[azure-main-help]").show();
		if('${action}'=='new')
		{
			if(!hasErrors || forced)
			{
				$('#prefix').val("http/");
				$('#basePath').val("");
			}
		}
	}
	else if(srcType=='GoogleCloudStorage')
	{
		$('#sampleContent').val("http/mycompany.com/media/sample.mp4");
		$('#basePathCtrlGroup').show();
		$('#prefixView').show();
		$('#basePathView').hide();
		$('#awsOptions').hide();
		$('#azureOptions').hide();
		$('#googleCSOptions').show();
		$('#useS3BucketNameCtrlGroup').hide();
		$('#awsAccessKeyIDCtrlGroup').hide();
		$('#awsSecretAccessKeyCtrlGroup').hide();
		$('#validateView').hide();
		$("[aws-title-help]").hide();
		$("[aws-main-help]").hide();
		$("[file-title-help]").hide();
		$("[http-title-help]").hide();
		$("[azure-title-help]").hide();
		$("[googlecs-title-help]").show();
		$("[googlecs-main-help]").show();
		$("[validation-options-help]").hide();
		$("[prefixbasepath-options-help]").hide();
		$("[azure-main-help]").hide();
		if('${action}'=='new')
		{
			if(!hasErrors || forced)
			{
				$('#prefix').val("http/");
				$('#basePath').val("");
			}
		}
		showGoogleEncOptions();
	}
	else { //file
		$('#sampleContent').val("path1/data/media/sample.mp4");
		$('#basePathCtrlGroup').show();
		$('#prefixView').show();
		$('#basePathView').show();
		$('#awsOptions').hide();
		$('#azureOptions').hide();
		$('#useS3BucketNameCtrlGroup').hide();
		$('#awsAccessKeyIDCtrlGroup').hide();
		$('#awsSecretAccessKeyCtrlGroup').hide();
		$('#validateView').show();
		$("[aws-title-help]").hide();
		$("[aws-main-help]").hide();
		$("[file-title-help]").show();
		$("[http-title-help]").hide();
		$("[azure-title-help]").hide();
		$("[azure-main-help]").hide();
		$("[googlecs-title-help]").hide();
		$("[googlecs-main-help]").hide();
		$("[prefixbasepath-options-help]").show();
		$("[validation-options-help]").show();
		if('${action}'=='new')
		{
			if(!hasErrors || forced)
			{
				$('#prefix').val("path1/");
				$('#basePath').val("");
			}
		}
	}

	if('${sourceName}'=='dvrorigin')
	{
		$('#sampleContent').val("dvrorigin/mycompany.com/media/sample.mp4");
		$('#basePathCtrlGroup').hide();
	}
	fixValidationResult();

}

function fixValidationResult()
{
	str = $('#sampleContent').val();
	prefix=$('#prefix').val();
	idx = str.indexOf(prefix);
	if( idx == 0)
	{
		postfix= str.substring(prefix.length);
		if($('#useS3BucketName1').is(':checked')?1:0)
		{
			bucket = postfix.substring(0,postfix.indexOf("/"));
			postfix = postfix.substring(postfix.indexOf("/")+1);
			str=insertString($('#basePath').val(),7,bucket+".") + postfix;
		}
		else
		{
			str=$('#basePath').val() + postfix;
		}
	}
	$('#validationResult').text(str);
}

function insertString(sourceStr, index, insertStr) {
	if (index > 0)
		return sourceStr.substring(0, index) + insertStr + sourceStr.substring(index, sourceStr.length);
	else
		return insertStr + sourceStr;
	};
</script>
