<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<wmsform:setpagetitle page="transcoder.template" appName="${encodeName}"/>

<div class="col-md-8 main-content">
	<wmsform:rightrailhideshow/>
	<p><wmsform:getlocalestring page="transcoder.template.encode" obj="header"/></p>
	<sec:authorize access="hasAnyRole('admin')">
		<p>
			<wmsform:buttonedit onClick="editEncode()"/>
			<c:choose>
				<c:when test="${not encodeEnabled}">
			   		<wmsform:button page="transcoder.template.encode" obj="enableEncodeBtn" onClick="javascript:enabledEncode()"/>
			   	</c:when>
			   	<c:otherwise>
					<wmsform:button page="transcoder.template.encode" obj="disableEncodeBtn" onClick="javascript:disableEncode()" />
			   	</c:otherwise>
		   	</c:choose>
	   	</p>
	</sec:authorize>
	<wmsform:viewproperty page="transcoder.template.encode" obj="streamName"/>
	<wmsform:viewproperty page="transcoder.template.encode" obj="description" showEmptyString="-Not Set-"/>
	<hr />
	<h4><wmsform:getlocalestring page="transcoder.template.encode" obj="videoSectionTitle"/></h4>
	<c:set var="videoCodec">
		<wmsform:objvalue page="transcoder.template.encode" obj="videoCodec"/>
	</c:set>
	<wmsform:viewproperty page="transcoder.template.encode" obj="videoCodec" getLocalString="true"/>
	<c:if test="${fn:toLowerCase(videoCodec)!='disable' && fn:toLowerCase(videoCodec)!='passthru' }">

		<label class="control-label"><wmsform:getlocalestring page="transcoder.template.encode" obj="videoBitrate"/></label>
		<c:set var="videoBitrate">
			<wmsform:objvalue page="transcoder.template.encode" obj="videoBitrate"/>
		</c:set>
		<c:choose>
			<c:when test="${fn:contains(fn:toLowerCase(videoBitrate), 'sourcevideobitrate')}">
				Source Video Bitrate
			</c:when>
			<c:otherwise>
				<wmsform:viewpropertyint page="transcoder.template.encode" obj="videoBitrate" showTitle="false"/>
			</c:otherwise>
		</c:choose>
		<wmsform:viewproperty page="transcoder.template.encode" obj="implementation" getLocalString="true" />
		<div id="GPUDataDisplay">
			<c:set var="GPUFirstAvail">
				<wmsform:getlocalestring page="transcoder.template.encode" obj="GPUIDList.first"/>
			</c:set>
			<wmsform:viewpropertyint page="transcoder.template.encode" obj="GPUID" showEmptyValue="-1" showEmptyString="${GPUFirstAvail}"/>
		</div>
		<wmsform:viewproperty page="transcoder.template.encode" obj="profile" getLocalString="true"/>

		<wmsform:viewproperty page="transcoder.template.encode" obj="followSource"/>
		<wmsform:viewpropertyint page="transcoder.template.encode" obj="interval" showTitle="false" showEmptyValue="0" showEmptyString=" "/>
		<hr>
		<h4><wmsform:getlocalestring page="transcoder.template.encode" obj="frameSizeSectionTitle"/></h4>
		<wmsform:viewproperty page="transcoder.template.encode" obj="fitMode"/>
		<wmsform:viewpropertyint page="transcoder.template.encode" obj="width" showEmptyValue="0" showEmptyString="-Not Set-"/>
		<wmsform:viewpropertyint page="transcoder.template.encode" obj="height" showEmptyValue="0" showEmptyString="-Not Set-"/>
		<label class="control-label">Crop</label>
		<p class="help-block"><wmsform:getlocalestring page="transcoder.template.encode" obj="cropHelp"/></p>
		<table cellpadding="5">
			<tr>
				<td>
				</td>
				<td class="text-center">
					<wmsform:objvalue page="transcoder.template.encode" obj="cropTop"/>
				</td>
				<td>
				</td>
			</tr>
			<tr>
				<td class="text-center">
					<wmsform:objvalue page="transcoder.template.encode" obj="cropLeft"/>
				</td>
				<td class="text-center">
					<i class="fa fa-picture-o fa-4x"></i>
				</td>
				<td class="text-center">
					<center><wmsform:objvalue page="transcoder.template.encode" obj="cropRight"/><center>
				</td>
			</tr>
			<tr>
				<td>
				</td>
				<td class="text-center">
					<wmsform:objvalue page="transcoder.template.encode" obj="cropBottom" />
				</td>
				<td>
				</td>
			</tr>
		</table>
	</c:if>

	<hr>
	<h4><wmsform:getlocalestring page="transcoder.template.encode" obj="audioSectionTitle"/></h4>

	<c:set var="audioCodec">
		<wmsform:objvalue page="transcoder.template.encode" obj="audioCodec"/>
	</c:set>
	<wmsform:viewproperty page="transcoder.template.encode" obj="audioCodec" getLocalString="true" />
	<c:if test="${fn:toLowerCase(audioCodec)!='disable' && fn:toLowerCase(audioCodec)!='passthru' }">
		<label class="control-label"><wmsform:getlocalestring page="transcoder.template.encode" obj="audioBitrate"/></label>
		<c:set var="audioBitrate">
			<wmsform:objvalue page="transcoder.template.encode" obj="audioBitrate"/>
		</c:set>
		<c:choose>
			<c:when test="${fn:contains(fn:toLowerCase(audioBitrate), 'sourceaudiobitrate')}">
				Source Audio Bitrate
			</c:when>
			<c:otherwise>
				<wmsform:viewpropertyint page="transcoder.template.encode" obj="audioBitrate" showTitle="false"/>
			</c:otherwise>
		</c:choose>
	</c:if>
	<hr>
	<wmstable:viewoverlays page="transcoder.template" decodeOverlay="false"/>

</div>
<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
	<jsp:include page="HelpEncode_${formData.currentLocale}.jsp" flush="true" />
</div>
<script>

setEncodeImplementation();

function setEncodeImplementation()
{
	if ($('#implementation').val() == "QuickSync")
	{
		$('#GPUDataDisplay').hide();
	}
	else
	{
		$('#GPUDataDisplay').show();
	}
}

function editEncode()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent('server/transcoderencode/edit.htm','vhost=${wmsutil:urlEncode(vhost)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName=${wmsutil:urlEncode(encodeName)}&action=')
	}
	else
	{
		loadAjaxMainContent("applications/${appType}/transcoderencode/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName=${wmsutil:urlEncode(encodeName)}&action=");
	}
}

function enabledEncode()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent('server/transcoderencode/enable.htm','vhost=${wmsutil:urlEncode(vhost)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName=${wmsutil:urlEncode(encodeName)}&action=')
	}
	else
	{
		loadAjaxMainContent("applications/${appType}/transcoderencode/enable.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName=${wmsutil:urlEncode(encodeName)}&action=");
	}
}

function disableEncode()
{
	if("${appType}" == "")
	{
		loadAjaxMainContent('server/transcoderencode/disable.htm','vhost=${wmsutil:urlEncode(vhost)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName=${wmsutil:urlEncode(encodeName)}&action=')
	}
	else
	{
		loadAjaxMainContent("applications/${appType}/transcoderencode/disable.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName=${wmsutil:urlEncode(encodeName)}&action=");
	}
}

</script>
<script type="text/javascript">
	$(function () {
		$("[data-toggle='tooltip']").tooltip();
	});
</script>




