<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="addSMILStreamModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="addSMILStreamModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="addSMILStreamForm" class="form-modal">
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close"
							onClick="javascript:addSMILStreamClose()">x</button>
						<h4 id="addSMILStreamModalLabel" class="modal-title">
							<wmsform:getlocalestring page="newSMILStreamDialog" obj="header" />
						</h4>
					</div>
					<div class="modal-body">
						<p><wmsform:getlocalestring page="newSMILStreamDialog" obj="message" /></p>
						<wmsform:editpropertydropdown page="newSMILStreamDialog" obj="tagType" cssClassTitle="control-label" required="yes" bind="false" options="video,audio,textstream"/>
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="newSMILStreamDialog.error" class="alert alert-danger" style="display: none"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel onClick="javascript:addSMILStreamClose()" />
								<wmsform:buttonadd onClick="javascript:doAddSMILStream()" />
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>
function addSMILStreamShow() 
{
	$('#addSMILStreamModal').on("shown.bs.modal", function() {
	});
	$('#addSMILStreamModal').modal('show');	
}

function addSMILStreamClose() 
{
	$('#addSMILStreamModal').modal('hide');
}

function doAddSMILStream() 
{
	smilType = $('#tagType').val();
	$('#addSMILStreamModal').on('hidden.bs.modal', function() {
		if("${appType}" == "")
		{
			loadAjaxMainContent("server/vhost/smilfile/stream/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&smilFile=${wmsutil:urlEncode(smilName)}&idx=-1&smilType="+smilType+"&action=new");
		}
		else 
		{
			loadAjaxMainContent("applications/${appType}/smilfile/stream/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&smilFile=${wmsutil:urlEncode(smilName)}&idx=-1&smilType="+smilType+"&action=new");
		}
	});
	addSMILStreamClose();
}

</script>