<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="streamMapModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="streamMapModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="streamMapForm" class="form-modal"> 
				<fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:streamMapClose()">x</button>
					<h4 id="addStreamMapModalLabel" class="modal-title"><wmsform:getlocalestring page="buyDRMStreamMapDialog" obj="newHeader"/></h4>
					<h4 id="editStreamMapModalLabel" class="modal-title"><wmsform:getlocalestring page="buyDRMStreamMapDialog" obj="editHeader"/></h4>
				  </div>
				  <div class="modal-body">
							<wmsform:editproperty page="buyDRMStreamMapDialog" obj="streamName" cssClassTitle="control-label" required="yes" bind="false"/>
							<wmsform:editproperty page="buyDRMStreamMapDialog" obj="keyID" cssClassTitle="control-label" required="yes" bind="false"/>
							<wmsform:editproperty page="buyDRMStreamMapDialog" obj="contentID" cssClassTitle="control-label" required="yes" bind="false"/>
							<wmsform:editproperty page="buyDRMStreamMapDialog" obj="mediaID" cssClassTitle="control-label" required="yes" bind="false"/>
				  </div>
				  <div class="modal-footer">
					<div class="row">
						<div class="col-md-8">
							<div id="buyDRMStreamMapDialog.error" class="alert alert-danger" style="display:none"></div>
						</div>
						<div class="col-md-4">
							<wmsform:buttoncancel  onClick="javascript:streamMapClose()"/>
							<wmsform:buttonadd onClick="javascript:streamMapSave()" />
							<wmsform:buttonprimary page="${page}" obj="apply" onClick="javascript:streamMapSave()" icon="icon-hdd icon-white"/>
						</div>
					</div>
				  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<c:set var="streamNameEmpty">
	<wmsform:getlocalestring page="appconfig.drm_buydrm" obj="drmBuyDRMStreamName.empty"/>
</c:set>
<c:set var="streamNameError">
	<wmsform:getlocalestring page="common" obj="invalidStreamName"/>
</c:set>
<c:set var="keyIDEmpty">
	<wmsform:getlocalestring page="appconfig.drm_buydrm" obj="drmBuyDRMKeyID.empty"/>
</c:set>
<c:set var="contentIDEmpty">
	<wmsform:getlocalestring page="appconfig.drm_buydrm" obj="drmBuyDRMContentID.empty"/>
</c:set>
<c:set var="mediaIDEmpty">
	<wmsform:getlocalestring page="appconfig.drm_buydrm" obj="drmBuyDRMMediaID.empty"/>
</c:set>
<script>
var editIdx=-1;
function streamMapShow(orgIdx) {
	editIdx=orgIdx;
	if(orgIdx<0)
	{
		$("#apply").hide();
		$("#editStreamMapModalLabel").hide();
		$("#addbtn").show();
		$("#addStreamMapModalLabel").show();
		$("#streamName").val("");
		$("#keyID").val("");
		$("#contentID").val("");
		$("#mediaID").val("");
	}
	else 
	{
		$("#apply").show();
		$("#editStreamMapModalLabel").show();
		$("#addbtn").hide();
		$("#addStreamMapModalLabel").hide();

		$("#streamName").val(tblDataStreamMap[orgIdx].streamName);
		$("#keyID").val(tblDataStreamMap[orgIdx].keyID);
		$("#contentID").val(tblDataStreamMap[orgIdx].contentID);
		$("#mediaID").val(tblDataStreamMap[orgIdx].mediaID);
		
	}
	$("#buyDRMStreamMapDialog\\.error").html(""); 
	$("#buyDRMStreamMapDialog\\.error").hide(); 

	$('#streamNameCtrlGroup').attr('class', 'form-group');
	$('#streamNameErrorMsg').html("");
	$('#streamNameErrorMsg').hide();
	$('#keyIDCtrlGroup').attr('class', 'form-group');
	$('#keyIDErrorMsg').html("");
	$('#keyIDErrorMsg').hide();
	$('#contentIDCtrlGroup').attr('class', 'form-group');
	$('#contentIDErrorMsg').html("");
	$('#contentIDErrorMsg').hide();
	$('#mediaIDCtrlGroup').attr('class', 'form-group');
	$('#mediaIDErrorMsg').html("");
	$('#mediaIDErrorMsg').hide();

	$('#streamMapModal').on("shown.bs.modal", function() {
	});
	$('#streamMapModal').modal('show');	
}

function streamMapClose() {
	$('#streamMapModal').modal('hide');
}

function streamMapSave() {
	//need to check values
	var ok=true;
	
	if($("#streamName").val() =="")
	{
		$('#streamNameCtrlGroup').attr('class', 'form-group has-error');
		$('#streamNameErrorMsg').html("${streamNameEmpty}");
		$('#streamNameErrorMsg').show();
		ok=false;
	}
	else
	{
		var nApp=$("#streamName").val().trim();
	 	if (!isValidStreamName(nApp))
		{
			$('#streamNameCtrlGroup').attr('class', 'form-group has-error');
			$('#streamNameErrorMsg').html("${streamNameError}");
			$('#streamNameErrorMsg').show();
			ok=false;
		}
	 	else
		{
			$('#streamNameCtrlGroup').attr('class', 'form-group');
			$('#streamNameErrorMsg').html("");
			$('#streamNameErrorMsg').hide();
		}
	}
	if($("#keyID").val() =="")
	{
		$('#keyIDCtrlGroup').attr('class', 'form-group has-error');
		$('#keyIDErrorMsg').html("${keyIDEmpty}");
		$('#keyIDErrorMsg').show();
		ok=false;
	}
	else
	{
 		$('#keyIDCtrlGroup').attr('class', 'form-group');
 		$('#keyIDErrorMsg').html("");
		$('#keyIDErrorMsg').hide();
	}
	if($("#contentID").val() =="")
	{
		$('#contentIDCtrlGroup').attr('class', 'form-group has-error');
		$('#contentIDErrorMsg').html("${contentIDEmpty}");
		$('#contentIDErrorMsg').show();
		ok=false;
	}
	else
	{
 		$('#contentIDCtrlGroup').attr('class', 'form-group');
 		$('#contentIDErrorMsg').html("");
		$('#contentIDErrorMsg').hide();
	}
	if($("#mediaID").val() =="")
	{
		$('#mediaIDCtrlGroup').attr('class', 'form-group has-error');
		$('#mediaIDErrorMsg').html("${mediaIDEmpty}");
		$('#mediaIDErrorMsg').show();
		ok=false;
	}
	else
	{
 		$('#mediaIDCtrlGroup').attr('class', 'form-group');
 		$('#mediaIDErrorMsg').html("");
		$('#mediaIDErrorMsg').hide();
	}
	if(!ok)
	{
		return;	
	}
	if(editIdx<0)
	{
		var newItem = new Object();
		newItem.orgIdx = tblIdxStreamMap++;
		newItem.order = tblIdxStreamMap;
		newItem.removed=false;
		newItem.streamName=$("#streamName").val();
		newItem.keyID=$("#keyID").val();
		newItem.contentID=$("#contentID").val();
		newItem.mediaID=$("#mediaID").val();
		tblDataStreamMap.push(newItem);
	}
	else 
	{
		tblDataStreamMap[editIdx].streamName=$("#streamName").val();
		tblDataStreamMap[editIdx].keyID=$("#keyID").val();
		tblDataStreamMap[editIdx].contentID=$("#contentID").val();
		tblDataStreamMap[editIdx].mediaID=$("#mediaID").val();		
	}
	streamMapClose();
	updateTableStreamMap();
}

</script>