<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteApplicationModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteApplicationModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteApplicationClose()">x</button>
						<h4 id="deleteApplicationModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteApplicationDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteApplicationDialog.message"/> <b>${wmsutil:escapeHtml(appName)}</b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteApplicationDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteApplicationClose()"/>
						<wmsform:buttonok  onClick="javascript:doDeleteApplication()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>

function deleteApplicationShow() {
	$('#deleteApplicationModal').on("shown.bs.modal", function() {
	});
	$('#deleteApplicationModal').modal('show');	
}

function deleteApplicationClose() {
	$('#deleteApplicationModal').modal('hide');
}

function doDeleteApplication() {
	lastApplication='app';
	lastApplicationType='new';
	lastApplicationSection='new';
	$('#deleteApplicationModal').on('hidden.bs.modal', function() {
		postAJAXForm('applications/delete.htm','vhostName=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}');
		lastMC_page="";
		lastMC_params="";
	});
	deleteApplicationClose();
}

</script>