<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteMediaCacheSourceModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteMediaCacheSourceModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteMediaCacheSourceClose()">x</button>
						<h4 id="deleteMediaCacheSourceModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteMediaCacheSourceDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteMediaCacheSourceDialog.message"/> <b><span id="deleteSourceName"></span></b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteMediaCacheSourceDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteMediaCacheSourceClose()"/>
						<wmsform:buttonok  onClick="javascript:doDelete()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>

function deleteMediaCacheSourceShow() {
	document.getElementById("deleteSourceName").innerHTML=deleteSourceName;
	$('#deleteMediaCacheSourceModal').on("shown.bs.modal", function() {
	});
	$('#deleteMediaCacheSourceModal').modal('show');	
}

function deleteMediaCacheSourceClose() {
	$('#deleteMediaCacheSourceModal').modal('hide');
}

function doDelete() {
	$('#deleteMediaCacheSourceModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent("server/mediacache/deletesource.htm", "sourceName="+encodeURIComponent(deleteSourceName)); 	
	});
	deleteMediaCacheSourceClose();
	return;
}

</script>