<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="streamMapModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="streamMapModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="streamMapForm" class="form-modal"> 
				<fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:streamMapClose()">x</button>
					<h4 id="addStreamMapModalLabel" class="modal-title"><wmsform:getlocalestring page="verimatrixStreamMapDialog" obj="newHeader"/></h4>
					<h4 id="editStreamMapModalLabel" class="modal-title"><wmsform:getlocalestring page="verimatrixStreamMapDialog" obj="editHeader"/></h4>
				  </div>
				  <div class="modal-body">
							<wmsform:editproperty page="verimatrixStreamMapDialog" obj="streamName" cssClassTitle="control-label" required="yes" bind="false" cssSize="col-md-6"/>
							<wmsform:editproperty page="verimatrixStreamMapDialog" obj="resID" cssClassTitle="control-label" required="yes" bind="false" cssSize="col-md-6"/>
							<wmsform:editproperty page="verimatrixStreamMapDialog" obj="posCount" cssClassTitle="control-label" required="yes" bind="false" cssSize="col-md-2"/>
							<wmsform:editproperty page="verimatrixStreamMapDialog" obj="keyInterval" cssClassTitle="control-label" required="yes" bind="false" cssSize="col-md-2"/>
				  </div>
				  <div class="modal-footer">
					<div class="row">
						<div class="col-md-8">
							<div id="verimatrixStreamMapDialog.error" class="alert alert-danger" style="display:none"></div>
						</div>
						<div class="col-md-4">
							<wmsform:buttoncancel  onClick="javascript:streamMapClose()"/>
							<wmsform:buttonadd onClick="javascript:streamMapSave()" />
							<wmsform:buttonprimary page="${page}" obj="apply" onClick="javascript:streamMapSave()" icon="icon-hdd icon-white"/>
						</div>
					</div>
				  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<c:set var="streamNameEmpty">
	<wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="streamName.empty"/>
</c:set>
<c:set var="streamNameDuplicate">
	<wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="streamName.duplicate"/>
</c:set>
<c:set var="streamNameError">
	<wmsform:getlocalestring page="common" obj="invalidStreamName"/>
</c:set>
<c:set var="resIDEmpty">
	<wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="resourceId.empty"/>
</c:set>
<c:set var="resIDError">
	<wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="resourceId.invalid"/>
</c:set>
<c:set var="posCountEmpty">
	<wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="positionCount.empty"/>
</c:set>
<c:set var="posCountError">
	<wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="positionCount.invalid"/>
</c:set>
<c:set var="keyIntervalEmpty">
	<wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="keyRotationInterval.empty"/>
</c:set>
<c:set var="keyIntervalError">
	<wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="keyRotationInterval.invalid"/>
</c:set>
<script>
var editIdx=-1;
function streamMapShow(orgIdx) {
	editIdx=orgIdx;
	if(orgIdx<0)
	{
		$("#apply").hide();
		$("#editStreamMapModalLabel").hide();
		$("#addbtn").show();
		$("#addStreamMapModalLabel").show();
		$("#streamName").val("");
		$("#resID").val("");
		$("#posCount").val("");
		$("#keyInterval").val("");
	}
	else 
	{
		$("#apply").show();
		$("#editStreamMapModalLabel").show();
		$("#addbtn").hide();
		$("#addStreamMapModalLabel").hide();
		$("#streamName").val(tblDataStreamMap[orgIdx].streamName);
		$("#resID").val(tblDataStreamMap[orgIdx].resID);
		$("#posCount").val(tblDataStreamMap[orgIdx].posCount);
		$("#keyInterval").val(tblDataStreamMap[orgIdx].keyInterval);
	}
	$("#verimatrixStreamMapDialog.error").html(""); 
	$("#verimatrixStreamMapDialog.error").hide();
	$("#streamNameCtrlGroup").attr('class', 'form-group');
	$("#streamNameErrorMsg").html("");
	$("#streamNameErrorMsg").hide();
	$("#resIDCtrlGroup").attr('class', 'form-group');
	$("#resIDErrorMsg").html("");
	$("#resIDErrorMsg").hide();
	$("#posCountCtrlGroup").attr('class', 'form-group');
	$("#posCountErrorMsg").html("");
	$("#posCountErrorMsg").hide();
	$("#keyIntervalCtrlGroup").attr('class', 'form-group');
	$("#keyIntervalErrorMsg").html("");
	$("#keyIntervalErrorMsg").hide();

	$('#streamMapModal').on("shown.bs.modal", function() {
	});
	$('#streamMapModal').modal('show');	
}

function streamMapClose() {
	$('#streamMapModal').modal('hide');
}

function streamMapSave() {
	//need to check values
	var ok=true;
	$("#streamNameCtrlGroup").attr('class', 'form-group');
	$("#streamNameErrorMsg").html("");
	$("#resIDCtrlGroup").attr('class', 'form-group');
	$("#resIDErrorMsg").html("");
	$("#posCountCtrlGroup").attr('class', 'form-group');
	$("#posCountErrorMsg").html("");
	$("#keyIntervalCtrlGroup").attr('class', 'form-group');
	$("#keyIntervalErrorMsg").html("");
	
	if($("#streamName").val() =="")
	{
		$("#streamNameCtrlGroup").attr('class', 'form-group has-error');
		$("#streamNameErrorMsg").html("${streamNameEmpty}");
		$("#streamNameErrorMsg").show();
		ok=false;
	}
	else if (checkStreamNameExists($("#streamName").val(), editIdx))
	{
		$("#streamNameCtrlGroup").attr('class', 'form-group has-error');
		$("#streamNameErrorMsg").html("${streamNameDuplicate}");
		$("#streamNameErrorMsg").show();
		ok=false;
	}
	else
	{
		var nApp=$("#streamName").val().trim();
		// An exception to the normal stream name rules...
		// We don't support "*" as a wildcard in Verimatrix stream map files, so to eliminate confusion
		// we won't allow the user to specify it in the UI.
	 	if (!isValidStreamName(nApp) || (nApp.indexOf("*") >= 0))
		{
			$('#streamNameCtrlGroup').attr('class', 'form-group has-error');
			$('#streamNameErrorMsg').html("${streamNameError}"+" *");
			$("#streamNameErrorMsg").show();
			ok=false;
		}
	 	else
		{
			$('#streamNameCtrlGroup').attr('class', 'form-group');
			$('#streamNameErrorMsg').html("");
			$("#streamNameErrorMsg").show();
		}
	}
	if($("#resID").val() =="")
	{
		$("#resIDCtrlGroup").attr('class', 'form-group has-error');
		$("#resIDErrorMsg").html("${resIDEmpty}");
		$("#resIDErrorMsg").show();
		ok=false;
	}
	else
	{
		
		///^([!#$&-;=?-[]_a-z~]|%[0-9a-fA-F]{2})+$/
		/// !#$&-;=?-[]_~%
		//  `@^*()+{}|\:"'<>,./
				
		//!#$&-;=?-[]_
		var regExp = /[!#$&-;=?\-\[\]_%0-9a-zA-Z]+$/;
		var urlChars = regExp.test($("#resID").val());
	 	if (!urlChars)
		//var num = parseInt($("#resID").val());
	 	//if (isNaN(num) || (num <= 0))
		{
			$('#resIDCtrlGroup').attr('class', 'form-group has-error');
			$('#resIDErrorMsg').html("${resIDError}");
			$("#resIDErrorMsg").show();
			ok=false;
		}
	 	else
		{
			$('#resIDCtrlGroup').attr('class', 'form-group');
			$('#resIDErrorMsg').html("");
			$("#resIDErrorMsg").show();
		}
	}
	
	if($("#posCount").val() =="")
	{
		$("#posCountCtrlGroup").attr('class', 'form-group has-error');
		$("#posCountErrorMsg").html("${posCountEmpty}");
		$("#posCountErrorMsg").show();
		ok=false;
	}
	else
	{
		var num=parseInt($("#posCount").val());
	 	if (isNaN(num) || (num < 0))
		{
			$('#posCountCtrlGroup').attr('class', 'form-group has-error');
			$('#posCountErrorMsg').html("${posCountError}");
			$("#posCountErrorMsg").show();
			ok=false;
		}
	 	else
		{
			$('#posCountCtrlGroup').attr('class', 'form-group');
			$('#posCountErrorMsg').html("");
			$("#posCountErrorMsg").show();
		}
	}
	
	if($("#keyInterval").val() =="")
	{
		$("#keyIntervalCtrlGroup").attr('class', 'form-group has-error');
		$("#keyIntervalErrorMsg").html("${keyIntervalEmpty}");
		$("#keyIntervalErrorMsg").show();
		ok=false;
	}
	else
	{
		var num=parseInt($("#keyInterval").val());
	 	if (isNaN(num) || (num < 0))
		{
			$('#keyIntervalCtrlGroup').attr('class', 'form-group has-error');
			$('#keyIntervalErrorMsg').html("${keyIntervalError}");
			$("#keyIntervalErrorMsg").show();
			ok=false;
		}
	 	else
		{
			$('#keyIntervalCtrlGroup').attr('class', 'form-group');
			$('#keyIntervalErrorMsg').html("");
			$("#keyIntervalErrorMsg").show();
		}
	}
	
	if(!ok)
	{
		return;	
	}
	if(editIdx<0)
	{
		var newItem = new Object();
		newItem.orgIdx = tblIdxStreamMap++;
		newItem.order = tblIdxStreamMap;
		newItem.removed=false;
		newItem.streamName=$("#streamName").val();
		newItem.resID=$("#resID").val();
		newItem.posCount=$("#posCount").val();
		newItem.keyInterval=$("#keyInterval").val();
		tblDataStreamMap.push(newItem);
	}
	else 
	{
		tblDataStreamMap[editIdx].streamName=$("#streamName").val();
		tblDataStreamMap[editIdx].resID=$("#resID").val();
		tblDataStreamMap[editIdx].posCount=$("#posCount").val();
		tblDataStreamMap[editIdx].keyInterval=$("#keyInterval").val();		
	}
	streamMapClose();
	updateTableStreamMap();
}

</script>