<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="txtObj" required="true" rtexprvalue="true" %>
<%@ attribute name="cssClass" required="false" rtexprvalue="true" %>
<%@ attribute name="cssSize" required="false" rtexprvalue="true" %>

<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>

<div class="${ctrlGroupClass}"  id="${obj}CtrlGroup">
	<re:mark>Title</re:mark>
	<label class="control-label"><fmt:message key="${page}.${txtObj}" /></label>
	<wmsform:editpropertycheckbox page="${page}" obj="${obj}"/>
	<div class="indent1">
		<wmsform:editproperty page="${page}" obj="${txtObj}" cssClass="${cssClass}" cssSize="${cssSize}" showTitle="no"/>
	</div>
</div>

<script>
	setTxtDisabled();
  	document.getElementById('${obj}1').onclick=setTxtDisabled;
	function setTxtDisabled()
	{
		if(document.getElementById('${obj}1').checked)
		{
			document.getElementById('${txtObj}').disabled=false;
		}
		else {
			document.getElementById('${txtObj}').disabled=true;
			document.getElementById('${txtObj}').value="";			
		}
	}
</script>